/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.internationalization.commands;

import java.util.Collection;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.internationalization.common.utils.InternationalizationAnnotationResourceUtils;
import org.eclipse.papyrus.infra.internationalization.modelresource.InternationalizationPreferenceModel;
import org.eclipse.papyrus.infra.internationalization.utils.InternationalizationPreferenceModelUtils;

public class InternationalizationPreferenceCommandFactory {
    private final ModelSet modelSet;

    public InternationalizationPreferenceCommandFactory(ModelSet modelSet) {
        this.modelSet = modelSet;
    }

    public Command createTogglePrivateStorageCommand() {
        Object result = UnexecutableCommand.INSTANCE;
        final InternationalizationPreferenceModel internationalizationPrefModel = InternationalizationPreferenceModelUtils.getInternationalizationPreferenceModel(this.modelSet);
        if (internationalizationPrefModel != null) {
            result = new AbstractToggleCommand("Toggle Private Editor Layout"){

                public void execute() {
                    EAnnotation annotationToMove = InternationalizationAnnotationResourceUtils.getInternationalizationAnnotation((Resource)internationalizationPrefModel.getResource());
                    if (!internationalizationPrefModel.isLegacyMode()) {
                        Resource internationalizationPrefResource = annotationToMove.eResource();
                        URI sharedURI = internationalizationPrefModel.getPrivateResourceURI();
                        Resource notationResource = InternationalizationPreferenceCommandFactory.this.modelSet.getResource(sharedURI, false);
                        if (notationResource != null && notationResource.isLoaded()) {
                            InternationalizationPreferenceCommandFactory.this.moveContents(internationalizationPrefResource, notationResource, annotationToMove);
                            if (internationalizationPrefResource.getContents().isEmpty()) {
                                InternationalizationPreferenceCommandFactory.this.modelSet.getResourcesToDeleteOnSave().add(internationalizationPrefResource.getURI());
                            }
                        }
                    } else {
                        URI privateURI = internationalizationPrefModel.getSharedResourceURI();
                        Resource internationalizationPrefResource = InternationalizationPreferenceCommandFactory.this.modelSet.getURIConverter().exists(privateURI, null) ? InternationalizationPreferenceCommandFactory.this.modelSet.getResource(privateURI, true) : InternationalizationPreferenceCommandFactory.this.modelSet.createResource(privateURI);
                        InternationalizationPreferenceCommandFactory.this.modelSet.getResourcesToDeleteOnSave().remove(privateURI);
                        Resource notationResource = annotationToMove.eResource();
                        InternationalizationPreferenceCommandFactory.this.moveContents(notationResource, internationalizationPrefResource, annotationToMove);
                    }
                    internationalizationPrefModel.loadModel(InternationalizationPreferenceCommandFactory.this.modelSet.getURIWithoutExtension());
                }
            };
        }
        return result;
    }

    protected void moveContents(Resource fromResource, Resource toResource, EAnnotation annotation) {
        EObject toReplace = null;
        Collection existingAnnotations = EcoreUtil.getObjectsByType((Collection)toResource.getContents(), (EClassifier)annotation.eClass());
        if (existingAnnotations != null && existingAnnotations.isEmpty()) {
            for (EObject existingAnnotation : existingAnnotations) {
                if (!(existingAnnotation instanceof EAnnotation) || !((EAnnotation)existingAnnotation).getSource().equals("Internationalization")) continue;
                toReplace = existingAnnotation;
            }
        }
        if (toReplace != null) {
            EcoreUtil.replace(toReplace, (EObject)annotation);
        } else {
            toResource.getContents().add((Object)annotation);
        }
    }

    private static abstract class AbstractToggleCommand
    extends AbstractCommand {
        public AbstractToggleCommand(String label) {
            super(label);
        }

        protected boolean prepare() {
            return true;
        }

        public void undo() {
            this.execute();
        }

        public void redo() {
            this.execute();
        }
    }
}

