/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.wizards.pages;

import java.util.Objects;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.papyrus.uml.diagram.wizards.messages.Messages;
import org.eclipse.papyrus.uml.diagram.wizards.pages.INewPapyrusModelPage;
import org.eclipse.papyrus.uml.diagram.wizards.pages.NewModelWizardData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;

public class PapyrusProjectCreationPage
extends WizardNewProjectCreationPage
implements INewPapyrusModelPage {
    private Text fileName;
    private boolean fileNameEdited;
    private Listener fileNameModifyListener = new Listener(){

        public void handleEvent(Event e) {
            if (!Objects.equals(PapyrusProjectCreationPage.this.fileName.getText(), PapyrusProjectCreationPage.this.getProjectName())) {
                PapyrusProjectCreationPage.this.fileNameEdited = true;
            }
            if (PapyrusProjectCreationPage.this.wizardData != null) {
                PapyrusProjectCreationPage.this.wizardData.setModelFileName(PapyrusProjectCreationPage.this.fileName.getText());
            }
            boolean valid = PapyrusProjectCreationPage.this.validatePage();
            PapyrusProjectCreationPage.this.setPageComplete(valid);
        }
    };
    private NewModelWizardData wizardData;

    public PapyrusProjectCreationPage(String pageName) {
        super(pageName);
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        Composite composite = (Composite)this.getControl();
        composite.setLayoutData((Object)new GridData(4, 1024, true, false));
        GridLayout gridLayout = new GridLayout(1, false);
        composite.setLayout((Layout)gridLayout);
        this.setControl((Control)composite);
        Group group = PapyrusProjectCreationPage.createGroup(composite, Messages.PapyrusProjectCreationPage_0);
        this.fileName = new Text((Composite)group, 2048);
        this.fileName.setLayoutData((Object)new GridData(4, 4, true, false));
        this.fileName.addListener(24, this.fileNameModifyListener);
        this.setPageComplete(false);
        String[] workingSetIds = new String[]{"org.eclipse.ui.resourceWorkingSetPage", "org.eclipse.jdt.ui.JavaWorkingSetPage"};
        this.createWorkingSetGroup(composite, null, workingSetIds);
    }

    private static Group createGroup(Composite parent, String name) {
        Group group = new Group(parent, 0);
        group.setText(name);
        GridLayout layout = new GridLayout(1, true);
        layout.marginHeight = 5;
        layout.marginWidth = 5;
        group.setLayout((Layout)layout);
        GridData data = new GridData(4, 4, true, true);
        group.setLayoutData((Object)data);
        return group;
    }

    @Override
    public void setNewModelWizardData(NewModelWizardData wizardData) {
        this.wizardData = wizardData;
    }

    @Override
    public NewModelWizardData getNewModelWizardData() {
        return this.wizardData;
    }

    protected boolean validatePage() {
        String projectName = this.getProjectName();
        if (this.fileName != null && this.fileNameEdited) {
            if (this.fileName.getText().trim().isEmpty()) {
                this.setErrorMessage(Messages.PapyrusProjectCreationPage_3);
                return false;
            }
        } else if (this.fileName != null && projectName != null && !Objects.equals(this.fileName.getText(), projectName)) {
            this.fileName.setText(this.getProjectName());
        }
        return super.validatePage();
    }

    public String getFileName() {
        return this.fileName.getText();
    }

    public boolean canFlipToNextPage() {
        boolean canFlip = true;
        if (!this.verifyProjectName()) {
            canFlip = false;
        }
        if (!this.validatePage()) {
            canFlip = false;
        }
        return canFlip && super.canFlipToNextPage();
    }

    private boolean verifyProjectName() {
        IProject[] projects;
        IProject[] iProjectArray = projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject iproject = iProjectArray[n2];
            if (this.getProjectName() == null) {
                this.setErrorMessage(Messages.PapyrusProjectCreationPage_page_null_name_desc);
                return false;
            }
            if (this.getProjectName().equalsIgnoreCase(iproject.getName())) {
                this.setErrorMessage(String.valueOf(Messages.PapyrusProjectCreationPage_page_same_case_desc) + iproject.getName());
                return false;
            }
            ++n2;
        }
        return true;
    }

    public void performHelp() {
        PlatformUI.getWorkbench().getHelpSystem().displayHelp("org.eclipse.papyrus.uml.diagram.wizards.NewProject");
    }
}

