/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.etfw.feedback.perfsuite.xml;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.ptp.internal.etfw.feedback.perfsuite.xml.CPUTime;
import org.eclipse.ptp.internal.etfw.feedback.perfsuite.xml.PS_Report;
import org.xml.sax.Attributes;

public class PS_ResourceReport
extends PS_Report {
    private static final String PIDTAG = "pid";
    private static final String STARTTIMETAG = "starttime";
    private static final String EXITCODETAG = "exitcode";
    private static final String EXIT_TYPE_ATT = "type";
    private static final String SAMPLESTAG = "samples";
    private static final String SAMPLES_FREQUENCY_ATT = "frequency";
    private static final String LOADAVGSTAG = "loadavgs";
    private static final String LOADAVGS_MIN_ATT = "min";
    private static final String LOADAVGS_MAX_ATT = "max";
    private static final String LOADAVGS_RESOLUTION_ATT = "resolution";
    private static final String LOADAVGS_OUTOFRANGE_ATT = "outofrange";
    private static final String LOADAVGTAG = "loadavg";
    private static final String LOADAVG_LOAD_ATT = "load";
    private static final String MAXLOADSTAG = "maxloads";
    private static final String MAXLOADTAG = "maxload";
    private static final String MAXLOAD_INTERVAL_ATT = "interval";
    private static final String MAXLOAD_UNIT_ATT = "unit";
    private static final String MAXRSSTAG = "maxrss";
    private static final String MAXVMTAG = "maxvm";
    private static final String USERTIMETAG = "usertime";
    private static final String SYSTEMTIMETAG = "systemtime";
    private static final String CPUTIMETAG = "cputime";
    private static final String MAJORTAG = "major";
    private static final String MINORTAG = "minor";
    private static final String SWAPSTAG = "swaps";
    private static final String DATEFORMAT = "EEE MMM dd HH:mm:ss yyyy";
    private String tmpValue = "";
    private long pid;
    private Date startTime;
    private int exitCode;
    private String exitType;
    private int samplesFrequency;
    private long samples;
    private float loadavgsMin;
    private float loadavgsMax;
    private float loadavgsResolution;
    private long loadavgsOutofrange;
    private Map<Float, Long> loadavgMap;
    private float tmpLoadavg;
    private Map<Integer, Float> maxloadMap;
    private int tmpMaxload;
    private float maxrss;
    private float maxvm;
    private CPUTime cputime;
    private float userTime;
    private float systemTime;
    private long majorFaults;
    private long minorFaults;
    private long swaps;

    PS_ResourceReport() {
    }

    @Override
    void startElement(String uri, String localName, String qName, Attributes atts) {
        if (qName.equals(EXITCODETAG)) {
            this.exitType = atts.getValue(EXIT_TYPE_ATT);
        } else if (qName.equals(SAMPLESTAG)) {
            this.samplesFrequency = Integer.parseInt(atts.getValue(SAMPLES_FREQUENCY_ATT));
        } else if (qName.equals(LOADAVGSTAG)) {
            this.loadavgsMin = Float.parseFloat(atts.getValue(LOADAVGS_MIN_ATT));
            this.loadavgsMax = Float.parseFloat(atts.getValue(LOADAVGS_MAX_ATT));
            this.loadavgsResolution = Float.parseFloat(atts.getValue(LOADAVGS_RESOLUTION_ATT));
            this.loadavgsOutofrange = Long.parseLong(atts.getValue(LOADAVGS_OUTOFRANGE_ATT));
            this.loadavgMap = new TreeMap<Float, Long>();
        } else if (qName.equals(LOADAVGTAG)) {
            this.tmpLoadavg = Float.parseFloat(atts.getValue(LOADAVG_LOAD_ATT));
        } else if (qName.equals(MAXLOADSTAG)) {
            this.maxloadMap = new TreeMap<Integer, Float>();
        } else if (qName.equals(MAXLOADTAG)) {
            this.tmpMaxload = Integer.parseInt(atts.getValue(MAXLOAD_INTERVAL_ATT));
            if (atts.getValue(MAXLOAD_UNIT_ATT).equals("minutes")) {
                this.tmpMaxload *= 60;
            }
        }
        this.tmpValue = "";
    }

    @Override
    void characters(char[] ch, int start, int length) {
        String tmpString = new String(ch, start, length);
        if (tmpString.length() != 0) {
            this.tmpValue = this.tmpValue.length() == 0 ? tmpString : this.tmpValue.concat(tmpString);
        }
    }

    @Override
    void endElement(String uri, String localName, String qName) {
        this.tmpValue = this.tmpValue.trim();
        if (qName.equals(PIDTAG)) {
            this.pid = Long.parseLong(this.tmpValue);
        } else if (qName.equals(EXITCODETAG)) {
            this.exitCode = Integer.parseInt(this.tmpValue);
        } else if (qName.equals(STARTTIMETAG)) {
            Locale savedDefaultLocale = Locale.getDefault();
            if (!savedDefaultLocale.equals(Locale.US)) {
                Locale.setDefault(Locale.US);
            }
            SimpleDateFormat df = new SimpleDateFormat(DATEFORMAT);
            try {
                this.startTime = df.parse(this.tmpValue);
            }
            catch (ParseException e) {
                throw new RuntimeException(e);
            }
            if (!savedDefaultLocale.equals(Locale.US)) {
                Locale.setDefault(savedDefaultLocale);
            }
        } else if (qName.equals(SAMPLESTAG)) {
            this.samples = Long.parseLong(this.tmpValue);
        } else if (qName.equals(LOADAVGTAG)) {
            this.loadavgMap.put(Float.valueOf(this.tmpLoadavg), Long.parseLong(this.tmpValue));
        } else if (qName.equals(MAXLOADTAG)) {
            this.maxloadMap.put(this.tmpMaxload, Float.valueOf(Float.parseFloat(this.tmpValue)));
        } else if (qName.equals(MAXRSSTAG)) {
            this.maxrss = Float.parseFloat(this.tmpValue);
        } else if (qName.equals(MAXVMTAG)) {
            this.maxvm = Float.parseFloat(this.tmpValue);
        } else if (qName.equals(USERTIMETAG)) {
            this.userTime = Float.parseFloat(this.tmpValue);
        } else if (qName.equals(SYSTEMTIMETAG)) {
            this.systemTime = Float.parseFloat(this.tmpValue);
        } else if (qName.equals(CPUTIMETAG)) {
            this.cputime = new CPUTime(this.userTime, this.systemTime);
        } else if (qName.equals(MAJORTAG)) {
            this.majorFaults = Long.parseLong(this.tmpValue);
        } else if (qName.equals(MINORTAG)) {
            this.minorFaults = Long.parseLong(this.tmpValue);
        } else if (qName.equals(SWAPSTAG)) {
            this.swaps = Long.parseLong(this.tmpValue);
        }
        this.tmpValue = "";
    }

    @Override
    public String toString() {
        StringBuilder res = new StringBuilder();
        res.append(super.toString());
        res.append("  Pid:        " + this.pid + "\n");
        res.append("  Start Time: " + this.startTime + "\n");
        res.append("  Exit Code:  " + this.exitCode + "\n");
        res.append("  Exit Type:  " + this.exitType + "\n");
        res.append("  Samples Frequency:  " + this.samplesFrequency + " (seconds)\n");
        res.append("  Samples:  " + this.samples + "\n");
        res.append("  Load Average Min:  " + this.loadavgsMin + "\n");
        res.append("  Load Average Max:  " + this.loadavgsMax + "\n");
        res.append("  Load Average Resolution:  " + this.loadavgsResolution + "\n");
        res.append("  Number of Measurements where Load Average is Out of Range (>= 100):  " + this.loadavgsOutofrange + "\n");
        for (Map.Entry<Float, Long> entry : this.loadavgMap.entrySet()) {
            res.append("  Load: " + entry.getKey() + ", Number of Occurrances: " + entry.getValue() + "\n");
        }
        for (Map.Entry<Number, Number> entry : this.maxloadMap.entrySet()) {
            res.append("  Max Load Interval: " + entry.getKey() + " (seconds), Max Load: " + entry.getValue() + "\n");
        }
        res.append("  Max RSS:  " + this.maxrss + " (MB)\n");
        res.append("  Max VM:   " + this.maxvm + " (MB)\n");
        res.append("  User Time:   " + this.userTime + " (seconds)\n");
        res.append("  System Time:   " + this.systemTime + " (seconds)\n");
        res.append("  Major Faults:   " + this.majorFaults + "\n");
        res.append("  Minor Faults:   " + this.minorFaults + "\n");
        res.append("  Swaps:   " + this.swaps + "\n");
        return res.toString();
    }

    public long getPid() {
        return this.pid;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public int getExitCode() {
        return this.exitCode;
    }

    public String getExitType() {
        return this.exitType;
    }

    public int getSamplesFrequency() {
        return this.samplesFrequency;
    }

    public long getSamples() {
        return this.samples;
    }

    public float getLoadavgsMin() {
        return this.loadavgsMin;
    }

    public float getLoadavgsMax() {
        return this.loadavgsMax;
    }

    public float getLoadavgsResolution() {
        return this.loadavgsResolution;
    }

    public long getLoadavgsOutofrange() {
        return this.loadavgsOutofrange;
    }

    public Map<Float, Long> getLoadavgMap() {
        return this.loadavgMap;
    }

    public Map<Integer, Float> getMaxloadMap() {
        return this.maxloadMap;
    }

    public float getMaxrss() {
        return this.maxrss;
    }

    public float getMaxvm() {
        return this.maxvm;
    }

    public CPUTime getCputime() {
        return this.cputime;
    }

    public float getUserTime() {
        return this.userTime;
    }

    public float getSystemTime() {
        return this.systemTime;
    }

    public long getMajorFaults() {
        return this.majorFaults;
    }

    public long getMinorFaults() {
        return this.minorFaults;
    }

    public long getSwaps() {
        return this.swaps;
    }
}

