/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.pldt.mpi.analysis.analysis;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.ptp.pldt.mpi.analysis.cdt.graphs.IBlock;
import org.eclipse.ptp.pldt.mpi.analysis.cdt.graphs.impl.Block;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MPIBlock
extends Block {
    protected List<String> use_;
    protected List<String> def_;
    protected Hashtable<String, List<IBlock>> in_;
    protected Hashtable<String, List<IBlock>> out_;
    protected Hashtable<String, List<IBlock>> gen_;
    protected Hashtable<String, List<IBlock>> kill_;
    protected Hashtable<String, List<IBlock>> duPred_;
    protected Hashtable<String, List<IBlock>> duSucc_;
    protected List<IBlock> df_;
    protected List<IBlock> condBlock_;
    protected List<IBlock> joinBlocks_;
    protected List<String> phiVar_;
    protected List<String> usedPhiVar_;
    protected boolean phi;
    protected List<String> mvVar_;
    protected List<String> oldMVvar_;
    private boolean mv;
    boolean sliced;
    int hasAlready;
    int work;
    boolean withBreak = false;
    boolean withContinue = false;

    public MPIBlock() {
        this.init();
    }

    public MPIBlock(IASTNode content, IASTStatement parent, int type) {
        super(content, parent, type);
        this.init();
    }

    public MPIBlock(IASTExpression expr, IASTStatement parent) {
        super(expr, parent);
        this.init();
    }

    public MPIBlock(IASTStatement stmt) {
        super(stmt);
        this.init();
    }

    public MPIBlock(IASTName label) {
        super(label);
        this.init();
    }

    private void init() {
        this.use_ = new ArrayList<String>();
        this.def_ = new ArrayList<String>();
        this.in_ = new Hashtable();
        this.out_ = new Hashtable();
        this.gen_ = new Hashtable();
        this.kill_ = new Hashtable();
        this.duPred_ = new Hashtable();
        this.duSucc_ = new Hashtable();
        this.df_ = new ArrayList<IBlock>();
        this.condBlock_ = new ArrayList<IBlock>();
        this.joinBlocks_ = new ArrayList<IBlock>();
        this.phi = false;
        this.phiVar_ = new ArrayList<String>();
        this.usedPhiVar_ = new ArrayList<String>();
        this.mvVar_ = new ArrayList<String>();
        this.oldMVvar_ = new ArrayList<String>();
        this.sliced = false;
        this.mv = false;
    }

    public void setCond(List<IBlock> b) {
        this.condBlock_ = b;
    }

    public List<IBlock> getCond() {
        return this.condBlock_;
    }

    public List<IBlock> getJoin() {
        return this.joinBlocks_;
    }

    public List<String> getUse() {
        return this.use_;
    }

    public void setUse(List<String> set) {
        this.use_ = set;
    }

    public List<String> getDef() {
        return this.def_;
    }

    public void setDef(List<String> set) {
        this.def_ = set;
    }

    public void setIn(Hashtable<String, List<IBlock>> in) {
        this.in_ = in;
    }

    public void setOut(Hashtable<String, List<IBlock>> out) {
        this.out_ = out;
    }

    public Hashtable<String, List<IBlock>> getIn() {
        return this.in_;
    }

    public Hashtable<String, List<IBlock>> getOut() {
        return this.out_;
    }

    public void setGen(Hashtable<String, List<IBlock>> gen) {
        this.gen_ = gen;
    }

    public void setKill(Hashtable<String, List<IBlock>> kill) {
        this.kill_ = kill;
    }

    public Hashtable<String, List<IBlock>> getGen() {
        return this.gen_;
    }

    public Hashtable<String, List<IBlock>> getKill() {
        return this.kill_;
    }

    public void setDUPred(Hashtable<String, List<IBlock>> pred) {
        this.duPred_ = pred;
    }

    public void setDUSucc(Hashtable<String, List<IBlock>> succ) {
        this.duSucc_ = succ;
    }

    public Hashtable<String, List<IBlock>> getDUPred() {
        return this.duPred_;
    }

    public Hashtable<String, List<IBlock>> getDUSucc() {
        return this.duSucc_;
    }

    public void setDF(List<IBlock> list) {
        this.df_ = list;
    }

    public List<IBlock> getDF() {
        return this.df_;
    }

    public void setPhi() {
        this.phi = true;
    }

    public boolean hasPhi() {
        return this.phi;
    }

    public List<String> getPhiVar() {
        return this.phiVar_;
    }

    public List<String> getUsedPhiVar() {
        return this.usedPhiVar_;
    }

    public List<String> getMVvar() {
        return this.mvVar_;
    }

    public void setMVvar(List<String> list) {
        this.mvVar_ = list;
    }

    public List<String> getOldMVvar() {
        return this.oldMVvar_;
    }

    public void setOldMVvar(List<String> list) {
        this.oldMVvar_ = list;
    }

    public void setMV(boolean val) {
        this.mv = val;
    }

    public boolean getMV() {
        return this.mv;
    }

    public void print() {
        super.print();
        System.out.print("joins to: ");
        Iterator<Object> i = this.joinBlocks_.iterator();
        while (i.hasNext()) {
            System.out.print(String.valueOf(i.next().getID()) + ", ");
        }
        System.out.println(" ");
        System.out.print(" use = ");
        i = this.use_.iterator();
        while (i.hasNext()) {
            System.out.print(String.valueOf((String)i.next()) + ", ");
        }
        System.out.print(" def = ");
        i = this.def_.iterator();
        while (i.hasNext()) {
            System.out.print(String.valueOf((String)i.next()) + ", ");
        }
        System.out.println(" ");
        System.out.println("Flow dependence: ");
        Enumeration<String> e = this.duSucc_.keys();
        while (e.hasMoreElements()) {
            String var = e.nextElement();
            List<IBlock> list = this.duSucc_.get(var);
            if (list.isEmpty()) continue;
            System.out.print(String.valueOf(var) + " to: ");
            Iterator<IBlock> i2 = list.iterator();
            while (i2.hasNext()) {
                System.out.print(String.valueOf(i2.next().getID()) + ", ");
            }
            System.out.println(" ");
        }
        System.out.println(" ");
        if (this.mv) {
            System.out.println("------ Multi-valued ------");
        } else {
            System.out.println("------ Single-valued ------");
        }
        System.out.println(" ");
        System.out.println(" ");
    }

    public static void clean() {
        counter = 0;
    }

    public String toString() {
        super.print();
        StringBuffer buf = new StringBuffer();
        buf.append("joins to: ");
        Iterator<Object> i = this.joinBlocks_.iterator();
        while (i.hasNext()) {
            buf.append(String.valueOf(i.next().getID()) + ", ");
        }
        buf.append(" \n");
        buf.append(" use = ");
        i = this.use_.iterator();
        while (i.hasNext()) {
            buf.append(String.valueOf((String)i.next()) + ", ");
        }
        buf.append(" def = ");
        i = this.def_.iterator();
        while (i.hasNext()) {
            buf.append(String.valueOf((String)i.next()) + ", ");
        }
        buf.append(" \n");
        buf.append("Flow dependence: \n");
        Enumeration<String> e = this.duSucc_.keys();
        while (e.hasMoreElements()) {
            String var = e.nextElement();
            List<IBlock> list = this.duSucc_.get(var);
            if (list.isEmpty()) continue;
            buf.append(String.valueOf(var) + " to: ");
            Iterator<IBlock> i2 = list.iterator();
            while (i2.hasNext()) {
                buf.append(String.valueOf(i2.next().getID()) + ", ");
            }
            buf.append(" \n");
        }
        buf.append(" \n");
        if (this.mv) {
            buf.append("------ Multi-valued ------\n");
        } else {
            buf.append("------ Single-valued ------\n");
        }
        return buf.toString();
    }
}

