/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.demo.controls;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.rap.demo.controls.ExampleTab;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;

public class ScaleTab
extends ExampleTab {
    private static final String PROP_CONTEXT_MENU = "contextMenu";
    private static final String PROP_SELECTION_LISTENER = "selectionListener";
    Scale scale;
    Spinner minimumSpinner;
    Spinner maximumSpinner;
    Spinner selectionSpinner;
    Spinner incrementSpinner;
    Spinner pageIncrementSpinner;

    public ScaleTab() {
        super("Scale");
        this.setDefaultStyle(256);
    }

    @Override
    protected void createStyleControls(Composite parent) {
        this.createStyleButton(parent, "HORIZONTAL", 256, 16, true);
        this.createStyleButton(parent, "VERTICAL", 512, 16, false);
        this.createStyleButton("BORDER", 2048);
        this.createOrientationButton();
        this.createVisibilityButton();
        this.createEnablementButton();
        this.createBgColorButton();
        this.createBgImageButton();
        this.createCursorCombo();
        this.minimumSpinner = this.createSpinnerControl(parent, "Minimum", 0, 100000, 0);
        this.minimumSpinner.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                int minimum = ScaleTab.this.minimumSpinner.getSelection();
                ScaleTab.this.scale.setMinimum(minimum);
            }
        });
        this.maximumSpinner = this.createSpinnerControl(parent, "Maximum", 0, 100000, 100);
        this.maximumSpinner.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                int maximum = ScaleTab.this.maximumSpinner.getSelection();
                ScaleTab.this.scale.setMaximum(maximum);
            }
        });
        this.selectionSpinner = this.createSpinnerControl(parent, "Selection", 0, 100000, 0);
        this.selectionSpinner.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                int selection = ScaleTab.this.selectionSpinner.getSelection();
                ScaleTab.this.scale.setSelection(selection);
            }
        });
        this.incrementSpinner = this.createSpinnerControl(parent, "Increment", 0, 100000, 1);
        this.incrementSpinner.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                int increment = ScaleTab.this.incrementSpinner.getSelection();
                ScaleTab.this.scale.setIncrement(increment);
            }
        });
        this.pageIncrementSpinner = this.createSpinnerControl(parent, "Page Increment", 0, 100000, 10);
        this.pageIncrementSpinner.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                int pageIncrement = ScaleTab.this.pageIncrementSpinner.getSelection();
                ScaleTab.this.scale.setPageIncrement(pageIncrement);
            }
        });
        this.createPropertyCheckbox("Add Context Menu", PROP_CONTEXT_MENU);
        this.createPropertyCheckbox("Add Selection Listener", PROP_SELECTION_LISTENER);
    }

    @Override
    protected void createExampleControls(Composite parent) {
        parent.setLayout((Layout)new RowLayout(512));
        int style = this.getStyle();
        this.scale = new Scale(parent, style);
        if (this.hasCreateProperty(PROP_CONTEXT_MENU)) {
            Menu scaleMenu = new Menu((Control)this.scale);
            MenuItem scaleMenuItem = new MenuItem(scaleMenu, 8);
            scaleMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    String message = "You requested a context menu for the Scale";
                    MessageDialog.openInformation((Shell)ScaleTab.this.scale.getShell(), (String)"Information", (String)message);
                }
            });
            scaleMenuItem.setText("Scale context menu item");
            this.scale.setMenu(scaleMenu);
        }
        if (this.hasCreateProperty(PROP_SELECTION_LISTENER)) {
            this.scale.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent event) {
                    String message = "Scale WidgetSelected! Current selection: " + ScaleTab.this.scale.getSelection();
                    ScaleTab.this.log(message);
                    ScaleTab.this.selectionSpinner.setSelection(ScaleTab.this.scale.getSelection());
                    ScaleTab.this.scale.setToolTipText(String.valueOf(ScaleTab.this.scale.getSelection()));
                }

                public void widgetDefaultSelected(SelectionEvent event) {
                    String message = "Scale WidgetDefaultSelected! Current selection: " + ScaleTab.this.scale.getSelection();
                    ScaleTab.this.log(message);
                    ScaleTab.this.selectionSpinner.setSelection(ScaleTab.this.scale.getSelection());
                    ScaleTab.this.scale.setToolTipText(String.valueOf(ScaleTab.this.scale.getSelection()));
                }
            });
        }
        if (this.checkControl((Control)this.minimumSpinner)) {
            this.scale.setMinimum(this.minimumSpinner.getSelection());
        }
        if (this.checkControl((Control)this.maximumSpinner)) {
            this.scale.setMaximum(this.maximumSpinner.getSelection());
        }
        if (this.checkControl((Control)this.selectionSpinner)) {
            this.scale.setSelection(this.selectionSpinner.getSelection());
        }
        if (this.checkControl((Control)this.incrementSpinner)) {
            this.scale.setIncrement(this.incrementSpinner.getSelection());
        }
        if (this.checkControl((Control)this.pageIncrementSpinner)) {
            this.scale.setPageIncrement(this.pageIncrementSpinner.getSelection());
        }
        this.registerControl((Control)this.scale);
    }

    protected Button createStyleButton(Composite parent, String name, int style, int buttonStyle, boolean checked) {
        Button button = new Button(parent, buttonStyle);
        button.setText(name);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ScaleTab.this.createNew();
            }
        });
        button.setData("style", (Object)new Integer(style));
        button.setSelection(checked);
        return button;
    }

    private Spinner createSpinnerControl(Composite parent, String labelText, int minimum, int maximum, int selection) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(3, false));
        Label label = new Label(composite, 0);
        label.setText(labelText);
        Spinner spinner = new Spinner(composite, 2048);
        spinner.setSelection(selection);
        spinner.setMinimum(minimum);
        spinner.setMaximum(maximum);
        return spinner;
    }
}

