/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.remote.internal.console;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.remote.core.IRemoteCommandShellService;
import org.eclipse.remote.core.IRemoteConnection;
import org.eclipse.remote.core.exception.RemoteConnectionException;
import org.eclipse.remote.internal.console.ConsoleMessages;
import org.eclipse.remote.internal.console.TerminalConsole;
import org.eclipse.remote.internal.console.TerminalConsoleSettingsDialog;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleFactory;
import org.eclipse.ui.console.IConsoleManager;

public class TerminalConsoleFactory
implements IConsoleFactory {
    public void openConsole() {
        TerminalConsoleSettingsDialog settingsDialog = new TerminalConsoleSettingsDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
        if (settingsDialog.open() == 0) {
            TerminalConsoleFactory.openConsole(settingsDialog.getRemoteConnection(), settingsDialog.getEncoding());
        }
    }

    public static void openConsole(final IRemoteConnection connection, final String encoding) {
        Job j = new Job(ConsoleMessages.OPENING_TERMINAL){

            public IStatus run(IProgressMonitor monitor) {
                return TerminalConsoleFactory.openConsoleImplementation(connection, encoding, monitor);
            }
        };
        j.schedule();
    }

    private static IStatus openConsoleImplementation(IRemoteConnection connection, String encoding, IProgressMonitor monitor) {
        IRemoteCommandShellService commandShellService = (IRemoteCommandShellService)connection.getService(IRemoteCommandShellService.class);
        if (commandShellService == null) {
            return Status.CANCEL_STATUS;
        }
        try {
            TerminalConsoleFactory.createConsole(connection, encoding, commandShellService, monitor);
            return Status.OK_STATUS;
        }
        catch (RemoteConnectionException rce) {
            return rce.getStatus();
        }
    }

    private static IConsole createConsole(IRemoteConnection connection, String encoding, IRemoteCommandShellService service, IProgressMonitor monitor) throws RemoteConnectionException {
        if (!connection.isOpen()) {
            connection.open(monitor);
        }
        IConsoleManager consoleManager = ConsolePlugin.getDefault().getConsoleManager();
        int index = TerminalConsoleFactory.findNextIndex(consoleManager, connection);
        TerminalConsole terminalConsole = new TerminalConsole(connection, index, encoding);
        consoleManager.addConsoles(new IConsole[]{terminalConsole});
        consoleManager.showConsoleView((IConsole)terminalConsole);
        return terminalConsole;
    }

    private static int findNextIndex(IConsoleManager consoleManager, IRemoteConnection connection) {
        IConsole[] consoles = consoleManager.getConsoles();
        boolean[] indices = new boolean[consoles.length];
        IConsole[] iConsoleArray = consoles;
        int n = consoles.length;
        int n2 = 0;
        while (n2 < n) {
            TerminalConsole terminalConsole;
            IConsole console = iConsoleArray[n2];
            if (console instanceof TerminalConsole && (terminalConsole = (TerminalConsole)console).getConnection().equals(connection)) {
                indices[terminalConsole.getIndex()] = true;
            }
            ++n2;
        }
        int index = 0;
        while (index < indices.length && indices[index]) {
            ++index;
        }
        return index;
    }

    public static List<IConsole> findConsole(IRemoteConnection connection) {
        IConsole[] consoles;
        ArrayList<IConsole> ret = new ArrayList<IConsole>();
        IConsoleManager consoleManager = ConsolePlugin.getDefault().getConsoleManager();
        IConsole[] iConsoleArray = consoles = consoleManager.getConsoles();
        int n = consoles.length;
        int n2 = 0;
        while (n2 < n) {
            TerminalConsole terminalConsole;
            IConsole console = iConsoleArray[n2];
            if (console instanceof TerminalConsole && (terminalConsole = (TerminalConsole)console).getConnection().equals(connection)) {
                ret.add((IConsole)terminalConsole);
            }
            ++n2;
        }
        return ret;
    }
}

