/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.tools.internal.views.common;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.sirius.business.api.modelingproject.ModelingProject;
import org.eclipse.sirius.business.api.query.FileQuery;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.ui.tools.internal.views.common.FileSessionFinder;
import org.eclipse.sirius.ui.tools.internal.views.modelexplorer.ModelExplorerView;
import org.eclipse.ui.PlatformUI;

public class FileHandledBySessionTester
extends PropertyTester {
    private static final String SESSION_FILE_PROPERTY = "isSessionFile";
    private static final String SESSION_IN_MODELING_PROJECT = "isFileInModelingProject";

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        boolean result = false;
        if (SESSION_FILE_PROPERTY.equals(property)) {
            result = this.isSessionFile(receiver);
        } else if (receiver instanceof IFile) {
            IFile receiverFile = (IFile)receiver;
            boolean hasModelingProjectNature = ModelingProject.hasModelingProjectNature((IProject)receiverFile.getProject());
            result = SESSION_IN_MODELING_PROJECT.equals(property) ? hasModelingProjectNature : (hasModelingProjectNature ? true : new FileQuery(receiverFile.getFileExtension()).isSessionResourceFile() || !FileSessionFinder.getSelectedSessions(Collections.singletonList(receiverFile)).isEmpty());
        }
        return result;
    }

    private boolean isSessionFile(Object element) {
        boolean isSessionResourceFile = false;
        if (!ModelExplorerView.class.getTypeName().equals(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart().getClass().getTypeName()) && element instanceof IFile) {
            List<Session> relatedSessions = FileSessionFinder.getRelatedSessions(new ArrayList<IFile>(Arrays.asList((IFile)element)), false, false);
            isSessionResourceFile = !relatedSessions.isEmpty() ? true : new FileQuery((IFile)element).isSessionResourceFile();
        }
        return isSessionResourceFile;
    }
}

