/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.core;

import java.io.IOException;
import org.eclipse.tcf.core.AbstractChannel;
import org.eclipse.tcf.protocol.IPeer;

public abstract class StreamChannel
extends AbstractChannel {
    public static final int ESC = 3;
    private int bin_data_size;
    private final byte[] esc_buf = new byte[4096];
    private final byte[] inp_buf = new byte[16384];
    private int inp_buf_pos;
    private int inp_buf_len;

    public StreamChannel(IPeer remote_peer) {
        super(remote_peer);
    }

    public StreamChannel(IPeer local_peer, IPeer remote_peer) {
        super(local_peer, remote_peer);
    }

    protected abstract int get() throws IOException;

    protected abstract void put(int var1) throws IOException;

    protected int get(byte[] buf) throws IOException {
        int i = 0;
        while (i < buf.length) {
            int b = this.get();
            if (b < 0) {
                if (i != 0) break;
                return -1;
            }
            buf[i++] = (byte)b;
            if (i >= this.bin_data_size) break;
        }
        return i;
    }

    protected void put(byte[] buf) throws IOException {
        byte[] byArray = buf;
        int n = buf.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            this.put(b & 0xFF);
            ++n2;
        }
    }

    protected void put(byte[] buf, int pos, int len) throws IOException {
        int end = pos + len;
        while (pos < end) {
            this.put(buf[pos++] & 0xFF);
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected final int read() throws IOException {
        block6: while (true) {
            if (this.inp_buf_pos >= this.inp_buf_len) {
                this.inp_buf_len = this.get(this.inp_buf);
                this.inp_buf_pos = 0;
                if (this.inp_buf_len >= 0) continue;
                return -1;
            }
            res = this.inp_buf[this.inp_buf_pos++] & 255;
            if (this.bin_data_size > 0) {
                --this.bin_data_size;
                return res;
            }
            if (res == 3) ** GOTO lbl17
            return res;
lbl-1000:
            // 1 sources

            {
                this.inp_buf_len = this.get(this.inp_buf);
                this.inp_buf_pos = 0;
                if (this.inp_buf_len >= 0) continue;
                return -1;
lbl17:
                // 2 sources

                ** while (this.inp_buf_pos >= this.inp_buf_len)
            }
lbl18:
            // 1 sources

            n = this.inp_buf[this.inp_buf_pos++] & 255;
            switch (n) {
                case 0: {
                    return 3;
                }
                case 1: {
                    return -2;
                }
                case 2: {
                    return -1;
                }
                case 3: {
                    i = 0;
                    while (true) {
                        if (this.inp_buf_pos >= this.inp_buf_len) {
                            this.inp_buf_len = this.get(this.inp_buf);
                            this.inp_buf_pos = 0;
                            if (this.inp_buf_len >= 0) continue;
                            return -1;
                        }
                        m = this.inp_buf[this.inp_buf_pos++] & 255;
                        this.bin_data_size |= (m & 127) << i;
                        if ((m & 128) != 0) ** break;
                        continue block6;
                        i += 7;
                    }
                }
                default: {
                    throw new IOException("Invalid escape sequence: 3 " + n);
                }
            }
            break;
        }
    }

    @Override
    protected final void write(int n) throws IOException {
        switch (n) {
            case 3: {
                this.esc_buf[0] = 3;
                this.esc_buf[1] = 0;
                this.put(this.esc_buf, 0, 2);
                break;
            }
            case -2: {
                this.esc_buf[0] = 3;
                this.esc_buf[1] = 1;
                this.put(this.esc_buf, 0, 2);
                break;
            }
            case -1: {
                this.esc_buf[0] = 3;
                this.esc_buf[1] = 2;
                this.put(this.esc_buf, 0, 2);
                break;
            }
            default: {
                assert (n >= 0 && n <= 255);
                this.put(n);
            }
        }
    }

    @Override
    protected final void write(byte[] buf) throws IOException {
        this.write(buf, 0, buf.length);
    }

    @Override
    protected final void write(byte[] buf, int pos, int len) throws IOException {
        if (len > 32 && this.isZeroCopySupported()) {
            int n = len;
            int esc_buf_pos = 0;
            this.esc_buf[esc_buf_pos++] = 3;
            this.esc_buf[esc_buf_pos++] = 3;
            while (true) {
                if (n <= 127) break;
                this.esc_buf[esc_buf_pos++] = (byte)(n & 0x7F | 0x80);
                n >>= 7;
            }
            this.esc_buf[esc_buf_pos++] = (byte)n;
            this.put(this.esc_buf, 0, esc_buf_pos);
            this.put(buf, pos, len);
        } else {
            int esc_buf_pos = 0;
            int end = pos + len;
            int i = pos;
            while (i < end) {
                if (esc_buf_pos + 2 > this.esc_buf.length) {
                    this.put(this.esc_buf, 0, esc_buf_pos);
                    esc_buf_pos = 0;
                }
                byte b = buf[i];
                this.esc_buf[esc_buf_pos++] = b;
                if (b == 3) {
                    this.esc_buf[esc_buf_pos++] = 0;
                }
                ++i;
            }
            this.put(this.esc_buf, 0, esc_buf_pos);
        }
    }
}

