/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.runtime.stepper.extensions;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionConverter;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.tcf.te.runtime.extensions.ExecutableExtension;
import org.eclipse.tcf.te.runtime.extensions.ExecutableExtensionProxy;
import org.eclipse.tcf.te.runtime.stepper.StepperManager;
import org.eclipse.tcf.te.runtime.stepper.activator.CoreBundleActivator;
import org.eclipse.tcf.te.runtime.stepper.extensions.StepGroupable;
import org.eclipse.tcf.te.runtime.stepper.interfaces.IStep;
import org.eclipse.tcf.te.runtime.stepper.interfaces.IStepContext;
import org.eclipse.tcf.te.runtime.stepper.interfaces.IStepGroup;
import org.eclipse.tcf.te.runtime.stepper.interfaces.IStepGroupIterator;
import org.eclipse.tcf.te.runtime.stepper.interfaces.IStepGroupable;
import org.eclipse.tcf.te.runtime.stepper.nls.Messages;
import org.osgi.framework.Bundle;

public class StepGroup
extends ExecutableExtension
implements IStepGroup {
    private boolean locked = false;
    private String baseOn = null;
    private final List<ReferenceSubElement> references = new ArrayList<ReferenceSubElement>();
    private Map<String, String> parameters = new HashMap<String, String>();
    private ExecutableExtensionProxy<IStepGroupIterator> iteratorProxy = null;
    protected static final IStepGroupable[] NO_STEPS = new IStepGroupable[0];

    @Override
    public boolean isLocked() {
        return this.locked;
    }

    protected String getBaseOn() {
        return this.baseOn;
    }

    protected List<ReferenceSubElement> getReferences() {
        return this.references;
    }

    protected void checkForDuplicates(List<IStepGroupable> steps, ReferenceSubElement reference) throws CoreException {
        Assert.isNotNull(steps);
        Assert.isNotNull((Object)reference);
        String overwrite = reference.getOverwrite();
        if (overwrite != null && overwrite.length() > 0) {
            return;
        }
        boolean checkFailed = false;
        for (IStepGroupable step : steps) {
            if (!step.getExtension().getId().equals(reference.getId())) continue;
            boolean bl = checkFailed = step.isSingleton() || reference.isSingleton() || step.getExtension() instanceof IStep && ((IStep)step.getExtension()).isSingleton();
            if (checkFailed) break;
        }
        if (checkFailed) {
            throw new CoreException((IStatus)new Status(4, CoreBundleActivator.getUniqueIdentifier(), MessageFormat.format(Messages.StepGroup_error_multipleSingletonOccurrences, NLS.bind((String)Messages.StepGroup_error_stepGroup, (Object)this.getLabel()), NLS.bind((String)Messages.StepGroup_error_referencedStepOrGroup, (Object)reference.getId()))));
        }
    }

    protected List<IStepGroupable> onOverwrite(List<IStepGroupable> steps, String oldId, org.eclipse.tcf.te.runtime.interfaces.extensions.IExecutableExtension replacement, ReferenceSubElement reference) {
        Assert.isNotNull(steps);
        Assert.isNotNull((Object)oldId);
        Assert.isNotNull((Object)replacement);
        Assert.isNotNull((Object)reference);
        ArrayList<IStepGroupable> affected = new ArrayList<IStepGroupable>();
        String primaryId = oldId;
        String secondaryId = null;
        String[] splitted = oldId.split("##", 2);
        if (splitted.length == 2) {
            primaryId = splitted[0];
            secondaryId = splitted[1];
        }
        for (IStepGroupable step : steps) {
            ArrayList<String> dependencies;
            if (step.getExtension().getId().equals(primaryId) && (secondaryId == null || secondaryId.equals(step.getSecondaryId())) && step instanceof StepGroupable) {
                StepGroupable groupable = (StepGroupable)step;
                groupable.setExtension(replacement);
                groupable.setSecondaryId(reference.getSecondaryId());
                affected.add(step);
            }
            if (!(dependencies = new ArrayList<String>(Arrays.asList(step.getDependencies()))).contains(oldId)) continue;
            String fullId = String.valueOf(replacement.getId()) + (reference.getSecondaryId() != null ? "##" + reference.getSecondaryId() : "");
            dependencies.set(dependencies.indexOf(oldId), fullId);
            if (!(step instanceof StepGroupable)) continue;
            ((StepGroupable)step).setDependencies(dependencies.toArray(new String[dependencies.size()]));
        }
        return affected;
    }

    protected List<IStepGroupable> onInsertBefore(List<IStepGroupable> steps, String id, org.eclipse.tcf.te.runtime.interfaces.extensions.IExecutableExtension newStep, ReferenceSubElement reference) {
        Assert.isNotNull(steps);
        Assert.isNotNull((Object)id);
        Assert.isNotNull((Object)newStep);
        Assert.isNotNull((Object)reference);
        ArrayList<IStepGroupable> affected = new ArrayList<IStepGroupable>();
        String primaryId = id;
        String secondaryId = null;
        String[] splitted = id.split("##", 2);
        if (splitted.length == 2) {
            primaryId = splitted[0];
            secondaryId = splitted[1];
        }
        int i = 0;
        while (i < steps.size()) {
            IStepGroupable step = steps.get(i);
            if (step.getExtension().getId().equals(primaryId) && (secondaryId == null || secondaryId.equals(step.getSecondaryId()))) {
                StepGroupable groupable = new StepGroupable(newStep, reference.getSecondaryId());
                steps.add(i, groupable);
                ++i;
                affected.add(groupable);
            }
            ++i;
        }
        if (affected.isEmpty()) {
            StepGroupable groupable = new StepGroupable(newStep, reference.getSecondaryId());
            steps.add(groupable);
        }
        return affected;
    }

    protected List<IStepGroupable> onInsertAfter(List<IStepGroupable> steps, String id, org.eclipse.tcf.te.runtime.interfaces.extensions.IExecutableExtension newStep, ReferenceSubElement reference) {
        Assert.isNotNull(steps);
        Assert.isNotNull((Object)id);
        Assert.isNotNull((Object)newStep);
        Assert.isNotNull((Object)reference);
        ArrayList<IStepGroupable> affected = new ArrayList<IStepGroupable>();
        String primaryId = id;
        String secondaryId = null;
        String[] splitted = id.split("##", 2);
        if (splitted.length == 2) {
            primaryId = splitted[0];
            secondaryId = splitted[1];
        }
        int i = 0;
        while (i < steps.size()) {
            IStepGroupable step = steps.get(i);
            if (step.getExtension().getId().equals(primaryId) && (secondaryId == null || secondaryId.equals(step.getSecondaryId()))) {
                StepGroupable groupable = new StepGroupable(newStep, reference.getSecondaryId());
                steps.add(i + 1, groupable);
                affected.add(groupable);
            }
            ++i;
        }
        if (affected.isEmpty()) {
            StepGroupable groupable = new StepGroupable(newStep, reference.getSecondaryId());
            steps.add(groupable);
        }
        return affected;
    }

    @Override
    public IStepGroupable[] getSteps(IStepContext context) throws CoreException {
        Assert.isNotNull((Object)context);
        ArrayList<IStepGroupable> steps = new ArrayList<IStepGroupable>();
        if (this.getBaseOn() != null) {
            IStepGroup baseStepGroup = StepperManager.getInstance().getStepGroupExtManager().getStepGroup(this.getBaseOn(), true);
            if (baseStepGroup == null) {
                throw new CoreException((IStatus)new Status(4, CoreBundleActivator.getUniqueIdentifier(), MessageFormat.format(Messages.StepGroup_error_missingBaseStepGroup, NLS.bind((String)Messages.StepGroup_error_stepGroup, (Object)this.getLabel()), NLS.bind((String)Messages.StepGroup_error_referencedBaseGroup, (Object)this.getBaseOn()))));
            }
            steps.addAll(Arrays.asList(baseStepGroup.getSteps(context)));
        }
        for (ReferenceSubElement reference : this.getReferences()) {
            StepGroupable groupable;
            org.eclipse.tcf.te.runtime.interfaces.extensions.IExecutableExtension candidate = this.getCandidate(reference.getId(), reference);
            if (candidate == null) {
                if (reference.isOptional()) {
                    CoreBundleActivator.getTraceHandler().trace("StepGroup#getSteps: SKIPPED optional not existing reference = '" + reference.getId(), 0, "trace/stepping", 2, (Object)this);
                    continue;
                }
                throw new CoreException((IStatus)new Status(4, CoreBundleActivator.getUniqueIdentifier(), MessageFormat.format(Messages.StepGroup_error_missingReferencedStep, NLS.bind((String)Messages.StepGroup_error_stepGroup, (Object)this.getLabel()), NLS.bind((String)Messages.StepGroup_error_referencedStepOrGroup, (Object)reference.getId()))));
            }
            boolean valid = this.isValidReference(reference, context);
            if (!valid) {
                CoreBundleActivator.getTraceHandler().trace("StepGroup#getSteps: SKIPPED reference = '" + candidate.getLabel() + "'." + " Not valid for contexts '" + context, 0, "trace/stepping", 2, (Object)this);
                continue;
            }
            this.checkForDuplicates(steps, reference);
            if (candidate instanceof IStep) {
                this.checkForDependenciesValid((IStep)candidate, context);
            }
            ArrayList<IStepGroupable> affectedGroupables = new ArrayList<IStepGroupable>();
            String overwrite = reference.getOverwrite();
            if (overwrite != null && overwrite.length() > 0) {
                affectedGroupables.addAll(this.onOverwrite(steps, overwrite, candidate, reference));
            } else {
                String insertBefore = reference.getInsertBefore();
                String insertAfter = reference.getInsertAfter();
                if (!(insertBefore != null && insertBefore.length() != 0 || insertAfter != null && insertAfter.length() != 0)) {
                    groupable = new StepGroupable(candidate, reference.getSecondaryId());
                    steps.add(groupable);
                    affectedGroupables.add(groupable);
                } else if (insertBefore != null && insertBefore.length() > 0) {
                    affectedGroupables.addAll(this.onInsertBefore(steps, insertBefore, candidate, reference));
                } else {
                    affectedGroupables.addAll(this.onInsertAfter(steps, insertAfter, candidate, reference));
                }
            }
            for (IStepGroupable step : affectedGroupables) {
                if (!(step instanceof StepGroupable)) continue;
                groupable = (StepGroupable)step;
                groupable.setDependencies(reference.getDependencies());
                if (!reference.isRemovable() && groupable.isRemovable()) {
                    groupable.setRemovable(reference.isRemovable());
                }
                if (reference.isHidden() && !groupable.isHidden()) {
                    groupable.setHidden(reference.isHidden());
                }
                if (reference.isDisable() && !groupable.isDisabled()) {
                    groupable.setDisabled(reference.isDisable());
                }
                if (reference.isSingleton() && !groupable.isSingleton()) {
                    groupable.setSingleton(reference.isSingleton());
                }
                if (reference.isSavePoint() && !groupable.isSavePoint()) {
                    groupable.setIsSavePoint(reference.isSavePoint());
                }
                if (!reference.isOptional() || groupable.isOptional()) continue;
                groupable.setOptional(reference.isOptional());
            }
        }
        return !steps.isEmpty() ? steps.toArray(new IStepGroupable[steps.size()]) : NO_STEPS;
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        this.references.clear();
        super.setInitializationData(config, propertyName, data);
    }

    public void doSetInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        IConfigurationElement[] childElements;
        String baseOnAttribute;
        String lockedAttribute;
        super.doSetInitializationData(config, propertyName, data);
        if (this.iteratorProxy == null) {
            this.iteratorProxy = new ExecutableExtensionProxy<IStepGroupIterator>(config){

                protected String getExecutableExtensionAttributeName() {
                    return "iterator";
                }
            };
        }
        if (!this.locked && (lockedAttribute = config.getAttribute("locked")) != null) {
            this.locked = Boolean.parseBoolean(lockedAttribute);
        }
        if ((this.baseOn == null || this.baseOn.trim().length() == 0) && (baseOnAttribute = config.getAttribute("baseOn")) != null && baseOnAttribute.trim().length() > 0) {
            this.baseOn = baseOnAttribute.trim();
        }
        HashMap<String, Integer> occurrences = new HashMap<String, Integer>();
        IConfigurationElement[] iConfigurationElementArray = childElements = config.getChildren("references");
        int n = childElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] references;
            IConfigurationElement childElement = iConfigurationElementArray[n2];
            IConfigurationElement[] iConfigurationElementArray2 = references = childElement.getChildren("reference");
            int n3 = references.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement reference = iConfigurationElementArray2[n4];
                ReferenceSubElement candidate = new ReferenceSubElement();
                candidate.setInitializationData(reference, reference.getName(), null);
                if (occurrences.containsKey(candidate.getId())) {
                    int number = (Integer)occurrences.get(candidate.getId()) + 1;
                    occurrences.put(candidate.getId(), number);
                    if (candidate.getSecondaryId() == null) {
                        candidate.setSecondardId(Integer.toString(number));
                    }
                } else {
                    occurrences.put(candidate.getId(), 1);
                }
                this.references.add(candidate);
                ++n4;
            }
            ++n2;
        }
    }

    protected void checkForDependenciesValid(IStep step, IStepContext context) throws CoreException {
        String[] dependencies;
        Assert.isNotNull((Object)step);
        Assert.isNotNull((Object)context);
        String[] stringArray = dependencies = step.getDependencies();
        int n = dependencies.length;
        int n2 = 0;
        while (n2 < n) {
            String dependency = stringArray[n2];
            org.eclipse.tcf.te.runtime.interfaces.extensions.IExecutableExtension candidate = this.getCandidate(dependency, null);
            if (candidate == null) {
                throw new CoreException((IStatus)new Status(4, CoreBundleActivator.getUniqueIdentifier(), MessageFormat.format(Messages.StepGroup_error_missingRequiredStep, NLS.bind((String)Messages.StepGroup_error_step, (Object)step.getLabel()), NLS.bind((String)Messages.StepGroup_error_requiredStepOrGroup, (Object)dependency))));
            }
            ++n2;
        }
    }

    protected org.eclipse.tcf.te.runtime.interfaces.extensions.IExecutableExtension getCandidate(String id, ReferenceSubElement reference) {
        Assert.isNotNull((Object)id);
        Object candidate = StepperManager.getInstance().getStepExtManager().getStep(id, true);
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.putAll(this.getParameters());
        if (reference != null) {
            parameters.putAll(reference.getParameters());
        }
        if (candidate == null) {
            candidate = StepperManager.getInstance().getStepGroupExtManager().getStepGroup(id, true);
            ((IStepGroup)candidate).setParameters(parameters);
        } else if (reference != null && candidate instanceof IStep) {
            candidate.setParameters(parameters);
        }
        return candidate;
    }

    protected boolean isValidReference(ReferenceSubElement reference, IStepContext context) {
        Assert.isNotNull((Object)reference);
        Expression enablement = reference.getEnablement();
        if (enablement != null) {
            if (context != null) {
                EvaluationContext evalContext = new EvaluationContext(null, context.getContextObject());
                evalContext.addVariable("context", (Object)context);
                evalContext.addVariable("id", (Object)context.getId());
                evalContext.setAllowPluginActivation(true);
                try {
                    return enablement.evaluate((IEvaluationContext)evalContext).equals(EvaluationResult.TRUE);
                }
                catch (CoreException e) {
                    Status status = new Status(4, CoreBundleActivator.getUniqueIdentifier(), e.getLocalizedMessage(), (Throwable)e);
                    Platform.getLog((Bundle)CoreBundleActivator.getContext().getBundle()).log((IStatus)status);
                }
            }
            return false;
        }
        return true;
    }

    @Override
    public IStepGroupIterator getStepGroupIterator() {
        return this.iteratorProxy != null ? (IStepGroupIterator)this.iteratorProxy.newInstance() : null;
    }

    @Override
    public void setParameters(Map<String, String> parameters) {
        this.parameters = parameters != null ? parameters : Collections.EMPTY_MAP;
    }

    @Override
    public Map<String, String> getParameters() {
        return this.parameters;
    }

    protected static final class ReferenceSubElement
    implements IExecutableExtension {
        private String id;
        private String secondaryId;
        private String insertBefore;
        private String insertAfter;
        private String overwrite;
        private boolean removable;
        private boolean hidden;
        private boolean disable;
        private boolean singleton;
        private boolean savePoint;
        private boolean optional;
        private final List<String> dependencies = new ArrayList<String>();
        private Expression expression;
        private Map<String, String> parameters = new HashMap<String, String>();

        protected ReferenceSubElement() {
        }

        public String getId() {
            return this.id;
        }

        public String getSecondaryId() {
            return this.secondaryId;
        }

        public void setSecondardId(String secondaryId) {
            this.secondaryId = secondaryId;
        }

        public String getInsertBefore() {
            return this.insertBefore;
        }

        public String getInsertAfter() {
            return this.insertAfter;
        }

        public String getOverwrite() {
            return this.overwrite;
        }

        public boolean isRemovable() {
            return this.removable;
        }

        public boolean isHidden() {
            return this.hidden;
        }

        public boolean isDisable() {
            return this.disable;
        }

        public boolean isSingleton() {
            return this.singleton;
        }

        public boolean isSavePoint() {
            return this.savePoint;
        }

        public boolean isOptional() {
            return this.optional;
        }

        public String[] getDependencies() {
            return this.dependencies.toArray(new String[this.dependencies.size()]);
        }

        public Expression getEnablement() {
            return this.expression;
        }

        public Map<String, String> getParameters() {
            return this.parameters;
        }

        public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
            IConfigurationElement[] params;
            IConfigurationElement[] requires;
            if (config == null) {
                return;
            }
            String value = config.getAttribute("id");
            if (value != null && value.trim().length() > 0) {
                this.id = value.trim();
            }
            this.setSecondardId((value = config.getAttribute("secondaryId")) != null && value.trim().length() > 0 ? value.trim() : null);
            value = config.getAttribute("insertBefore");
            if (value != null && value.trim().length() > 0) {
                this.insertBefore = value.trim();
            }
            if ((value = config.getAttribute("insertAfter")) != null && value.trim().length() > 0) {
                this.insertAfter = value.trim();
            }
            if ((value = config.getAttribute("overwrite")) != null && value.trim().length() > 0) {
                this.overwrite = value.trim();
            }
            if ((value = config.getAttribute("removable")) != null && value.trim().length() > 0) {
                this.removable = Boolean.parseBoolean(value.trim());
            }
            if ((value = config.getAttribute("hidden")) != null && value.trim().length() > 0) {
                this.hidden = Boolean.parseBoolean(value.trim());
            }
            if ((value = config.getAttribute("disable")) != null && value.trim().length() > 0) {
                this.disable = Boolean.parseBoolean(value.trim());
            }
            if ((value = config.getAttribute("singleton")) != null && value.trim().length() > 0) {
                this.singleton = Boolean.parseBoolean(value.trim());
            }
            if ((value = config.getAttribute("savePoint")) != null && value.trim().length() > 0) {
                this.savePoint = Boolean.parseBoolean(value.trim());
            }
            if ((value = config.getAttribute("optional")) != null && value.trim().length() > 0) {
                this.optional = Boolean.parseBoolean(value.trim());
            }
            this.dependencies.clear();
            IConfigurationElement[] iConfigurationElementArray = requires = config.getChildren("requires");
            int n = requires.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement require = iConfigurationElementArray[n2];
                value = require.getAttribute("id");
                if (value == null || value.trim().length() == 0) {
                    throw new CoreException((IStatus)new Status(4, CoreBundleActivator.getUniqueIdentifier(), 0, NLS.bind((String)Messages.AbstractStep_error_missingRequiredAttribute, (Object)"dependency id (requires)", (Object)config.getName()), null));
                }
                if (!this.dependencies.contains(value.trim())) {
                    this.dependencies.add(value.trim());
                }
                ++n2;
            }
            IConfigurationElement[] enablements = config.getChildren("enablement");
            if (enablements != null && enablements.length > 0) {
                this.expression = ExpressionConverter.getDefault().perform(enablements[0]);
            }
            if ((params = config.getChildren("parameter")) != null && params.length > 0) {
                IConfigurationElement[] iConfigurationElementArray2 = params;
                int n3 = params.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement parameter = iConfigurationElementArray2[n4];
                    this.parameters.put(parameter.getAttribute("name"), parameter.getAttribute("value"));
                    ++n4;
                }
            }
        }

        public boolean equals(Object obj) {
            if (this.getId() != null && obj instanceof ReferenceSubElement) {
                boolean secondaryIdEquals = false;
                secondaryIdEquals = this.getSecondaryId() == null ? ((ReferenceSubElement)obj).getSecondaryId() == null : this.getSecondaryId().equals(((ReferenceSubElement)obj).getSecondaryId());
                return this.getId().equals(((ReferenceSubElement)obj).getId()) && secondaryIdEquals;
            }
            return super.equals(obj);
        }

        public int hashCode() {
            return this.getId() != null ? this.getId().hashCode() + (this.getSecondaryId() != null ? this.getSecondaryId().hashCode() : 0) : super.hashCode();
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer(this.getClass().getSimpleName());
            buffer.append(": ");
            buffer.append("id = " + this.getId());
            buffer.append(", secondaryId = " + this.getSecondaryId());
            buffer.append(", insertBefore = " + this.getInsertBefore());
            buffer.append(", insertAfter = " + this.getInsertAfter());
            buffer.append(", overwrite = " + this.getOverwrite());
            buffer.append(", removable = " + this.isRemovable());
            buffer.append(", hidden = " + this.isHidden());
            buffer.append(", disable = " + this.isDisable());
            buffer.append(", singleton = " + this.isSingleton());
            buffer.append(", savePoint = " + this.isSavePoint());
            buffer.append(", optional = " + this.isOptional());
            buffer.append(", parameters = " + this.getParameters());
            return buffer.toString();
        }
    }
}

