/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.filesystem.core.internal.operations;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.FSTreeNode;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.operations.AbstractOperation;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.url.TcfURLConnection;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.utils.FileState;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.utils.PersistenceManager;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.utils.StatusHelper;
import org.eclipse.tcf.te.tcf.filesystem.core.nls.Messages;

public class OpDownload
extends AbstractOperation {
    private final OutputStream fTarget;
    private final FSTreeNode fSource;
    private final boolean fResetDigest;

    public OpDownload(FSTreeNode srcNode, OutputStream target) {
        this.fTarget = target;
        this.fSource = srcNode;
        this.fResetDigest = target == null;
    }

    @Override
    public IStatus doRun(IProgressMonitor monitor) {
        MessageDigest digest;
        block14: {
            digest = null;
            try {
                digest = MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                // empty catch block
            }
            try {
                if (this.fTarget != null) {
                    this.downloadFile(this.fSource, this.fTarget, digest, monitor);
                    break block14;
                }
                BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(this.fSource.getCacheFile()));
                try {
                    this.downloadFile(this.fSource, out, digest, monitor);
                }
                finally {
                    try {
                        ((OutputStream)out).close();
                    }
                    catch (IOException iOException) {}
                }
            }
            catch (Exception e) {
                if (this.fTarget == null) {
                    this.fSource.getCacheFile().delete();
                }
                return StatusHelper.createStatus("Cannot download " + this.fSource.getName(), e);
            }
        }
        if (!monitor.isCanceled() && digest != null) {
            this.updateNodeDigest(this.fSource, digest.digest());
        }
        return monitor.isCanceled() ? Status.CANCEL_STATUS : Status.OK_STATUS;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void downloadFile(FSTreeNode source, OutputStream out, MessageDigest digest, IProgressMonitor monitor) throws IOException {
        byte[] data = new byte[5120];
        long size = source.getSize();
        long percentSize = size / 100L;
        int percentRead = 0;
        long bytesRead = 0L;
        monitor.beginTask(this.getName(), 100);
        BufferedInputStream input = null;
        TcfURLConnection connection = (TcfURLConnection)source.getLocationURL().openConnection();
        try {
            block12: {
                int length;
                String fileLength;
                block11: {
                    input = digest != null ? new BufferedInputStream(new DigestInputStream(connection.getInputStream(), digest)) : new BufferedInputStream(connection.getInputStream());
                    fileLength = this.formatSize(size);
                    if (!true) break block11;
                    length = input.read(data);
                    if (length < 0) return;
                    if (monitor.isCanceled()) break block12;
                }
                do {
                    int percent;
                    out.write(data, 0, length);
                    if (percentSize != 0L && (percent = (int)((bytesRead += (long)length) / percentSize)) != percentRead) {
                        monitor.worked(percent - percentRead);
                        percentRead = percent;
                        monitor.subTask(NLS.bind((String)Messages.OpDownload_Downloading, (Object[])new Object[]{source.getName(), this.formatSize(bytesRead), fileLength}));
                    }
                    length = input.read(data);
                    if (length < 0) return;
                } while (!monitor.isCanceled());
            }
            return;
        }
        finally {
            out.flush();
            if (input != null) {
                try {
                    input.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    protected void updateNodeDigest(FSTreeNode node, byte[] digest) {
        FileState fileDigest = PersistenceManager.getInstance().getFileDigest(node);
        if (this.fResetDigest) {
            fileDigest.reset(digest, this.fSource.getCacheFile().lastModified(), this.fSource.getModificationTime());
        } else {
            fileDigest.updateTargetDigest(digest, this.fSource.getModificationTime());
        }
    }

    @Override
    public String getName() {
        return NLS.bind((String)Messages.OpDownload_DownloadingSingleFile, (Object)this.fSource.getName());
    }
}

