/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.core.model.association;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.core.model.association.Association;
import org.eclipse.wb.core.model.association.AssociationUtils;
import org.eclipse.wb.core.model.association.InvocationAssociation;
import org.eclipse.wb.internal.core.model.JavaInfoUtils;
import org.eclipse.wb.internal.core.model.description.ComponentDescription;
import org.eclipse.wb.internal.core.model.description.MethodDescription;
import org.eclipse.wb.internal.core.model.description.ParameterDescription;
import org.eclipse.wb.internal.core.model.description.helpers.ComponentDescriptionHelper;
import org.eclipse.wb.internal.core.model.generation.statement.AbstractInsideStatementGenerator;
import org.eclipse.wb.internal.core.model.property.ComplexProperty;
import org.eclipse.wb.internal.core.model.property.GenericPropertyImpl;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.property.accessor.ExpressionAccessor;
import org.eclipse.wb.internal.core.model.property.accessor.InvocationChildAssociationAccessor;
import org.eclipse.wb.internal.core.model.property.category.PropertyCategory;
import org.eclipse.wb.internal.core.model.property.converter.ExpressionConverter;
import org.eclipse.wb.internal.core.model.property.editor.PropertyEditor;
import org.eclipse.wb.internal.core.model.variable.EmptyVariableSupport;
import org.eclipse.wb.internal.core.utils.GenericsUtils;
import org.eclipse.wb.internal.core.utils.ast.AstNodeUtils;
import org.eclipse.wb.internal.core.utils.ast.DomGenerics;
import org.eclipse.wb.internal.core.utils.ast.StatementTarget;
import org.eclipse.wb.internal.core.utils.check.Assert;

public final class InvocationChildAssociation
extends InvocationAssociation {
    private String m_source;
    private String m_properties_oldSignature;
    private ComplexProperty m_properties_oldProperty;

    public InvocationChildAssociation(String source) {
        Assert.isTrue((source == null || source.startsWith("%parent%.") ? 1 : 0) != 0, (String)"Source should start with %%parent%%., but '%s' found.", (Object[])new Object[]{source});
        this.m_source = source;
    }

    public InvocationChildAssociation(MethodInvocation invocation) {
        super(invocation);
    }

    public MethodDescription getDescription() {
        String signature = AstNodeUtils.getMethodSignature(this.m_invocation);
        return this.m_javaInfo.getParentJava().getDescription().getMethod(signature);
    }

    @Override
    public void add(JavaInfo javaInfo, StatementTarget target, String[] leadingComments) throws Exception {
        if (this.m_source != null) {
            String source = AssociationUtils.replaceTemplates(javaInfo, this.m_source, target);
            List lines = GenericsUtils.asList((Object[])leadingComments, (Object)(String.valueOf(source) + ";"));
            ExpressionStatement statement = (ExpressionStatement)javaInfo.getEditor().addStatement(lines, target);
            this.m_invocation = (MethodInvocation)statement.getExpression();
        } else {
            EmptyVariableSupport emptyVariableSupport = (EmptyVariableSupport)javaInfo.getVariableSupport();
            this.m_invocation = (MethodInvocation)emptyVariableSupport.getInitializer().getParent();
        }
        AbstractInsideStatementGenerator.addRelatedNodes(javaInfo, (ASTNode)this.m_invocation);
        this.setInModelNoCompound(javaInfo);
    }

    @Override
    public void move(StatementTarget target) throws Exception {
        Expression constraintsExpression;
        JavaInfo constraints;
        MethodDescription description = this.getDescription();
        List<ParameterDescription> parameters = description.getParameters();
        if (parameters.size() == 2 && parameters.get(0).isChild() && parameters.get(0).isParent2() && parameters.get(1).isChild2() && (constraints = this.m_javaInfo.getChildRepresentedBy((ASTNode)(constraintsExpression = DomGenerics.arguments(this.m_invocation).get(1)))) != null) {
            constraints.getVariableSupport().ensureInstanceReadyAt(target);
            return;
        }
        Statement statement = this.getStatement();
        this.m_editor.moveStatement(statement, target);
    }

    @Override
    public boolean remove() throws Exception {
        ObjectInfo parent = this.m_javaInfo.getParent();
        if (parent instanceof JavaInfo && !parent.isDeleting()) {
            JavaInfoUtils.materializeVariable((JavaInfo)parent);
        }
        this.m_editor.removeEnclosingStatement((ASTNode)this.m_invocation);
        return super.remove();
    }

    @Override
    public Association getCopy() {
        return new InvocationChildAssociation(this.m_invocation);
    }

    @Override
    public void addProperties(List<Property> properties) throws Exception {
        Property associationProperty = this.getAssociationProperty();
        if (associationProperty != null) {
            properties.add(associationProperty);
        }
    }

    private Property getAssociationProperty() throws Exception {
        String signature = AstNodeUtils.getMethodSignature(this.m_invocation);
        if (this.m_properties_oldSignature == null || !this.m_properties_oldSignature.equals(signature)) {
            List<Property> associationProperties = this.createAssociationSubProperties(signature);
            if (!associationProperties.isEmpty()) {
                this.m_properties_oldProperty = new ComplexProperty("Association", "(Association properties)");
                this.m_properties_oldProperty.setCategory(PropertyCategory.system((int)4));
                this.m_properties_oldProperty.setModified(true);
                this.m_properties_oldProperty.setProperties(associationProperties);
            } else {
                this.m_properties_oldProperty = null;
            }
        }
        this.m_properties_oldSignature = signature;
        return this.m_properties_oldProperty;
    }

    private List<Property> createAssociationSubProperties(String signature) throws Exception {
        ComponentDescription parentDescription = this.m_javaInfo.getParentJava().getDescription();
        MethodDescription description = parentDescription.getMethod(signature);
        ComponentDescriptionHelper.ensureInitialized(this.m_javaProject, description);
        ArrayList associationProperties = Lists.newArrayList();
        for (ParameterDescription parameter : description.getParameters()) {
            Property property;
            if (parameter.isChild() || (property = this.createAssociationSubProperty(parameter)) == null) continue;
            associationProperties.add(property);
        }
        return associationProperties;
    }

    private Property createAssociationSubProperty(ParameterDescription parameter) throws Exception {
        int index = parameter.getIndex();
        String name = parameter.getName();
        String defaultSource = parameter.getDefaultSource();
        InvocationChildAssociationAccessor accessor = new InvocationChildAssociationAccessor(index, defaultSource);
        ExpressionConverter converter = parameter.getConverter();
        PropertyEditor editor = parameter.getEditor();
        if (editor == null) {
            return null;
        }
        return new GenericPropertyImpl(this.m_javaInfo, name, new ExpressionAccessor[]{accessor}, defaultSource, converter, editor);
    }
}

