/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.gefTree.policy;

import java.util.List;
import org.eclipse.wb.core.gef.command.CompoundEditCommand;
import org.eclipse.wb.core.gef.command.EditCommand;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.gef.core.Command;
import org.eclipse.wb.gef.core.EditPart;
import org.eclipse.wb.gef.core.policies.ILayoutRequestValidator;
import org.eclipse.wb.gef.core.requests.Request;
import org.eclipse.wb.gef.tree.policies.LayoutEditPolicy;
import org.eclipse.wb.internal.core.gefTree.policy.ArrayObjectRequestValidator;
import org.eclipse.wb.internal.core.model.nonvisual.AbstractArrayObjectInfo;

public final class ArrayObjectLayoutEditPolicy
extends LayoutEditPolicy {
    private final AbstractArrayObjectInfo m_arrayInfo;
    private final ArrayObjectRequestValidator m_validator;

    public ArrayObjectLayoutEditPolicy(AbstractArrayObjectInfo object) {
        this.m_arrayInfo = object;
        this.m_validator = new ArrayObjectRequestValidator(this.m_arrayInfo);
    }

    protected boolean isGoodReferenceChild(Request request, EditPart editPart) {
        return this.m_validator.isValidModel(editPart.getModel());
    }

    protected ILayoutRequestValidator getRequestValidator() {
        return this.m_validator;
    }

    protected Command getCreateCommand(Object newObject, Object referenceObject) {
        final JavaInfo item = (JavaInfo)((Object)newObject);
        final JavaInfo nextItem = (JavaInfo)((Object)referenceObject);
        return new EditCommand(this.m_arrayInfo){

            protected void executeEdit() throws Exception {
                ArrayObjectLayoutEditPolicy.this.m_arrayInfo.command_CREATE(item, nextItem);
            }
        };
    }

    protected Command getMoveCommand(List<EditPart> moveParts, Object referenceObject) {
        CompoundEditCommand command = new CompoundEditCommand((ObjectInfo)this.m_arrayInfo);
        for (EditPart editPart : moveParts) {
            final JavaInfo item = (JavaInfo)((Object)editPart.getModel());
            final JavaInfo nextItem = (JavaInfo)((Object)referenceObject);
            command.add((Command)new EditCommand(this.m_arrayInfo){

                protected void executeEdit() throws Exception {
                    ArrayObjectLayoutEditPolicy.this.m_arrayInfo.command_MOVE(item, nextItem);
                }
            });
        }
        return command;
    }

    protected Command getAddCommand(List<EditPart> addParts, Object referenceObject) {
        return this.getMoveCommand(addParts, referenceObject);
    }
}

