/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.creation;

import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.wb.core.model.IWrapperInfo;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.WrapperByMethod;
import org.eclipse.wb.core.model.broadcast.JavaInfoSetObjectAfter;
import org.eclipse.wb.internal.core.model.JavaInfoUtils;
import org.eclipse.wb.internal.core.model.clipboard.IClipboardCreationSupport;
import org.eclipse.wb.internal.core.model.clipboard.JavaInfoMemento;
import org.eclipse.wb.internal.core.model.creation.CreationSupport;
import org.eclipse.wb.internal.core.model.creation.IImplicitCreationSupport;
import org.eclipse.wb.internal.core.model.creation.IWrapperControlCreationSupport;
import org.eclipse.wb.internal.core.model.creation.WrapperMethodCreationSupport;
import org.eclipse.wb.internal.core.model.util.TemplateUtils;
import org.eclipse.wb.internal.core.utils.ast.NodeTarget;

public class WrapperMethodControlCreationSupport
extends CreationSupport
implements IWrapperControlCreationSupport {
    private final WrapperByMethod m_wrapper;

    public WrapperMethodControlCreationSupport(WrapperByMethod wrapper) {
        this.m_wrapper = wrapper;
    }

    public String toString() {
        return "viewer: " + this.m_wrapper.getControlMethod();
    }

    @Override
    public final JavaInfo getWrapperInfo() {
        return this.m_wrapper.getWrapperInfo();
    }

    @Override
    public void setJavaInfo(JavaInfo javaInfo) throws Exception {
        super.setJavaInfo(javaInfo);
        this.m_javaInfo.addBroadcastListener(new JavaInfoSetObjectAfter(){

            @Override
            public void invoke(JavaInfo target, Object o) throws Exception {
                if (target == WrapperMethodControlCreationSupport.this.m_wrapper.getWrapperInfo()) {
                    Object object = WrapperMethodControlCreationSupport.this.m_wrapper.getControlMethod().invoke(o, new Object[0]);
                    WrapperMethodControlCreationSupport.this.m_javaInfo.setObject(object);
                }
            }
        });
    }

    @Override
    public ASTNode getNode() {
        return this.m_wrapper.getWrapperInfo().getCreationSupport().getNode();
    }

    @Override
    public boolean isJavaInfo(ASTNode node) {
        return this.m_wrapper.isWrappedInfo(node);
    }

    @Override
    public boolean canReorder() {
        return true;
    }

    @Override
    public boolean canReparent() {
        return true;
    }

    @Override
    public String add_getSource(NodeTarget target) throws Exception {
        return TemplateUtils.format("{0}.{1}()", new Object[]{this.m_wrapper.getWrapperInfo(), this.m_wrapper.getControlMethod().getName()});
    }

    @Override
    public void add_setSourceExpression(Expression expression) throws Exception {
    }

    @Override
    public boolean canDelete() {
        return true;
    }

    @Override
    public void delete() throws Exception {
        CreationSupport wrapperCreation = this.m_wrapper.getWrapperInfo().getCreationSupport();
        boolean isImplicitWrapper = wrapperCreation instanceof IImplicitCreationSupport;
        JavaInfoUtils.deleteJavaInfo(this.m_javaInfo, !isImplicitWrapper);
    }

    @Override
    public IClipboardCreationSupport getClipboard() throws Exception {
        final JavaInfoMemento viewerMemento = JavaInfoMemento.createMemento(this.m_wrapper.getWrapperInfo());
        return new IClipboardCreationSupport(){
            private static final long serialVersionUID = 0L;

            @Override
            public CreationSupport create(JavaInfo rootObject) throws Exception {
                IWrapperInfo wrapperInfo = (IWrapperInfo)((Object)viewerMemento.create(rootObject));
                return new WrapperMethodCreationSupport((WrapperByMethod)wrapperInfo.getWrapper());
            }

            @Override
            public void apply(JavaInfo javaInfo) throws Exception {
                viewerMemento.apply();
            }
        };
    }
}

