/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.nls.ui;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.nls.Messages;
import org.eclipse.wb.internal.core.nls.NlsSupport;
import org.eclipse.wb.internal.core.nls.edit.IEditableSource;
import org.eclipse.wb.internal.core.nls.edit.IEditableSupport;
import org.eclipse.wb.internal.core.nls.edit.IEditableSupportListener;
import org.eclipse.wb.internal.core.nls.ui.PropertiesComposite;
import org.eclipse.wb.internal.core.nls.ui.SourceComposite;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableEx;
import org.eclipse.wb.internal.core.utils.ui.dialogs.ResizableDialog;

public final class NlsDialog
extends ResizableDialog {
    private final JavaInfo m_root;
    private final NlsSupport m_support;
    private final IEditableSupport m_editableSupport;
    private TabFolder m_tabFolder;
    private List<SourceComposite> m_composites;

    public NlsDialog(Shell parentShell, JavaInfo root) throws Exception {
        super(parentShell, (AbstractUIPlugin)DesignerPlugin.getDefault());
        this.m_root = root;
        this.m_support = NlsSupport.get(root);
        this.m_editableSupport = this.m_support.getEditable();
        this.m_editableSupport.addListener(new IEditableSupportListener(){

            @Override
            public void sourceAdded(final IEditableSource source) {
                ExecutionUtils.runLog((RunnableEx)new RunnableEx(){

                    public void run() throws Exception {
                        int tabIndex = (this).NlsDialog.this.m_tabFolder.getItemCount() - 1;
                        NlsDialog.this.createStringsTab(source, tabIndex);
                    }
                });
            }
        });
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        area.setLayout((Layout)new GridLayout());
        this.m_tabFolder = new TabFolder(area, 0);
        this.m_tabFolder.setLayoutData((Object)new GridData(1808));
        ExecutionUtils.runLog((RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                NlsDialog.this.createStringsTabs();
                NlsDialog.this.createPropertiesTab();
                if (!NlsDialog.this.m_editableSupport.hasExistingSources()) {
                    NlsDialog.this.m_tabFolder.setSelection(NlsDialog.this.m_tabFolder.getItemCount() - 1);
                }
            }
        });
        return area;
    }

    private void createStringsTabs() throws Exception {
        this.m_composites = Lists.newArrayList();
        List<IEditableSource> sources = this.getSortedSourcesList();
        for (IEditableSource editableSource : sources) {
            int tabIndex = this.m_tabFolder.getItemCount();
            SourceComposite composite = this.createStringsTab(editableSource, tabIndex);
            this.m_composites.add(composite);
        }
    }

    private List<IEditableSource> getSortedSourcesList() {
        List<IEditableSource> sources = this.m_editableSupport.getEditableSources();
        ArrayList<IEditableSource> sourcesList = new ArrayList<IEditableSource>(sources);
        Collections.sort(sourcesList, new Comparator<IEditableSource>(){

            @Override
            public int compare(IEditableSource source_1, IEditableSource source_2) {
                return source_1.getShortTitle().compareTo(source_2.getShortTitle());
            }
        });
        return sourcesList;
    }

    private SourceComposite createStringsTab(IEditableSource editableSource, int tabIndex) throws Exception {
        TabItem item = new TabItem(this.m_tabFolder, 0, tabIndex);
        item.setText(editableSource.getShortTitle());
        SourceComposite composite = new SourceComposite((Composite)this.m_tabFolder, 0, editableSource);
        item.setControl((Control)composite);
        return composite;
    }

    private void createPropertiesTab() {
        TabItem item = new TabItem(this.m_tabFolder, 0);
        item.setText(Messages.NlsDialog_propertiesPage);
        PropertiesComposite composite = new PropertiesComposite((Composite)this.m_tabFolder, 0, this.m_editableSupport);
        item.setControl((Control)composite);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.NlsDialog_title);
    }

    protected Point getDefaultSize() {
        Display display = Display.getCurrent();
        Rectangle displayArea = display.getClientArea();
        return new Point(displayArea.width / 2, displayArea.height / 2);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, false);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected void okPressed() {
        this.getButton(0).setEnabled(false);
        try {
            ExecutionUtils.run((ObjectInfo)this.m_root, (RunnableEx)new RunnableEx(){

                public void run() throws Exception {
                    NlsDialog.this.m_support.applyEditable(NlsDialog.this.m_editableSupport);
                }
            });
        }
        finally {
            this.getButton(0).setEnabled(true);
        }
        super.okPressed();
    }
}

