/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.utils.ui.dialogs.image;

import java.text.MessageFormat;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.wb.internal.core.utils.Messages;
import org.eclipse.wb.internal.core.utils.ui.GridDataFactory;
import org.eclipse.wb.internal.core.utils.ui.GridLayoutFactory;
import org.eclipse.wb.internal.core.utils.ui.UiUtils;
import org.eclipse.wb.internal.core.utils.ui.dialogs.image.ImageInfo;

public class ImagePreviewComposite
extends Composite {
    private final Label m_dimensionLabel;
    private final Label m_sizeLabel;
    private final Canvas m_imageCanvas;
    private ImageInfo m_imageInfo;

    public ImagePreviewComposite(Composite parent, int style) {
        super(parent, style);
        GridLayoutFactory.create((Composite)this);
        this.m_dimensionLabel = new Label((Composite)this, 0);
        GridDataFactory.create((Control)this.m_dimensionLabel).grabH().fillH();
        this.m_sizeLabel = new Label((Composite)this, 0);
        GridDataFactory.create((Control)this.m_sizeLabel).grabH().fillH();
        this.m_imageCanvas = new Canvas((Composite)this, 0);
        GridDataFactory.create((Control)this.m_imageCanvas).grab().fill();
        this.m_imageCanvas.addListener(9, new Listener(){

            public void handleEvent(Event event) {
                Rectangle clientArea = ImagePreviewComposite.this.m_imageCanvas.getClientArea();
                GC gc = event.gc;
                if (ImagePreviewComposite.this.m_imageInfo != null && ImagePreviewComposite.this.m_imageInfo.getImage() != null) {
                    Image image = ImagePreviewComposite.this.m_imageInfo.getImage();
                    UiUtils.drawScaledImage((GC)gc, (Image)image, (Rectangle)clientArea);
                } else {
                    String text = Messages.ImagePreviewComposite_noPreview;
                    Point extent = gc.textExtent(text);
                    int x = clientArea.x + (clientArea.width - extent.x) / 2;
                    int y = clientArea.y + (clientArea.height - extent.y) / 2;
                    gc.setForeground(ImagePreviewComposite.this.m_imageCanvas.getDisplay().getSystemColor(16));
                    gc.drawText(text, x, y);
                }
            }
        });
    }

    public void setImageInfo(ImageInfo imageInfo) {
        this.m_imageInfo = imageInfo;
        if (this.m_imageInfo != null && this.m_imageInfo.getImage() != null) {
            Rectangle bounds = this.m_imageInfo.getImage().getBounds();
            this.m_dimensionLabel.setText(MessageFormat.format(Messages.ImagePreviewComposite_dimension, bounds.width, bounds.height));
            long size = this.m_imageInfo.getSize();
            if (size != -1L) {
                this.m_sizeLabel.setText(MessageFormat.format(Messages.ImagePreviewComposite_size, size));
            } else {
                this.m_sizeLabel.setText(Messages.ImagePreviewComposite_sizeNA);
            }
        } else {
            this.m_dimensionLabel.setText("");
            this.m_sizeLabel.setText("");
        }
        this.m_imageCanvas.redraw();
    }
}

