/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.utils.ui;

import com.google.common.collect.Lists;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wb.internal.core.utils.Debug;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableEx;

public final class ImageDisposer {
    private static boolean DEBUG = false;
    private static ReferenceQueue<Object> m_queue = new ReferenceQueue();
    private static final List<ImageHolder> m_references = Lists.newArrayList();
    private static Timer m_timer;

    static {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                m_timer = new Timer(true);
                return null;
            }
        }, new AccessControlContext(new ProtectionDomain[0]));
        m_timer.schedule(new TimerTask(){

            @Override
            public void run() {
                ImageDisposer.disposeImages();
            }
        }, 1000L, 1000L);
    }

    private ImageDisposer() {
    }

    public static synchronized void add(Object key, String name, Image image) {
        if (image != null) {
            m_references.add(new ImageHolder(key, m_queue, name, image));
        }
    }

    private static synchronized void disposeImages() {
        ImageHolder reference;
        int removed = 0;
        while ((reference = (ImageHolder)m_queue.poll()) != null) {
            m_references.remove(reference);
            ++removed;
            final Image image = reference.m_image;
            ExecutionUtils.runAsync(new RunnableEx(){

                @Override
                public void run() throws Exception {
                    if (image != null && !image.isDisposed()) {
                        image.dispose();
                    }
                }
            });
        }
        if (DEBUG && removed != 0) {
            ImageDisposer.printReferences();
        }
    }

    private static void printReferences() {
        Debug.println("references: " + m_references.size());
        try {
            for (ImageHolder reference : m_references) {
                Debug.print("\t");
                Debug.print(reference.m_name);
                Debug.println();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static class ImageHolder
    extends WeakReference<Object> {
        private final String m_name;
        private final Image m_image;

        public ImageHolder(Object key, ReferenceQueue<Object> queue, String name, Image image) {
            super(key, queue);
            this.m_name = name;
            this.m_image = image;
        }
    }
}

