/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwtjsonrpc.rebind;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.core.ext.GeneratorContext;
import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.core.ext.typeinfo.JArrayType;
import com.google.gwt.core.ext.typeinfo.JClassType;
import com.google.gwt.core.ext.typeinfo.JType;
import com.google.gwt.user.rebind.ClassSourceFileComposerFactory;
import com.google.gwt.user.rebind.SourceWriter;
import com.google.gwtjsonrpc.client.impl.ArrayResultDeserializer;
import com.google.gwtjsonrpc.client.impl.ResultDeserializer;
import com.google.gwtjsonrpc.client.impl.ser.PrimitiveArrayResultDeserializers;
import com.google.gwtjsonrpc.client.impl.ser.PrimitiveResultDeserializers;
import com.google.gwtjsonrpc.rebind.ProxyCreator;
import com.google.gwtjsonrpc.rebind.SerializerCreator;
import java.io.PrintWriter;
import java.util.HashMap;

class ResultDeserializerCreator {
    private static final String DSER_SUFFIX = "_ResultDeserializer";
    private GeneratorContext context;
    private HashMap<String, String> generatedDeserializers;
    private SerializerCreator serializerCreator;
    private JArrayType targetType;
    private JType componentType;

    ResultDeserializerCreator(GeneratorContext c, SerializerCreator sc) {
        this.context = c;
        this.generatedDeserializers = new HashMap();
        this.serializerCreator = sc;
    }

    void create(TreeLogger logger, JArrayType targetType) {
        this.targetType = targetType;
        this.componentType = targetType.getComponentType();
        if (this.componentType.isPrimitive() != null || SerializerCreator.isBoxedPrimitive(this.componentType)) {
            logger.log(TreeLogger.DEBUG, "No need to create array deserializer for primitive array " + targetType);
            return;
        }
        if (this.deserializerFor(targetType) != null) {
            return;
        }
        logger.log(TreeLogger.DEBUG, "Creating result deserializer for " + targetType.getSimpleSourceName());
        SourceWriter srcWriter = this.getSourceWriter(logger, this.context);
        if (srcWriter == null) {
            return;
        }
        String dsn = this.getDeserializerQualifiedName(targetType);
        this.generatedDeserializers.put(targetType.getQualifiedSourceName(), dsn);
        this.generateSingleton(srcWriter);
        this.generateInstanceMembers(srcWriter);
        this.generateFromResult(srcWriter);
        srcWriter.commit(logger);
    }

    private void generateSingleton(SourceWriter w) {
        w.print("public static final ");
        w.print(ResultDeserializerCreator.getDeserializerSimpleName((JClassType)this.targetType));
        w.print(" INSTANCE = new ");
        w.print(ResultDeserializerCreator.getDeserializerSimpleName((JClassType)this.targetType));
        w.println("();");
        w.println();
    }

    private void generateInstanceMembers(SourceWriter w) {
        w.print("private final ");
        w.print(this.serializerCreator.serializerFor((JType)this.targetType));
        w.print(" ");
        w.print("serializer");
        w.print(" = ");
        this.serializerCreator.generateSerializerReference((JType)this.targetType, w);
        w.println(";");
        w.println();
    }

    private void generateFromResult(SourceWriter w) {
        String ctn = this.componentType.getQualifiedSourceName();
        w.println("@Override");
        w.print("public " + ctn + "[] ");
        w.println("fromResult(JavaScriptObject responseObject) {");
        w.indent();
        w.print("final " + ctn + "[] tmp = new " + ctn);
        w.println("[getResultSize(responseObject)];");
        w.println("serializer.fromJson(getResult(responseObject), tmp);");
        w.println("return tmp;");
        w.outdent();
        w.println("}");
    }

    private String getDeserializerQualifiedName(JArrayType targetType) {
        String pkgName = this.getDeserializerPackageName(targetType);
        String className = ResultDeserializerCreator.getDeserializerSimpleName((JClassType)targetType);
        return pkgName.length() == 0 ? className : pkgName + "." + className;
    }

    private String getDeserializerPackageName(JArrayType targetType) {
        String compSerializer = this.serializerCreator.serializerFor(targetType.getComponentType());
        int end = compSerializer.lastIndexOf(46);
        return end >= 0 ? compSerializer.substring(0, end) : "";
    }

    private static String getDeserializerSimpleName(JClassType targetType) {
        return ProxyCreator.synthesizeTopLevelClassName(targetType, DSER_SUFFIX)[1];
    }

    private SourceWriter getSourceWriter(TreeLogger logger, GeneratorContext context) {
        String simpleName;
        String pkgName = this.getDeserializerPackageName(this.targetType);
        PrintWriter pw = context.tryCreate(logger, pkgName, simpleName = ResultDeserializerCreator.getDeserializerSimpleName((JClassType)this.targetType));
        if (pw == null) {
            return null;
        }
        ClassSourceFileComposerFactory cf = new ClassSourceFileComposerFactory(pkgName, simpleName);
        cf.addImport(JavaScriptObject.class.getCanonicalName());
        cf.addImport(ResultDeserializer.class.getCanonicalName());
        cf.setSuperclass(ArrayResultDeserializer.class.getCanonicalName());
        cf.addImplementedInterface(ResultDeserializer.class.getCanonicalName() + "<" + this.targetType.getQualifiedSourceName() + ">");
        return cf.createSourceWriter(context, pw);
    }

    private String deserializerFor(JArrayType targetType) {
        JType componentType = targetType.getComponentType();
        if (SerializerCreator.isBoxedPrimitive(componentType)) {
            return PrimitiveArrayResultDeserializers.class.getCanonicalName() + "." + componentType.getSimpleSourceName().toUpperCase() + "_INSTANCE";
        }
        String name = this.generatedDeserializers.get(targetType.getQualifiedSourceName());
        return name == null ? null : name + ".INSTANCE";
    }

    public void generateDeserializerReference(JType targetType, SourceWriter w) {
        if (SerializerCreator.isBoxedPrimitive(targetType)) {
            w.print(PrimitiveResultDeserializers.class.getCanonicalName());
            w.print(".");
            w.print(targetType.getSimpleSourceName().toUpperCase());
            w.print("_INSTANCE");
        } else if (targetType.isArray() != null) {
            w.print(this.deserializerFor(targetType.isArray()));
        } else {
            this.serializerCreator.generateSerializerReference(targetType, w);
        }
    }
}

