/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.engine.utils;

import java.io.File;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.acceleo.engine.internal.evaluation.AcceleoEvaluationVisitor;
import org.eclipse.acceleo.profiler.Profiler;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.ecore.resource.Resource;

public final class AcceleoEngineUtils {
    private AcceleoEngineUtils() {
    }

    public static void setProfiler(Profiler profiler) {
        AcceleoEvaluationVisitor.setProfile(profiler);
    }

    public static Set<String> getPropertiesFilesNearModel(Resource eResource) {
        LinkedHashSet<String> propertiesFilesNearModel = new LinkedHashSet<String>();
        String file = eResource.getURI().toFileString();
        if (file == null) {
            file = eResource.getURI().toString();
        }
        if (file.startsWith("platform:/resource/")) {
            IFile iFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(file.substring("platform:/resource/".length())));
            file = iFile.getLocation().toFile().getAbsolutePath();
        }
        File modelDirectory = new File(file).getParentFile();
        File[] fileArray = modelDirectory.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File propertiesFile = fileArray[n2];
            if (propertiesFile.isFile() && propertiesFile.getName().endsWith(".properties")) {
                String propertiesFilePath = propertiesFile.getAbsolutePath();
                propertiesFilesNearModel.add(propertiesFilePath);
            }
            ++n2;
        }
        return propertiesFilesNearModel;
    }
}

