/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.actions;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionConverter;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.actions.ActionMessages;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.actions.IToggleBreakpointsTarget;
import org.eclipse.debug.ui.actions.IToggleBreakpointsTargetFactory;
import org.eclipse.debug.ui.actions.IToggleBreakpointsTargetManager;
import org.eclipse.debug.ui.actions.IToggleBreakpointsTargetManagerListener;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IVerticalRulerInfo;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.SimpleMarkerAnnotation;

public class ToggleBreakpointsTargetManager
implements IToggleBreakpointsTargetManager {
    public static String DEFAULT_TOGGLE_TARGET_ID = "default";
    private static Set<String> DEFAULT_TOGGLE_TARGET_ID_SET = new TreeSet<String>();
    public static final String PREF_TARGETS = "preferredTargets";
    private static ToggleBreakpointsTargetManager fgSingleton;
    private Map<String, IToggleBreakpointsTargetFactory> fKnownFactories;
    private Map<Set<String>, String> fPreferredTargets;
    private Map<String, IToggleBreakpointsTargetFactory> fFactoriesByTargetID = new HashMap<String, IToggleBreakpointsTargetFactory>();
    private ListenerList<IToggleBreakpointsTargetManagerListener> fChangedListners = new ListenerList();

    static {
        DEFAULT_TOGGLE_TARGET_ID_SET.add(DEFAULT_TOGGLE_TARGET_ID);
    }

    public static ToggleBreakpointsTargetManager getDefault() {
        if (fgSingleton == null) {
            fgSingleton = new ToggleBreakpointsTargetManager();
        }
        return fgSingleton;
    }

    private void initializeFactories() {
        this.fKnownFactories = new LinkedHashMap<String, IToggleBreakpointsTargetFactory>();
        this.fKnownFactories.put(DEFAULT_TOGGLE_TARGET_ID, new ToggleBreakpointsTargetAdapterFactory());
        IExtensionPoint ep = Platform.getExtensionRegistry().getExtensionPoint(DebugUIPlugin.getUniqueIdentifier(), "toggleBreakpointsTargetFactories");
        IConfigurationElement[] iConfigurationElementArray = ep.getConfigurationElements();
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            String id = element.getAttribute("id");
            if (id != null && id.length() != 0) {
                if (this.fKnownFactories.containsKey(id)) {
                    DebugUIPlugin.log((IStatus)new Status(4, DebugUIPlugin.getUniqueIdentifier(), 120, "org.eclipse.debug.ui.toggleBreakpointsTargetFactory extension failed to load breakpoint toggle target because the specified id is already registered.  Specified ID is: " + id, null));
                } else {
                    this.fKnownFactories.put(id, new ToggleTargetFactory(element));
                }
            } else {
                DebugUIPlugin.log((IStatus)new Status(4, DebugUIPlugin.getUniqueIdentifier(), 120, "org.eclipse.debug.ui.toggleBreakpointsTargetFactory extension failed to load breakpoint toggle target because the specified id is empty.", null));
            }
            ++n2;
        }
        System.setProperty("org.eclipse.debug.ui.breakpoints.toggleFactoriesUsed", this.fKnownFactories.size() > 1 ? "true" : "false");
    }

    private Set<IToggleBreakpointsTargetFactory> getEnabledFactories(IWorkbenchPart part, ISelection selection) {
        if (this.fKnownFactories == null) {
            this.initializeFactories();
        }
        HashSet<IToggleBreakpointsTargetFactory> set = new HashSet<IToggleBreakpointsTargetFactory>();
        for (Map.Entry<String, IToggleBreakpointsTargetFactory> entry : this.fKnownFactories.entrySet()) {
            IToggleBreakpointsTargetFactory factory = entry.getValue();
            if (factory instanceof ToggleTargetFactory && ((ToggleTargetFactory)factory).isEnabled(part, selection)) {
                set.add(factory);
                continue;
            }
            if (!(factory instanceof ToggleBreakpointsTargetAdapterFactory) || !((ToggleBreakpointsTargetAdapterFactory)factory).isEnabled(part, selection)) continue;
            set.add(factory);
        }
        return set;
    }

    private Set<String> getEnabledTargetIDs(Set<IToggleBreakpointsTargetFactory> factoriesToQuery, IWorkbenchPart part, ISelection selection) {
        TreeSet<String> idsForSelection = new TreeSet<String>();
        for (IToggleBreakpointsTargetFactory factory : factoriesToQuery) {
            for (String targetID : factory.getToggleTargets(part, selection)) {
                this.fFactoriesByTargetID.put(targetID, factory);
                idsForSelection.add(targetID);
            }
        }
        return idsForSelection;
    }

    @Override
    public Set<String> getEnabledToggleBreakpointsTargetIDs(IWorkbenchPart part, ISelection selection) {
        return this.getEnabledTargetIDs(this.getEnabledFactories(part, selection), part, selection);
    }

    @Override
    public String getPreferredToggleBreakpointsTargetID(IWorkbenchPart part, ISelection selection) {
        Set<IToggleBreakpointsTargetFactory> factories = this.getEnabledFactories(part, selection);
        Set<String> possibleIDs = this.getEnabledTargetIDs(factories, part, selection);
        return this.chooseToggleTargetIDInSet(possibleIDs, part, selection);
    }

    @Override
    public IToggleBreakpointsTarget getToggleBreakpointsTarget(IWorkbenchPart part, ISelection selection) {
        String id = this.getPreferredToggleBreakpointsTargetID(part, selection);
        IToggleBreakpointsTargetFactory factory = this.fFactoriesByTargetID.get(id);
        if (factory != null) {
            if (DEFAULT_TOGGLE_TARGET_ID.equals(id)) {
                return ((ToggleBreakpointsTargetAdapterFactory)factory).createDefaultToggleTarget(part, selection);
            }
            return factory.createToggleTarget(id);
        }
        return null;
    }

    @Override
    public String getToggleBreakpointsTargetName(String id) {
        IToggleBreakpointsTargetFactory factory = this.fFactoriesByTargetID.get(id);
        if (factory != null) {
            return factory.getToggleTargetName(id);
        }
        return null;
    }

    @Override
    public String getToggleBreakpointsTargetDescription(String id) {
        IToggleBreakpointsTargetFactory factory = this.fFactoriesByTargetID.get(id);
        if (factory != null) {
            return factory.getToggleTargetDescription(id);
        }
        return null;
    }

    @Override
    public void addChangedListener(IToggleBreakpointsTargetManagerListener listener) {
        this.fChangedListners.add((Object)listener);
    }

    @Override
    public void removeChangedListener(IToggleBreakpointsTargetManagerListener listener) {
        this.fChangedListners.remove((Object)listener);
    }

    private void storePreferredTargets() {
        StringBuilder buffer = new StringBuilder();
        for (Map.Entry<Set<String>, String> entry : this.fPreferredTargets.entrySet()) {
            for (String currentID : entry.getKey()) {
                buffer.append(currentID);
                buffer.append(',');
            }
            buffer.deleteCharAt(buffer.length() - 1);
            buffer.append(':');
            buffer.append(entry.getValue());
            buffer.append('|');
        }
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode(DebugUIPlugin.getUniqueIdentifier());
        if (prefs != null) {
            prefs.put(PREF_TARGETS, buffer.toString());
        }
    }

    private void loadPreferredTargets() {
        this.fPreferredTargets = new HashMap<Set<String>, String>();
        String preferenceValue = Platform.getPreferencesService().getString(DebugUIPlugin.getUniqueIdentifier(), PREF_TARGETS, null, null);
        if (preferenceValue == null) {
            return;
        }
        StringTokenizer entryTokenizer = new StringTokenizer(preferenceValue, "|");
        while (entryTokenizer.hasMoreTokens()) {
            String token = entryTokenizer.nextToken();
            int valueStart = token.indexOf(58);
            StringTokenizer keyTokenizer = new StringTokenizer(token.substring(0, valueStart), ",");
            TreeSet<String> keys = new TreeSet<String>();
            while (keyTokenizer.hasMoreTokens()) {
                keys.add(keyTokenizer.nextToken());
            }
            this.fPreferredTargets.put(keys, token.substring(valueStart + 1));
        }
    }

    public void setPreferredTarget(Set<String> possibleIDs, String preferredID) {
        String currentKey;
        if (possibleIDs == null) {
            return;
        }
        if (this.fKnownFactories == null) {
            this.initializeFactories();
        }
        if (this.fPreferredTargets == null) {
            this.loadPreferredTargets();
        }
        if ((currentKey = this.fPreferredTargets.get(possibleIDs)) == null || !currentKey.equals(preferredID)) {
            this.fPreferredTargets.put(possibleIDs, preferredID);
            this.storePreferredTargets();
            this.firePreferredTargetsChanged();
        }
    }

    private String getUserPreferredTarget(Set<String> possibleTargetIDs) {
        if (this.fPreferredTargets == null) {
            this.loadPreferredTargets();
        }
        return this.fPreferredTargets.get(possibleTargetIDs);
    }

    private String chooseToggleTargetIDInSet(Set<String> possibleTargetIDs, IWorkbenchPart part, ISelection selection) {
        if (possibleTargetIDs == null || possibleTargetIDs.isEmpty()) {
            return null;
        }
        String preferredID = this.getUserPreferredTarget(possibleTargetIDs);
        if (preferredID == null) {
            Iterator<String> possibleIDsIterator = possibleTargetIDs.iterator();
            while (preferredID == null && possibleIDsIterator.hasNext()) {
                IToggleBreakpointsTargetFactory factory = this.fFactoriesByTargetID.get(possibleIDsIterator.next());
                if (factory == null) continue;
                preferredID = factory.getDefaultToggleTarget(part, selection);
            }
            if (preferredID == null || !possibleTargetIDs.contains(preferredID)) {
                preferredID = possibleTargetIDs.iterator().next();
            }
            this.setPreferredTarget(possibleTargetIDs, preferredID);
        }
        return preferredID;
    }

    private void firePreferredTargetsChanged() {
        for (IToggleBreakpointsTargetManagerListener iToggleBreakpointsTargetManagerListener : this.fChangedListners) {
            iToggleBreakpointsTargetManagerListener.preferredTargetsChanged();
        }
    }

    public IBreakpoint getBeakpointFromEditor(ITextEditor editor, IVerticalRulerInfo info) {
        IDocumentProvider provider = editor.getDocumentProvider();
        if (provider == null) {
            return null;
        }
        IEditorInput input = editor.getEditorInput();
        IAnnotationModel annotationModel = provider.getAnnotationModel((Object)input);
        if (annotationModel != null) {
            IDocument document = provider.getDocument((Object)input);
            Iterator iterator = annotationModel.getAnnotationIterator();
            while (iterator.hasNext()) {
                Annotation annot = (Annotation)iterator.next();
                if (!(annot instanceof SimpleMarkerAnnotation)) continue;
                SimpleMarkerAnnotation markerAnnotation = (SimpleMarkerAnnotation)annot;
                IMarker marker = markerAnnotation.getMarker();
                try {
                    IBreakpoint breakpoint;
                    Position position;
                    int line;
                    if (!marker.isSubtypeOf(IBreakpoint.BREAKPOINT_MARKER) || (line = document.getLineOfOffset((position = annotationModel.getPosition((Annotation)markerAnnotation)).getOffset())) != info.getLineOfLastMouseButtonActivity() || (breakpoint = DebugPlugin.getDefault().getBreakpointManager().getBreakpoint(marker)) == null) continue;
                    return breakpoint;
                }
                catch (CoreException coreException) {
                }
                catch (BadLocationException badLocationException) {}
            }
        }
        return null;
    }

    private static class ToggleBreakpointsTargetAdapterFactory
    implements IToggleBreakpointsTargetFactory {
        private ToggleBreakpointsTargetAdapterFactory() {
        }

        private Object getSelectionElement(ISelection selection) {
            if (selection instanceof IStructuredSelection) {
                IStructuredSelection ss = (IStructuredSelection)selection;
                return ss.getFirstElement();
            }
            return null;
        }

        private boolean canGetToggleBreakpointsTarget(Object adaptable) {
            if (adaptable != null) {
                IToggleBreakpointsTarget adapter = null;
                if (adaptable instanceof IAdaptable) {
                    adapter = (IToggleBreakpointsTarget)((IAdaptable)adaptable).getAdapter(IToggleBreakpointsTarget.class);
                }
                if (adapter == null) {
                    IAdapterManager adapterManager = Platform.getAdapterManager();
                    if (adapterManager.hasAdapter(adaptable, IToggleBreakpointsTarget.class.getName())) {
                        return true;
                    }
                } else {
                    return true;
                }
            }
            return false;
        }

        private IToggleBreakpointsTarget getToggleBreakpointsTarget(IWorkbenchPart part, Object element) {
            IToggleBreakpointsTarget target = null;
            if (element != null) {
                target = (IToggleBreakpointsTarget)DebugPlugin.getAdapter((Object)element, IToggleBreakpointsTarget.class);
            }
            if (target == null) {
                target = (IToggleBreakpointsTarget)DebugPlugin.getAdapter((Object)part, IToggleBreakpointsTarget.class);
            }
            return target;
        }

        public boolean isEnabled(IWorkbenchPart part, ISelection selection) {
            return this.canGetToggleBreakpointsTarget(this.getSelectionElement(selection)) || this.canGetToggleBreakpointsTarget(part);
        }

        @Override
        public IToggleBreakpointsTarget createToggleTarget(String targetID) {
            return null;
        }

        public IToggleBreakpointsTarget createDefaultToggleTarget(IWorkbenchPart part, ISelection selection) {
            return this.getToggleBreakpointsTarget(part, this.getSelectionElement(selection));
        }

        @Override
        public Set<String> getToggleTargets(IWorkbenchPart part, ISelection selection) {
            if (this.isEnabled(part, selection)) {
                return DEFAULT_TOGGLE_TARGET_ID_SET;
            }
            return Collections.EMPTY_SET;
        }

        @Override
        public String getToggleTargetName(String targetID) {
            return ActionMessages.ToggleBreakpointsTargetManager_defaultToggleTarget_name;
        }

        @Override
        public String getToggleTargetDescription(String targetID) {
            return ActionMessages.ToggleBreakpointsTargetManager_defaultToggleTarget_description;
        }

        @Override
        public String getDefaultToggleTarget(IWorkbenchPart part, ISelection selection) {
            return DEFAULT_TOGGLE_TARGET_ID;
        }
    }

    private static class ToggleTargetFactory
    implements IToggleBreakpointsTargetFactory {
        private IConfigurationElement fConfigElement;
        private IToggleBreakpointsTargetFactory fFactory;
        private Expression fEnablementExpression;

        public ToggleTargetFactory(IConfigurationElement configElement) {
            this.fConfigElement = configElement;
        }

        private IToggleBreakpointsTargetFactory getFactory() {
            if (this.fFactory != null) {
                return this.fFactory;
            }
            try {
                Object obj = this.fConfigElement.createExecutableExtension("class");
                if (!(obj instanceof IToggleBreakpointsTargetFactory)) {
                    throw new CoreException((IStatus)new Status(4, DebugUIPlugin.getUniqueIdentifier(), 120, "org.eclipse.debug.ui.toggleBreakpointsTargetFactories extension failed to load breakpoint toggle target because the specified class does not implement org.eclipse.debug.ui.actions.IToggleBreakpointsTargetFactory.  Class specified was: " + String.valueOf(obj), null));
                }
                this.fFactory = (IToggleBreakpointsTargetFactory)obj;
            }
            catch (CoreException e) {
                DebugUIPlugin.log(e.getStatus());
                this.fFactory = null;
            }
            return this.fFactory;
        }

        public boolean isEnabled(IWorkbenchPart part, ISelection selection) {
            boolean enabled = false;
            Expression expression = this.getEnablementExpression();
            enabled = expression != null ? this.evalEnablementExpression(part, selection, expression) : true;
            return enabled;
        }

        private IStructuredSelection getDebugContext(IWorkbenchPart part) {
            ISelection selection = DebugUITools.getDebugContextManager().getContextService(part.getSite().getWorkbenchWindow()).getActiveContext();
            if (selection instanceof IStructuredSelection) {
                return (IStructuredSelection)selection;
            }
            return StructuredSelection.EMPTY;
        }

        private boolean evalEnablementExpression(IWorkbenchPart part, ISelection selection, Expression exp) {
            if (exp != null) {
                IEvaluationContext context = DebugUIPlugin.createEvaluationContext(part);
                List debugContextList = this.getDebugContext(part).toList();
                context.addVariable("debugContext", (Object)debugContextList);
                if (selection instanceof IStructuredSelection) {
                    List selectionList = ((IStructuredSelection)selection).toList();
                    context.addVariable("selection", (Object)selectionList);
                }
                if (part instanceof IEditorPart) {
                    context.addVariable("editorInput", (Object)((IEditorPart)part).getEditorInput());
                }
                try {
                    EvaluationResult result = exp.evaluate(context);
                    if (result == EvaluationResult.TRUE) {
                        return true;
                    }
                }
                catch (CoreException coreException) {}
            }
            return false;
        }

        private Expression getEnablementExpression() {
            if (this.fEnablementExpression == null) {
                try {
                    IConfigurationElement enablement;
                    IConfigurationElement[] elements = this.fConfigElement.getChildren("enablement");
                    IConfigurationElement iConfigurationElement = enablement = elements.length > 0 ? elements[0] : null;
                    if (enablement != null) {
                        this.fEnablementExpression = ExpressionConverter.getDefault().perform(enablement);
                    }
                }
                catch (CoreException e) {
                    DebugUIPlugin.log(e.getStatus());
                    this.fEnablementExpression = null;
                }
            }
            return this.fEnablementExpression;
        }

        @Override
        public IToggleBreakpointsTarget createToggleTarget(String targetID) {
            IToggleBreakpointsTargetFactory factory = this.getFactory();
            if (factory != null) {
                return factory.createToggleTarget(targetID);
            }
            return null;
        }

        @Override
        public Set<String> getToggleTargets(IWorkbenchPart part, ISelection selection) {
            IToggleBreakpointsTargetFactory factory = this.getFactory();
            if (factory != null) {
                return factory.getToggleTargets(part, selection);
            }
            return Collections.EMPTY_SET;
        }

        @Override
        public String getToggleTargetName(String targetID) {
            IToggleBreakpointsTargetFactory factory = this.getFactory();
            if (factory != null) {
                return factory.getToggleTargetName(targetID);
            }
            return null;
        }

        @Override
        public String getToggleTargetDescription(String targetID) {
            IToggleBreakpointsTargetFactory factory = this.getFactory();
            if (factory != null) {
                return factory.getToggleTargetDescription(targetID);
            }
            return null;
        }

        @Override
        public String getDefaultToggleTarget(IWorkbenchPart part, ISelection selection) {
            IToggleBreakpointsTargetFactory factory = this.getFactory();
            if (factory != null) {
                return factory.getDefaultToggleTarget(part, selection);
            }
            return null;
        }
    }
}

