/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.ui.memory;

import java.math.BigInteger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IMemoryBlockExtension;
import org.eclipse.debug.core.model.MemoryByte;
import org.eclipse.debug.internal.ui.DebugUIMessages;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.memory.IMemoryBlockConnection;
import org.eclipse.debug.internal.ui.memory.IPersistableDebugElement;
import org.eclipse.debug.internal.ui.views.memory.MemoryViewUtil;
import org.eclipse.debug.internal.ui.views.memory.renderings.AbstractBaseTableRendering;
import org.eclipse.debug.internal.ui.views.memory.renderings.CopyTableRenderingToClipboardAction;
import org.eclipse.debug.internal.ui.views.memory.renderings.FormatTableRenderingAction;
import org.eclipse.debug.internal.ui.views.memory.renderings.FormatTableRenderingDialog;
import org.eclipse.debug.internal.ui.views.memory.renderings.GoToAddressAction;
import org.eclipse.debug.internal.ui.views.memory.renderings.PrintTableRenderingAction;
import org.eclipse.debug.internal.ui.views.memory.renderings.ReformatAction;
import org.eclipse.debug.internal.ui.views.memory.renderings.ResetToBaseAddressAction;
import org.eclipse.debug.internal.ui.views.memory.renderings.TableRenderingCellModifier;
import org.eclipse.debug.internal.ui.views.memory.renderings.TableRenderingContentInput;
import org.eclipse.debug.internal.ui.views.memory.renderings.TableRenderingContentProvider;
import org.eclipse.debug.internal.ui.views.memory.renderings.TableRenderingLabelProvider;
import org.eclipse.debug.internal.ui.views.memory.renderings.TableRenderingLabelProviderEx;
import org.eclipse.debug.internal.ui.views.memory.renderings.TableRenderingLine;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.memory.IMemoryBlockTablePresentation;
import org.eclipse.debug.ui.memory.IMemoryRendering;
import org.eclipse.debug.ui.memory.IMemoryRenderingSite;
import org.eclipse.debug.ui.memory.IMemoryRenderingSynchronizationService;
import org.eclipse.debug.ui.memory.IResettableMemoryRendering;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.TableCursor;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PropertyDialogAction;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.part.PageBook;

public abstract class AbstractTableRendering
extends AbstractBaseTableRendering
implements IPropertyChangeListener,
IResettableMemoryRendering {
    public static final String PROPERTY_SELECTED_ADDRESS = "selectedAddress";
    public static final String PROPERTY_COL_SIZE = "columnSize";
    public static final String PROPERTY_TOP_ADDRESS = "topAddress";
    public static final String PROPERTY_ROW_SIZE = "rowSize";
    private static final int BUFFER_THRESHOLD = 1;
    private static final int BUFFER_START = 0;
    private static final int BUFFER_END = 1;
    private PageBook fPageBook;
    private TableViewer fTableViewer;
    private TextViewer fTextViewer;
    private int fBytePerLine;
    private int fColumnSize;
    private int fAddressableSize;
    private boolean fIsShowingErrorPage;
    private TableRenderingContentProvider fContentProvider;
    private BigInteger fSelectedAddress;
    private TableRenderingContentInput fContentInput;
    private TableRenderingCellModifier fCellModifier;
    private boolean fIsCreated;
    private CellEditor[] fEditors;
    private String fLabel;
    private TableCursor fTableCursor;
    private boolean fIsDisposed;
    private TraverseListener fCursorTraverseListener;
    private KeyAdapter fCursorKeyAdapter;
    private BigInteger fTopRowAddress;
    private CopyTableRenderingToClipboardAction fCopyToClipboardAction;
    private GoToAddressAction fGoToAddressAction;
    private ResetToBaseAddressAction fResetMemoryBlockAction;
    private PrintTableRenderingAction fPrintViewTabAction;
    private ReformatAction fReformatAction;
    private ToggleAddressColumnAction fToggleAddressColumnAction;
    private EventHandleLock fEvtHandleLock = new EventHandleLock();
    private TableEditor fCursorEditor;
    private FocusAdapter fEditorFocusListener;
    private MouseAdapter fCursorMouseListener;
    private KeyAdapter fEditorKeyListener;
    private SelectionAdapter fCursorSelectionListener;
    private IWorkbenchAdapter fWorkbenchAdapter;
    private IMemoryBlockConnection fConnection;
    private boolean fIsShowAddressColumn = true;
    private SelectionAdapter fScrollbarSelectionListener;
    private PropertyDialogAction fPropertiesAction;
    private int fPageSize;
    private NextPageAction fNextAction;
    private PrevPageAction fPrevAction;
    private Shell fToolTipShell;
    private FormatTableRenderingAction fFormatRenderingAction;
    private IMenuListener fMenuListener;
    private int fPreBuffer;
    private int fPostBuffer;

    public AbstractTableRendering(String renderingId) {
        super(renderingId);
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals("org.eclipse.debug.ui.MemoryViewTableFont")) {
            if (!this.fIsDisposed) {
                Font memoryViewFont = JFaceResources.getFont((String)"org.eclipse.debug.ui.MemoryViewTableFont");
                this.setFont(memoryViewFont);
            }
            return;
        }
        if (event.getProperty().equals("org.eclipse.debug.ui.memory.paddedStr") || event.getProperty().equals("org.eclipse.debug.ui.MemoryHistoryKnownColor") || event.getProperty().equals("org.eclipse.debug.ui.MemoryHistoryUnknownColor")) {
            if (!this.fIsDisposed) {
                this.fTableViewer.refresh();
                this.fTableCursor.redraw();
            }
            return;
        }
        Object evtSrc = event.getSource();
        if (event.getProperty().equals("org.eclispe.debug.ui.memory.pageSize") || event.getProperty().equals("org.eclispe.debug.ui.memory.preBufferSize") || event.getProperty().equals("org.eclispe.debug.ui.memory.postBufferSize")) {
            this.getPageSizeFromPreference();
        }
        if (this.isDisplayingError()) {
            return;
        }
        if (!this.isVisible()) {
            return;
        }
        if (event.getProperty().equals("org.eclpise.debug.ui.memory.dynamicLoad")) {
            this.handleDyanicLoadChanged();
            return;
        }
        if (event.getProperty().equals("org.eclispe.debug.ui.memory.pageSize")) {
            if (!this.isDynamicLoad()) {
                this.refresh();
            }
            return;
        }
        if (event.getProperty().equals("org.eclispe.debug.ui.memory.preBufferSize") || event.getProperty().equals("org.eclispe.debug.ui.memory.postBufferSize")) {
            if (this.isDynamicLoad()) {
                this.refresh();
            }
            return;
        }
        if (evtSrc == this) {
            return;
        }
        if (!(evtSrc instanceof IMemoryRendering)) {
            return;
        }
        IMemoryRendering rendering = (IMemoryRendering)evtSrc;
        IMemoryBlock memoryBlock = rendering.getMemoryBlock();
        if (memoryBlock != this.getMemoryBlock()) {
            return;
        }
        String propertyName = event.getProperty();
        Object value = event.getNewValue();
        if (propertyName.equals(PROPERTY_SELECTED_ADDRESS) && value instanceof BigInteger) {
            this.selectedAddressChanged((BigInteger)value);
        } else if (propertyName.equals(PROPERTY_COL_SIZE) && value instanceof Integer) {
            this.columnSizeChanged((Integer)value);
        } else if (propertyName.equals(PROPERTY_ROW_SIZE) && value instanceof Integer) {
            this.rowSizeChanged((Integer)value);
        } else if (propertyName.equals(PROPERTY_TOP_ADDRESS) && value instanceof BigInteger) {
            if (this.needMoreLines() && this.isDynamicLoad()) {
                this.reloadTable(this.getTopVisibleAddress(), false);
            }
            this.topVisibleAddressChanged((BigInteger)value, false);
        } else if (propertyName.equals("pageStart") && value instanceof BigInteger) {
            this.handlePageStartAddressChanged((BigInteger)value);
        }
    }

    private void handleDyanicLoadChanged() {
        this.updateSyncPageStartAddress();
        this.updateDynamicLoadProperty();
        if (this.isDynamicLoad()) {
            this.refresh();
        } else {
            BigInteger pageStart = (BigInteger)this.getSynchronizedProperty("pageStart");
            if (pageStart == null) {
                pageStart = this.fTopRowAddress;
            }
            this.handlePageStartAddressChanged(pageStart);
        }
    }

    private void updateDynamicLoadProperty() {
        boolean value = DebugUIPlugin.getDefault().getPreferenceStore().getBoolean("org.eclpise.debug.ui.memory.dynamicLoad");
        if (value != this.isDynamicLoad()) {
            this.fContentProvider.setDynamicLoad(value);
            if (!this.fIsDisposed) {
                if (this.isDynamicLoad()) {
                    this.fContentInput.setPostBuffer(20);
                    this.fContentInput.setPreBuffer(20);
                    this.fContentInput.setNumLines(this.getNumberOfVisibleLines());
                } else {
                    this.fContentInput.setPostBuffer(0);
                    this.fContentInput.setPreBuffer(0);
                    this.fContentInput.setNumLines(this.fPageSize);
                }
            }
        }
    }

    private void topVisibleAddressChanged(BigInteger address, boolean force) {
        if (!this.isVisible() && !force) {
            return;
        }
        if (this.isBaseAddressChanged()) {
            return;
        }
        if (!address.equals(this.fTopRowAddress)) {
            this.fTopRowAddress = address;
            this.updateSyncTopAddress();
            if (this.getMemoryBlock() instanceof IMemoryBlockExtension) {
                this.handleTopAddressChangedforExtended(address);
            } else {
                this.handleTopAddressChangedForSimple(address);
            }
        }
    }

    private void handleTopAddressChangedForSimple(BigInteger address) {
        int index = this.findAddressIndex(address);
        Table table = this.fTableViewer.getTable();
        if (index >= 0) {
            AbstractTableRendering.setTopIndex(table, index);
        }
        if (this.isAddressVisible(this.fSelectedAddress)) {
            this.fTableCursor.setVisible(true);
        } else {
            this.fTableCursor.setVisible(false);
        }
    }

    private void handleTopAddressChangedforExtended(BigInteger address) {
        Object evtLockClient = new Object();
        try {
            if (!this.fEvtHandleLock.acquireLock(evtLockClient)) {
                return;
            }
            if (!this.isAddressOutOfRange(address)) {
                Table table = this.fTableViewer.getTable();
                int index = this.findAddressIndex(address);
                int startThreshold = this.getBufferThreshold(0);
                int endThrreshold = this.getBufferThreshold(1);
                if (index >= startThreshold && table.getItemCount() - (index + this.getNumberOfVisibleLines()) >= endThrreshold) {
                    AbstractTableRendering.setTopIndex(table, index);
                } else {
                    int numInBuffer = table.getItemCount();
                    if (index < this.getBufferThreshold(0)) {
                        if (this.isAtTopLimit()) {
                            AbstractTableRendering.setTopIndex(table, index);
                        } else if (this.isDynamicLoad() && this.getBufferThreshold(0) > 0) {
                            this.reloadTable(address, false);
                        } else {
                            AbstractTableRendering.setTopIndex(table, index);
                        }
                    } else if (numInBuffer - (index + this.getNumberOfVisibleLines()) <= this.getBufferThreshold(1)) {
                        if (!this.isAtBottomLimit() && this.isDynamicLoad() && this.getBufferThreshold(1) > 0) {
                            this.reloadTable(address, false);
                        } else {
                            AbstractTableRendering.setTopIndex(table, index);
                        }
                    }
                }
            } else {
                this.reloadTable(address, false);
            }
            if (this.isAddressVisible(this.fSelectedAddress)) {
                this.fTableCursor.setVisible(true);
            } else {
                this.fTableCursor.setVisible(false);
            }
        }
        finally {
            this.fEvtHandleLock.releaseLock(evtLockClient);
        }
    }

    private void selectedAddressChanged(BigInteger value) {
        if (this.isBaseAddressChanged()) {
            return;
        }
        try {
            if (this.isDynamicLoad()) {
                this.goToAddress(value);
            } else if (!this.isAddressOutOfRange(value)) {
                this.goToAddress(value);
            }
        }
        catch (DebugException debugException) {}
    }

    private void handlePageStartAddressChanged(BigInteger address) {
        if (this.isDynamicLoad()) {
            return;
        }
        if (this.fContentInput == null) {
            return;
        }
        if (!(this.getMemoryBlock() instanceof IMemoryBlockExtension)) {
            return;
        }
        if (this.isBaseAddressChanged()) {
            return;
        }
        if (this.fContentProvider.getBufferTopAddress().equals(address)) {
            return;
        }
        BigInteger start = this.fContentInput.getStartAddress();
        BigInteger end = this.fContentInput.getEndAddress();
        if (address.compareTo(start) < 0) {
            if (this.isAtTopLimit()) {
                return;
            }
            address = start;
        }
        if (address.compareTo(end) > 0) {
            if (this.isAtBottomLimit()) {
                return;
            }
            address = end.subtract(BigInteger.valueOf(this.getPageSizeInUnits()));
        }
        this.fContentInput.setLoadAddress(address);
        this.refresh();
        this.updateSyncPageStartAddress();
        AbstractTableRendering.setTopIndex(this.fTableViewer.getTable(), 0);
        this.fTopRowAddress = address;
        this.updateSyncTopAddress();
        BigInteger selectedAddress = (BigInteger)this.getSynchronizedProperty(PROPERTY_SELECTED_ADDRESS);
        if (selectedAddress != null) {
            this.fSelectedAddress = selectedAddress;
            if (!this.isAddressOutOfRange(this.fSelectedAddress)) {
                this.setCursorAtAddress(this.fSelectedAddress);
                this.fTableCursor.setVisible(true);
            } else {
                this.fTableCursor.setVisible(false);
            }
        }
    }

    @Override
    public Control createControl(Composite parent) {
        this.fPageBook = new PageBook(parent, 0);
        this.createErrorPage((Composite)this.fPageBook);
        this.createTableViewer((Composite)this.fPageBook);
        this.fTableViewer.getTable().redraw();
        this.createToolTip();
        return this.fPageBook;
    }

    private void createTableViewer(Composite parent) {
        this.fTableViewer = new TableViewer(parent, 35588);
        TableRenderingLabelProvider labelProvider = this.hasCustomizedDecorations() ? new TableRenderingLabelProviderEx(this) : new TableRenderingLabelProvider(this);
        this.fTableViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        this.fContentProvider = new TableRenderingContentProvider();
        this.fContentProvider.setDynamicLoad(DebugUIPlugin.getDefault().getPreferenceStore().getBoolean("org.eclpise.debug.ui.memory.dynamicLoad"));
        this.fTableViewer.setContentProvider((IContentProvider)this.fContentProvider);
        this.fContentProvider.setViewer((StructuredViewer)this.fTableViewer);
        ScrollBar scroll = ((Table)this.fTableViewer.getControl()).getVerticalBar();
        scroll.setMinimum(-100);
        scroll.setMaximum(200);
        this.fTableViewer.getTable().setHeaderVisible(true);
        this.fTableViewer.getTable().setLinesVisible(true);
        this.fAddressableSize = -1;
        try {
            if (this.getMemoryBlock() instanceof IMemoryBlockExtension) {
                this.fAddressableSize = ((IMemoryBlockExtension)this.getMemoryBlock()).getAddressableSize();
            }
        }
        catch (DebugException e1) {
            this.fAddressableSize = 1;
            this.displayError(e1);
            return;
        }
        if (this.getAddressableSize() < 1) {
            this.fAddressableSize = 1;
        }
        this.setupInitialFormat();
        this.setupSelectedAddress();
        BigInteger topVisibleAddress = this.getInitialTopVisibleAddress();
        this.getPageSizeFromPreference();
        if (this.isDynamicLoad()) {
            int numLines = this.getNumberOfVisibleLines();
            if (numLines <= 0) {
                this.fTableViewer.getTable().addPaintListener(new PaintListener(){

                    public void paintControl(PaintEvent e) {
                        AbstractTableRendering.this.fTableViewer.getTable().removePaintListener((PaintListener)this);
                        AbstractTableRendering.this.fContentInput.setNumLines(AbstractTableRendering.this.getNumberOfVisibleLines());
                        AbstractTableRendering.this.reloadTable(AbstractTableRendering.this.fContentInput.getLoadAddress(), false);
                        AbstractTableRendering.this.resizeColumnsToPreferredSize();
                        AbstractTableRendering.this.setCursorAtAddress(AbstractTableRendering.this.fSelectedAddress);
                        AbstractTableRendering.this.fTableCursor.setVisible(true);
                    }
                });
            }
            this.fContentInput = new TableRenderingContentInput(this, this.fPreBuffer, this.fPostBuffer, topVisibleAddress, numLines, false, null);
        } else {
            BigInteger addressToLoad = topVisibleAddress;
            Object obj = this.getSynchronizedProperty("pageStart");
            if (obj != null && obj instanceof BigInteger) {
                addressToLoad = (BigInteger)obj;
            }
            this.fContentInput = new TableRenderingContentInput(this, 0, 0, addressToLoad, this.fPageSize, false, null);
        }
        this.fTableViewer.setInput((Object)this.fContentInput);
        this.fCellModifier = new TableRenderingCellModifier(this);
        this.fTableViewer.setCellModifier((ICellModifier)this.fCellModifier);
        this.fTableViewer.getTable().setFont(JFaceResources.getFont((String)"org.eclipse.debug.ui.MemoryViewTableFont"));
        if (!(this.getMemoryBlock() instanceof IMemoryBlockExtension)) {
            this.fContentInput.setPreBuffer(0);
            this.fContentInput.setPostBuffer(0);
        }
        this.createCursor(this.fTableViewer.getTable(), this.fSelectedAddress);
        this.fTableViewer.getTable().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                AbstractTableRendering.this.handleTableMouseEvent(e);
            }
        });
        this.createActions();
        this.createPopupMenu(this.fTableViewer.getControl());
        this.createPopupMenu((Control)this.fTableCursor);
        this.fMenuListener = manager -> {
            this.fillContextMenu(manager);
            manager.add((IContributionItem)new Separator("additions"));
        };
        this.getPopupMenuManager().addMenuListener(this.fMenuListener);
        this.fIsCreated = true;
        this.addRenderingToSyncService();
        this.synchronize();
        this.fTopRowAddress = this.getTopVisibleAddress();
        this.resizeColumnsToPreferredSize();
        try {
            if (this.getMemoryBlock() instanceof IMemoryBlockExtension && ((IMemoryBlockExtension)this.getMemoryBlock()).getBigBaseAddress() == null) {
                DebugException e = new DebugException(DebugUIPlugin.newErrorStatus(DebugUIMessages.AbstractTableRendering_1, null));
                this.displayError(e);
            }
        }
        catch (DebugException e1) {
            this.displayError(e1);
        }
        JFaceResources.getFontRegistry().addListener((IPropertyChangeListener)this);
        this.fScrollbarSelectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                AbstractTableRendering.this.handleScrollBarSelection();
            }
        };
        scroll.addSelectionListener((SelectionListener)this.fScrollbarSelectionListener);
        DebugUIPlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
    }

    private boolean validateInitialFormat() {
        int columnSize;
        int rowSize = this.getDefaultRowSize();
        return rowSize >= (columnSize = this.getDefaultColumnSize()) && rowSize % columnSize == 0 && rowSize != 0 && columnSize != 0;
    }

    private BigInteger getInitialTopVisibleAddress() {
        BigInteger topVisibleAddress = (BigInteger)this.getSynchronizedProperty(PROPERTY_TOP_ADDRESS);
        if (topVisibleAddress == null) {
            if (this.getMemoryBlock() instanceof IMemoryBlockExtension) {
                try {
                    topVisibleAddress = ((IMemoryBlockExtension)this.getMemoryBlock()).getBigBaseAddress();
                }
                catch (DebugException debugException) {
                    topVisibleAddress = BigInteger.ZERO;
                }
            } else {
                topVisibleAddress = BigInteger.valueOf(this.getMemoryBlock().getStartAddress());
            }
        }
        return topVisibleAddress;
    }

    private void setupSelectedAddress() {
        BigInteger selectedAddress = (BigInteger)this.getSynchronizedProperty(PROPERTY_SELECTED_ADDRESS);
        if (selectedAddress == null) {
            if (this.getMemoryBlock() instanceof IMemoryBlockExtension) {
                try {
                    selectedAddress = ((IMemoryBlockExtension)this.getMemoryBlock()).getBigBaseAddress();
                }
                catch (DebugException debugException) {
                    selectedAddress = BigInteger.ZERO;
                }
                if (selectedAddress == null) {
                    selectedAddress = BigInteger.ZERO;
                }
            } else {
                long address = this.getMemoryBlock().getStartAddress();
                selectedAddress = BigInteger.valueOf(address);
            }
        }
        this.setSelectedAddress(selectedAddress);
    }

    private void setupInitialFormat() {
        boolean validated = this.validateInitialFormat();
        if (!validated) {
            StringBuilder msgBuffer = new StringBuilder(DebugUIMessages.AbstractTableRendering_20);
            msgBuffer.append(" ");
            msgBuffer.append(this.getLabel());
            msgBuffer.append("\n\n");
            msgBuffer.append(DebugUIMessages.AbstractTableRendering_16);
            msgBuffer.append("\n");
            msgBuffer.append(DebugUIMessages.AbstractTableRendering_18);
            msgBuffer.append("\n\n");
            int bytePerLine = this.fBytePerLine;
            int columnSize = this.fColumnSize;
            this.fBytePerLine = this.getDefaultRowSize() / this.getAddressableSize();
            this.fColumnSize = this.getDefaultColumnSize() / this.getAddressableSize();
            FormatTableRenderingDialog dialog = new FormatTableRenderingDialog(this, DebugUIPlugin.getShell());
            dialog.openError(msgBuffer.toString());
            this.fBytePerLine = bytePerLine;
            this.fColumnSize = columnSize;
            bytePerLine = dialog.getRowSize() * this.getAddressableSize();
            columnSize = dialog.getColumnSize() * this.getAddressableSize();
            this.format(bytePerLine, columnSize);
        } else {
            int columnSize;
            int bytePerLine = this.getDefaultRowSize();
            boolean ok = this.format(bytePerLine, columnSize = this.getDefaultColumnSize());
            if (!ok) {
                this.format(bytePerLine, bytePerLine);
            }
        }
    }

    private int getDefaultColumnSize() {
        IPreferenceStore prefStore = DebugUITools.getPreferenceStore();
        int columnSize = prefStore.getInt("org.eclipse.debug.ui.memory.columnSize");
        columnSize *= this.getAddressableSize();
        Integer colSize = (Integer)this.getSynchronizedProperty(PROPERTY_COL_SIZE);
        if (colSize != null) {
            int syncColSize = colSize;
            if (syncColSize > 0) {
                columnSize = syncColSize;
            }
        } else {
            IPersistableDebugElement elmt = (IPersistableDebugElement)this.getMemoryBlock().getAdapter(IPersistableDebugElement.class);
            int defaultColSize = -1;
            if (elmt != null && elmt.supportsProperty(this, "org.eclipse.debug.ui.AbstractTableRendering.colSize")) {
                defaultColSize = this.getDefaultFromPersistableElement("org.eclipse.debug.ui.AbstractTableRendering.colSize");
            }
            if (defaultColSize <= 0) {
                defaultColSize = this.getDefaultColumnSizeByModel(this.getMemoryBlock().getModelIdentifier());
            }
            if (defaultColSize > 0) {
                columnSize = defaultColSize * this.getAddressableSize();
            }
        }
        return columnSize;
    }

    private int getDefaultRowSize() {
        int rowSize = DebugUITools.getPreferenceStore().getInt("org.eclipse.debug.ui.memory.rowSize");
        int bytePerLine = rowSize * this.getAddressableSize();
        Integer size = (Integer)this.getSynchronizedProperty(PROPERTY_ROW_SIZE);
        if (size != null) {
            int syncRowSize = size;
            if (syncRowSize > 0) {
                bytePerLine = syncRowSize;
            }
        } else {
            int defaultRowSize = -1;
            IPersistableDebugElement elmt = (IPersistableDebugElement)this.getMemoryBlock().getAdapter(IPersistableDebugElement.class);
            if (elmt != null && elmt.supportsProperty(this, "org.eclipse.debug.ui.AbstractTableRendering.rowSize")) {
                defaultRowSize = this.getDefaultFromPersistableElement("org.eclipse.debug.ui.AbstractTableRendering.rowSize");
                return defaultRowSize * this.getAddressableSize();
            }
            if (defaultRowSize <= 0) {
                defaultRowSize = this.getDefaultRowSizeByModel(this.getMemoryBlock().getModelIdentifier());
            }
            if (defaultRowSize > 0) {
                bytePerLine = defaultRowSize * this.getAddressableSize();
            }
        }
        return bytePerLine;
    }

    private int getDefaultFromPersistableElement(String propertyId) {
        int defaultValue = -1;
        IPersistableDebugElement elmt = (IPersistableDebugElement)this.getMemoryBlock().getAdapter(IPersistableDebugElement.class);
        if (elmt != null) {
            try {
                Object valueMB = elmt.getProperty(this, propertyId);
                if (valueMB != null && !(valueMB instanceof Integer)) {
                    IStatus status = DebugUIPlugin.newErrorStatus("Model returned invalid type on " + propertyId, null);
                    DebugUIPlugin.log(status);
                }
                if (valueMB != null) {
                    Integer value = (Integer)valueMB;
                    defaultValue = value;
                }
            }
            catch (CoreException e) {
                DebugUIPlugin.log(e);
            }
        }
        return defaultValue;
    }

    private void getPageSizeFromPreference() {
        this.fPageSize = DebugUIPlugin.getDefault().getPreferenceStore().getInt("org.eclispe.debug.ui.memory.pageSize");
        this.fPreBuffer = DebugUIPlugin.getDefault().getPreferenceStore().getInt("org.eclispe.debug.ui.memory.preBufferSize");
        this.fPostBuffer = DebugUIPlugin.getDefault().getPreferenceStore().getInt("org.eclispe.debug.ui.memory.postBufferSize");
    }

    private void createCursor(Table table, BigInteger address) {
        this.fTableCursor = new TableCursor(table, 0);
        Display display = this.fTableCursor.getDisplay();
        this.fTableCursor.setBackground(display.getSystemColor(26));
        this.fTableCursor.setForeground(display.getSystemColor(27));
        this.fTableCursor.setFont(JFaceResources.getFont((String)"org.eclipse.debug.ui.MemoryViewTableFont"));
        this.fTableCursor.setVisible(true);
        this.fCursorKeyAdapter = new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                AbstractTableRendering.this.handleCursorKeyPressed(e);
            }
        };
        this.fTableCursor.addKeyListener((KeyListener)this.fCursorKeyAdapter);
        this.fCursorTraverseListener = this::handleCursorTraverseEvt;
        this.fTableCursor.addTraverseListener(this.fCursorTraverseListener);
        this.fCursorMouseListener = new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                AbstractTableRendering.this.handleCursorMouseEvent(e);
            }
        };
        this.fTableCursor.addMouseListener((MouseListener)this.fCursorMouseListener);
        this.fTableCursor.addDisposeListener(e -> {
            if (this.fTableCursor == null) {
                return;
            }
            this.fTableCursor.removeTraverseListener(this.fCursorTraverseListener);
            this.fTableCursor.removeKeyListener((KeyListener)this.fCursorKeyAdapter);
            this.fTableCursor.removeMouseListener((MouseListener)this.fCursorMouseListener);
            this.fTableCursor.removeSelectionListener((SelectionListener)this.fCursorSelectionListener);
        });
        this.fCursorSelectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!AbstractTableRendering.this.fEvtHandleLock.acquireLock((Object)this)) {
                    return;
                }
                AbstractTableRendering.this.handleCursorMoved();
                AbstractTableRendering.this.fEvtHandleLock.releaseLock((Object)this);
            }
        };
        this.fTableCursor.addSelectionListener((SelectionListener)this.fCursorSelectionListener);
        this.setCursorAtAddress(address);
        this.fCursorEditor = new TableEditor(this.fTableViewer.getTable());
    }

    private void handleCursorTraverseEvt(TraverseEvent e) {
        Object evtLockClient;
        if (this.fTableCursor.getRow() == null) {
            return;
        }
        Table table = (Table)this.fTableCursor.getParent();
        int row = table.indexOf(this.fTableCursor.getRow());
        int col = this.fTableCursor.getColumn();
        if (col == this.getNumCol() && e.keyCode == 0x1000004) {
            if (row + 1 >= table.getItemCount()) {
                return;
            }
            col = 0;
            this.fTableCursor.setSelection(++row, col);
        }
        if (col <= 1 && e.keyCode == 0x1000003) {
            if (row - 1 < 0) {
                return;
            }
            col = this.getNumCol() + 1;
            this.fTableCursor.setSelection(--row, col);
        }
        if (!this.fEvtHandleLock.acquireLock(evtLockClient = new Object())) {
            return;
        }
        this.handleCursorMoved();
        this.fEvtHandleLock.releaseLock(evtLockClient);
    }

    private void handleCursorMoved() {
        BigInteger address;
        TableItem item;
        if (this.fIsDisposed) {
            return;
        }
        BigInteger selectedAddress = this.getSelectedAddressFromCursor(this.fTableCursor);
        if (selectedAddress != null && !selectedAddress.equals(this.fSelectedAddress)) {
            this.setSelectedAddress(selectedAddress);
            this.updateSyncSelectedAddress();
        }
        if ((item = this.fTableCursor.getRow()) == null) {
            return;
        }
        if (this.getMemoryBlock() instanceof IMemoryBlockExtension) {
            int row = this.fTableViewer.getTable().indexOf(item);
            if (row < this.getBufferThreshold(0)) {
                if (!this.isAtTopLimit() && this.getBufferThreshold(0) > 0 && this.isDynamicLoad()) {
                    this.refresh();
                    this.setCursorAtAddress(this.fSelectedAddress);
                }
            } else if (row >= this.fTableViewer.getTable().getItemCount() - this.getBufferThreshold(1) && !this.isAtBottomLimit() && this.getBufferThreshold(1) > 0 && this.isDynamicLoad()) {
                this.refresh();
                this.setCursorAtAddress(this.fSelectedAddress);
            }
        }
        if (!(address = this.getTopVisibleAddress()).equals(this.fTopRowAddress)) {
            this.fTopRowAddress = address;
            this.updateSyncTopAddress();
        }
    }

    private void handleCursorKeyPressed(KeyEvent event) {
        if (event.character == '\r' && event.getSource() instanceof TableCursor) {
            this.activateCellEditor(null);
            return;
        }
        if (MemoryViewUtil.isValidEditEvent(event.keyCode) && event.getSource() instanceof TableCursor) {
            String initialValue = String.valueOf(event.character);
            this.activateCellEditor(initialValue);
            return;
        }
    }

    private BigInteger getSelectedAddressFromCursor(TableCursor cursor) {
        TableItem row = cursor.getRow();
        int col = cursor.getColumn();
        return this.getAddressFromTableItem(row, col);
    }

    private BigInteger getAddressFromTableItem(TableItem row, int col) {
        int offset;
        if (row == null) {
            return null;
        }
        String temp = ((TableRenderingLine)((Object)row.getData())).getAddress();
        BigInteger rowAddress = new BigInteger(temp, 16);
        if (col > 0) {
            int addressableUnit = this.getAddressableUnitPerColumn();
            offset = (col - 1) * addressableUnit;
        } else {
            offset = 0;
        }
        return rowAddress.add(BigInteger.valueOf(offset));
    }

    private boolean setCursorAtAddress(BigInteger address) {
        if (this.fContentProvider.getBufferTopAddress() == null) {
            return false;
        }
        if (address.compareTo(this.fContentProvider.getBufferTopAddress()) < 0) {
            return false;
        }
        int addressableUnit = this.getAddressableUnitPerLine();
        int numOfRows = address.subtract(this.fContentProvider.getBufferTopAddress()).intValue() / addressableUnit;
        BigInteger rowAddress = this.fContentProvider.getBufferTopAddress().add(BigInteger.valueOf(numOfRows * addressableUnit));
        int row = this.findAddressIndex(address);
        if (row == -1) {
            return false;
        }
        BigInteger offset = address.subtract(rowAddress);
        int colAddressableUnit = this.getAddressableUnitPerColumn();
        int col = offset.intValue() / colAddressableUnit + 1;
        if (col == 0) {
            col = 1;
        }
        this.fTableCursor.setSelection(row, col);
        return true;
    }

    @Override
    public boolean format(int bytesPerLine, int columnSize) {
        int addressableUnit;
        BigInteger selectedAddress = this.fSelectedAddress;
        if (bytesPerLine % columnSize != 0) {
            return false;
        }
        if (bytesPerLine < columnSize) {
            return false;
        }
        if (this.fBytePerLine == bytesPerLine && this.fColumnSize == columnSize) {
            return false;
        }
        this.fBytePerLine = bytesPerLine;
        this.fColumnSize = columnSize;
        Object evtLockClient = new Object();
        if (!this.fEvtHandleLock.acquireLock(evtLockClient)) {
            return false;
        }
        if (this.fIsCreated) {
            CellEditor[] oldCellEditors;
            TableColumn[] oldColumns;
            if (this.fTableViewer == null) {
                return false;
            }
            if (this.fTableViewer.getTable() == null) {
                return false;
            }
            TableColumn[] tableColumnArray = oldColumns = this.fTableViewer.getTable().getColumns();
            int n = oldColumns.length;
            int n2 = 0;
            while (n2 < n) {
                TableColumn oldColumn = tableColumnArray[n2];
                oldColumn.dispose();
                ++n2;
            }
            CellEditor[] cellEditorArray = oldCellEditors = this.fTableViewer.getCellEditors();
            int n3 = oldCellEditors.length;
            n = 0;
            while (n < n3) {
                CellEditor oldCellEditor = cellEditorArray[n];
                oldCellEditor.dispose();
                ++n;
            }
        }
        TableColumn column0 = new TableColumn(this.fTableViewer.getTable(), 16384, 0);
        column0.setText(DebugUIMessages.AbstractTableRendering_2);
        TableColumn[] byteColumns = new TableColumn[bytesPerLine / columnSize];
        String[] columnLabels = new String[]{};
        IMemoryBlockTablePresentation presentation = this.getTablePresentationAdapter();
        if (presentation != null) {
            columnLabels = presentation.getColumnLabels(this.getMemoryBlock(), bytesPerLine, this.getNumCol());
        }
        if (columnLabels == null) {
            columnLabels = new String[]{};
        }
        int i = 0;
        while (i < byteColumns.length) {
            TableColumn column = new TableColumn(this.fTableViewer.getTable(), 16384, i + 1);
            if (columnLabels.length == byteColumns.length) {
                column.setText(columnLabels[i]);
            } else {
                addressableUnit = columnSize / this.getAddressableSize();
                if (this.getAddressableUnitPerColumn() >= 4) {
                    column.setText(Integer.toHexString(i * addressableUnit).toUpperCase() + " - " + Integer.toHexString(i * addressableUnit + addressableUnit - 1).toUpperCase());
                } else {
                    column.setText(Integer.toHexString(i * addressableUnit).toUpperCase());
                }
            }
            ++i;
        }
        TableColumn emptyCol = new TableColumn(this.fTableViewer.getTable(), 16384, byteColumns.length + 1);
        emptyCol.setText(" ");
        emptyCol.setWidth(1);
        emptyCol.setResizable(false);
        String[] columnProperties = new String[byteColumns.length + 2];
        columnProperties[0] = "address";
        addressableUnit = columnSize / this.getAddressableSize();
        int i2 = 1;
        while (i2 < columnProperties.length - 1) {
            columnProperties[i2] = Integer.toHexString((i2 - 1) * addressableUnit);
            ++i2;
        }
        columnProperties[columnProperties.length - 1] = " ";
        this.fTableViewer.setColumnProperties(columnProperties);
        Table table = this.fTableViewer.getTable();
        this.fEditors = new CellEditor[table.getColumnCount()];
        int i3 = 0;
        while (i3 < this.fEditors.length) {
            this.fEditors[i3] = new TextCellEditor((Composite)table);
            ++i3;
        }
        this.fTableViewer.setCellEditors(this.fEditors);
        if (this.fIsCreated) {
            this.fTableViewer.refresh();
        }
        this.resizeColumnsToPreferredSize();
        this.updateSyncRowSize();
        this.updateSyncColSize();
        if (this.fIsCreated) {
            i3 = this.findAddressIndex(this.fTopRowAddress);
            if (i3 >= 0) {
                AbstractTableRendering.setTopIndex(this.fTableViewer.getTable(), i3);
            }
            if (this.isAddressVisible(selectedAddress)) {
                this.setCursorAtAddress(selectedAddress);
            }
        }
        this.fEvtHandleLock.releaseLock(evtLockClient);
        return true;
    }

    private void createErrorPage(Composite parent) {
        if (this.fTextViewer == null) {
            this.fTextViewer = new TextViewer(parent, 64);
            this.fTextViewer.setDocument((IDocument)new Document());
            StyledText styleText = this.fTextViewer.getTextWidget();
            styleText.setEditable(false);
            styleText.setEnabled(false);
        }
    }

    public void displayTable() {
        this.fIsShowingErrorPage = false;
        this.fPageBook.showPage(this.fTableViewer.getControl());
    }

    public void displayError(DebugException e) {
        StyledText styleText = null;
        this.fIsShowingErrorPage = true;
        styleText = this.fTextViewer.getTextWidget();
        if (styleText != null) {
            styleText.setText(DebugUIMessages.AbstractTableRendering_3 + e.getMessage());
        }
        this.fPageBook.showPage(this.fTextViewer.getControl());
        this.fContentProvider.clearContentCache();
    }

    public boolean isDisplayingError() {
        return this.fIsShowingErrorPage;
    }

    @Override
    public Control getControl() {
        return this.fPageBook;
    }

    @Override
    public int getAddressableSize() {
        return this.fAddressableSize;
    }

    private Object getSynchronizedProperty(String propertyId) {
        IMemoryRenderingSynchronizationService syncService = this.getMemoryRenderingContainer().getMemoryRenderingSite().getSynchronizationService();
        if (syncService == null) {
            return null;
        }
        return syncService.getProperty(this.getMemoryBlock(), propertyId);
    }

    private int getNumberOfVisibleLines() {
        int numberOfLines;
        if (this.fTableViewer == null) {
            return -1;
        }
        Table table = this.fTableViewer.getTable();
        int height = this.fTableViewer.getTable().getSize().y;
        if (height == 0) {
            height = this.fTableViewer.getTable().getParent().getSize().y;
        }
        if ((numberOfLines = this.doGetNumberOfVisibleLines(table, height)) <= 0) {
            return 0;
        }
        return numberOfLines;
    }

    private int doGetNumberOfVisibleLines(Table table, int height) {
        int border = this.fTableViewer.getTable().getHeaderHeight();
        int scroll = this.fTableViewer.getTable().getHorizontalBar().getSize().y;
        height = height - border - scroll;
        int lineHeight = this.getMinTableItemHeight(table);
        int numberOfLines = height / lineHeight;
        return numberOfLines;
    }

    private static void setTopIndex(Table table, int index) {
        table.setTopIndex(index);
    }

    private void addRenderingToSyncService() {
        IMemoryRenderingSynchronizationService syncService = this.getMemoryRenderingContainer().getMemoryRenderingSite().getSynchronizationService();
        if (syncService == null) {
            return;
        }
        syncService.addPropertyChangeListener(this, null);
        if (!this.isDisplayingError()) {
            Object pageStartAddress;
            if (syncService.getSynchronizationProvider() == null) {
                syncService.setSynchronizationProvider(this);
            }
            Object selectedAddress = this.getSynchronizedProperty(PROPERTY_SELECTED_ADDRESS);
            Object rowSize = this.getSynchronizedProperty(PROPERTY_ROW_SIZE);
            Object colSize = this.getSynchronizedProperty(PROPERTY_COL_SIZE);
            Object topAddress = this.getSynchronizedProperty(PROPERTY_TOP_ADDRESS);
            if (!this.isDynamicLoad() && (pageStartAddress = this.getSynchronizedProperty("pageStart")) == null) {
                this.updateSyncPageStartAddress();
            }
            if (selectedAddress == null) {
                this.updateSyncSelectedAddress();
            }
            if (rowSize == null) {
                this.updateSyncRowSize();
            }
            if (colSize == null) {
                this.updateSyncColSize();
            }
            if (topAddress == null) {
                this.updateSyncTopAddress();
            }
        }
    }

    private void synchronize() {
        int colSize;
        int rSize;
        if (!this.isDynamicLoad()) {
            BigInteger pageStart = (BigInteger)this.getSynchronizedProperty("pageStart");
            if (pageStart != null && this.fContentInput != null && this.fContentInput.getLoadAddress() != null) {
                if (!this.fContentInput.getLoadAddress().equals(pageStart)) {
                    this.handlePageStartAddressChanged(pageStart);
                }
            } else if (pageStart != null) {
                this.handlePageStartAddressChanged(pageStart);
            }
        }
        Integer rowSize = (Integer)this.getSynchronizedProperty(PROPERTY_ROW_SIZE);
        Integer columnSize = (Integer)this.getSynchronizedProperty(PROPERTY_COL_SIZE);
        BigInteger selectedAddress = (BigInteger)this.getSynchronizedProperty(PROPERTY_SELECTED_ADDRESS);
        BigInteger topAddress = (BigInteger)this.getSynchronizedProperty(PROPERTY_TOP_ADDRESS);
        if (rowSize != null && (rSize = rowSize.intValue()) > 0 && rSize != this.fBytePerLine) {
            this.rowSizeChanged(rSize);
        }
        if (columnSize != null && (colSize = columnSize.intValue()) > 0 && colSize != this.fColumnSize) {
            this.columnSizeChanged(colSize);
        }
        if (topAddress != null && !topAddress.equals(this.getTopVisibleAddress())) {
            if (selectedAddress != null && !this.fSelectedAddress.equals(selectedAddress)) {
                this.selectedAddressChanged(selectedAddress);
            }
            this.topVisibleAddressChanged(topAddress, false);
        }
        if (selectedAddress != null && selectedAddress.compareTo(this.fSelectedAddress) != 0) {
            this.selectedAddressChanged(selectedAddress);
        }
    }

    @Override
    public void resizeColumnsToPreferredSize() {
        Table table = this.fTableViewer.getTable();
        TableColumn[] columns = table.getColumns();
        int i = 0;
        while (i < columns.length - 1) {
            columns[i].pack();
            ++i;
        }
        if (!this.fIsShowAddressColumn) {
            columns[0].setWidth(0);
        }
    }

    private void updateSyncSelectedAddress() {
        if (!this.fIsCreated) {
            return;
        }
        PropertyChangeEvent event = new PropertyChangeEvent((Object)this, PROPERTY_SELECTED_ADDRESS, null, (Object)this.fSelectedAddress);
        this.firePropertyChangedEvent(event);
    }

    private void updateSyncColSize() {
        if (!this.fIsCreated) {
            return;
        }
        PropertyChangeEvent event = new PropertyChangeEvent((Object)this, PROPERTY_COL_SIZE, null, (Object)this.fColumnSize);
        this.firePropertyChangedEvent(event);
    }

    private void updateSyncRowSize() {
        if (!this.fIsCreated) {
            return;
        }
        PropertyChangeEvent event = new PropertyChangeEvent((Object)this, PROPERTY_ROW_SIZE, null, (Object)this.fBytePerLine);
        this.firePropertyChangedEvent(event);
    }

    private void updateSyncTopAddress() {
        if (!this.fIsCreated) {
            return;
        }
        PropertyChangeEvent event = new PropertyChangeEvent((Object)this, PROPERTY_TOP_ADDRESS, null, (Object)this.fTopRowAddress);
        this.firePropertyChangedEvent(event);
    }

    private void updateSyncPageStartAddress() {
        if (!this.fIsCreated) {
            return;
        }
        if (this.isBaseAddressChanged()) {
            return;
        }
        BigInteger pageStart = this.isDynamicLoad() ? this.fTopRowAddress : this.fContentProvider.getBufferTopAddress();
        PropertyChangeEvent event = new PropertyChangeEvent((Object)this, "pageStart", null, (Object)pageStart);
        this.firePropertyChangedEvent(event);
    }

    protected void fillContextMenu(IMenuManager menu) {
        menu.add((IContributionItem)new Separator("topMenu"));
        menu.add((IAction)this.fResetMemoryBlockAction);
        menu.add((IAction)this.fGoToAddressAction);
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)this.fFormatRenderingAction);
        if (!this.isDynamicLoad() && this.getMemoryBlock() instanceof IMemoryBlockExtension) {
            menu.add((IContributionItem)new Separator());
            menu.add((IAction)this.fPrevAction);
            menu.add((IAction)this.fNextAction);
        }
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)this.fReformatAction);
        menu.add((IAction)this.fToggleAddressColumnAction);
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)this.fCopyToClipboardAction);
        menu.add((IAction)this.fPrintViewTabAction);
        if (this.fPropertiesAction != null) {
            menu.add((IContributionItem)new Separator());
            menu.add((IAction)this.fPropertiesAction);
        }
    }

    @Override
    public int getAddressableUnitPerLine() {
        return this.fBytePerLine / this.getAddressableSize();
    }

    @Override
    public int getAddressableUnitPerColumn() {
        return this.fColumnSize / this.getAddressableSize();
    }

    @Override
    public int getBytesPerColumn() {
        return this.fColumnSize;
    }

    @Override
    public int getBytesPerLine() {
        return this.fBytePerLine;
    }

    @Override
    public void updateLabels() {
        this.updateRenderingLabel(true);
        if (this.fTableViewer != null) {
            this.setColumnHeadings();
            this.fTableViewer.refresh();
        }
    }

    @Override
    public String getLabel() {
        if (this.fLabel == null) {
            this.fLabel = this.buildLabel(true);
        }
        return this.fLabel;
    }

    protected void updateRenderingLabel(boolean showAddress) {
        this.fLabel = this.buildLabel(showAddress);
        this.firePropertyChangedEvent(new PropertyChangeEvent((Object)this, "org.eclipse.jface.text", null, (Object)this.fLabel));
    }

    private String buildLabel(boolean showAddress) {
        String preName;
        Object label = "";
        if (this.getMemoryBlock() instanceof IMemoryBlockExtension) {
            label = ((IMemoryBlockExtension)this.getMemoryBlock()).getExpression();
            if (label == null) {
                label = DebugUIMessages.AbstractTableRendering_8;
            }
            if (((String)label).startsWith("&")) {
                label = "&" + (String)label;
            }
            try {
                if (showAddress && ((IMemoryBlockExtension)this.getMemoryBlock()).getBigBaseAddress() != null) {
                    label = (String)label + " : 0x";
                    label = (String)label + ((IMemoryBlockExtension)this.getMemoryBlock()).getBigBaseAddress().toString(16).toUpperCase();
                }
            }
            catch (DebugException debugException) {}
        } else {
            long address = this.getMemoryBlock().getStartAddress();
            label = Long.toHexString(address).toUpperCase();
        }
        if ((preName = DebugUITools.getMemoryRenderingManager().getRenderingType(this.getRenderingId()).getLabel()) != null) {
            label = (String)label + " <" + preName + ">";
        }
        return this.decorateLabel((String)label);
    }

    private void setColumnHeadings() {
        String[] columnLabels = new String[]{};
        IMemoryBlockTablePresentation presentation = this.getTablePresentationAdapter();
        if (presentation != null) {
            columnLabels = presentation.getColumnLabels(this.getMemoryBlock(), this.fBytePerLine, this.getNumCol());
        }
        if (columnLabels == null) {
            columnLabels = new String[]{};
        }
        int numByteColumns = this.fBytePerLine / this.fColumnSize;
        TableColumn[] columns = this.fTableViewer.getTable().getColumns();
        int j = 0;
        int i = 1;
        while (i < columns.length - 1) {
            if (columnLabels.length == numByteColumns) {
                columns[i].setText(columnLabels[j]);
                ++j;
            } else {
                if (this.fColumnSize >= 4) {
                    columns[i].setText(Integer.toHexString(j * this.fColumnSize).toUpperCase() + " - " + Integer.toHexString(j * this.fColumnSize + this.fColumnSize - 1).toUpperCase());
                } else {
                    columns[i].setText(Integer.toHexString(j * this.fColumnSize).toUpperCase());
                }
                ++j;
            }
            ++i;
        }
    }

    @Override
    public void refresh() {
        IMemoryBlock mem = this.getMemoryBlock();
        if (mem instanceof IMemoryBlockExtension) {
            try {
                BigInteger address = ((IMemoryBlockExtension)mem).getBigBaseAddress();
                if (address == null) {
                    DebugException e = new DebugException(DebugUIPlugin.newErrorStatus(DebugUIMessages.AbstractTableRendering_10, null));
                    this.displayError(e);
                    return;
                }
                this.updateRenderingLabel(true);
                if (address.compareTo(this.fContentProvider.getContentBaseAddress()) != 0) {
                    this.setSelectedAddress(address);
                    this.updateSyncSelectedAddress();
                    this.reloadTable(address, true);
                    if (!this.isDynamicLoad()) {
                        this.updateSyncPageStartAddress();
                        AbstractTableRendering.setTopIndex(this.fTableViewer.getTable(), 0);
                    }
                    this.fTopRowAddress = this.getTopVisibleAddress();
                    this.updateSyncTopAddress();
                    this.fContentInput.updateContentBaseAddress();
                }
                address = this.isDynamicLoad() ? this.getTopVisibleAddress() : this.fContentInput.getLoadAddress();
                this.reloadTable(address, true);
            }
            catch (DebugException e) {
                this.displayError(e);
                return;
            }
        } else {
            BigInteger address = BigInteger.valueOf(mem.getStartAddress());
            this.reloadTable(address, true);
        }
    }

    private synchronized void reloadTable(BigInteger topAddress, boolean updateDelta) {
        if (this.fTableViewer == null) {
            return;
        }
        Table table = (Table)this.fTableViewer.getControl();
        TableRenderingContentInput input = this.isDynamicLoad() ? new TableRenderingContentInput(this, this.fPreBuffer, this.fPostBuffer, topAddress, this.getNumberOfVisibleLines(), updateDelta, null) : new TableRenderingContentInput(this, this.fContentInput.getPreBuffer(), this.fContentInput.getPostBuffer(), topAddress, this.fPageSize, updateDelta, null);
        this.fContentInput = input;
        this.fTableViewer.setInput((Object)this.fContentInput);
        if (this.isDynamicLoad()) {
            int topIdx;
            if (this.getMemoryBlock() instanceof IMemoryBlockExtension && (topIdx = this.findAddressIndex(topAddress)) != -1) {
                AbstractTableRendering.setTopIndex(table, topIdx);
            }
            if (this.isAddressVisible(this.fSelectedAddress)) {
                this.setCursorAtAddress(this.fSelectedAddress);
            }
        } else if (!this.isAddressOutOfRange(this.fSelectedAddress)) {
            this.setCursorAtAddress(this.fSelectedAddress);
            this.fTableCursor.setVisible(true);
        } else {
            this.fTableCursor.setVisible(false);
        }
    }

    private BigInteger getTopVisibleAddress() {
        if (this.fTableViewer == null) {
            return BigInteger.ZERO;
        }
        Table table = this.fTableViewer.getTable();
        int topIndex = AbstractTableRendering.getTopVisibleIndex(table);
        if (topIndex < 1) {
            topIndex = 0;
        }
        if (table.getItemCount() > topIndex) {
            TableRenderingLine topItem = (TableRenderingLine)((Object)table.getItem(topIndex).getData());
            String calculatedAddress = null;
            calculatedAddress = topItem == null ? table.getItem(topIndex).getText() : topItem.getAddress();
            BigInteger bigInt = new BigInteger(calculatedAddress, 16);
            return bigInt;
        }
        return BigInteger.ZERO;
    }

    private int findAddressIndex(BigInteger address) {
        TableItem[] items = this.fTableViewer.getTable().getItems();
        int i = 0;
        while (i < items.length) {
            if (items[i] != null) {
                TableRenderingLine line = (TableRenderingLine)((Object)items[i].getData());
                BigInteger lineAddress = new BigInteger(line.getAddress(), 16);
                int addressableUnit = this.getAddressableUnitPerLine();
                BigInteger endLineAddress = lineAddress.add(BigInteger.valueOf(addressableUnit));
                if (lineAddress.compareTo(address) <= 0 && endLineAddress.compareTo(address) > 0) {
                    return i;
                }
            }
            ++i;
        }
        return -1;
    }

    private static int getTopVisibleIndex(Table table) {
        TableItem item;
        int index = table.getTopIndex();
        try {
            item = table.getItem(index);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return 0;
        }
        int cnt = table.getItemCount();
        while (item.getBounds((int)0).y < 0) {
            if (++index >= cnt) {
                --index;
                break;
            }
            item = table.getItem(index);
        }
        return index;
    }

    public TableViewer getTableViewer() {
        return this.fTableViewer;
    }

    @Override
    public void dispose() {
        try {
            ScrollBar scroll;
            if (this.fIsDisposed) {
                return;
            }
            this.fIsDisposed = true;
            if (this.fContentProvider != null) {
                this.fContentProvider.dispose();
            }
            if ((scroll = ((Table)this.fTableViewer.getControl()).getVerticalBar()) != null && !scroll.isDisposed()) {
                scroll.removeSelectionListener((SelectionListener)this.fScrollbarSelectionListener);
            }
            if (!this.fTableCursor.isDisposed()) {
                this.fTableCursor.removeTraverseListener(this.fCursorTraverseListener);
                this.fTableCursor.removeKeyListener((KeyListener)this.fCursorKeyAdapter);
                this.fTableCursor.removeMouseListener((MouseListener)this.fCursorMouseListener);
            }
            this.fCursorEditor.dispose();
            this.fTextViewer = null;
            this.fTableViewer = null;
            this.fTableCursor = null;
            CellEditor[] cellEditorArray = this.fEditors;
            int n = this.fEditors.length;
            int n2 = 0;
            while (n2 < n) {
                CellEditor editor = cellEditorArray[n2];
                editor.dispose();
                ++n2;
            }
            JFaceResources.getFontRegistry().removeListener((IPropertyChangeListener)this);
            IMemoryRenderingSynchronizationService syncService = this.getMemoryRenderingContainer().getMemoryRenderingSite().getSynchronizationService();
            if (syncService != null) {
                syncService.removePropertyChangeListener(this);
            }
            DebugUIPlugin.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
            this.fToolTipShell.dispose();
            if (this.getPopupMenuManager() != null) {
                this.getPopupMenuManager().removeMenuListener(this.fMenuListener);
            }
            super.dispose();
        }
        catch (Exception exception) {}
    }

    private int getNumCol() {
        int bytesPerLine = this.getBytesPerLine();
        int columnSize = this.getBytesPerColumn();
        return bytesPerLine / columnSize;
    }

    private void setFont(Font font) {
        int oldIdx = AbstractTableRendering.getTopVisibleIndex(this.fTableViewer.getTable());
        AbstractTableRendering.setTopIndex(this.fTableViewer.getTable(), 0);
        this.fTableViewer.getTable().setFont(font);
        this.fTableCursor.setFont(font);
        AbstractTableRendering.setTopIndex(this.fTableViewer.getTable(), oldIdx);
        this.resizeColumnsToPreferredSize();
        this.setCursorAtAddress(this.fSelectedAddress);
    }

    @Override
    public void goToAddress(BigInteger address) throws DebugException {
        Object evtLockClient = new Object();
        try {
            if (!this.fEvtHandleLock.acquireLock(evtLockClient)) {
                return;
            }
            if (!this.isAddressOutOfRange(address)) {
                this.setSelectedAddress(address);
                this.updateSyncSelectedAddress();
                this.setCursorAtAddress(this.fSelectedAddress);
                if (!this.isAddressVisible(this.fSelectedAddress)) {
                    int i = this.findAddressIndex(this.fSelectedAddress);
                    this.fTableViewer.getTable().showItem(this.fTableViewer.getTable().getItem(i));
                }
            } else {
                if (!(this.getMemoryBlock() instanceof IMemoryBlockExtension)) {
                    Status stat = new Status(4, DebugUIPlugin.getUniqueIdentifier(), 5011, DebugUIMessages.AbstractTableRendering_11, null);
                    DebugException e = new DebugException((IStatus)stat);
                    throw e;
                }
                BigInteger startAdd = this.fContentInput.getStartAddress();
                BigInteger endAdd = this.fContentInput.getEndAddress();
                if (address.compareTo(startAdd) < 0 || address.compareTo(endAdd) > 0) {
                    Status stat = new Status(4, DebugUIPlugin.getUniqueIdentifier(), 5011, DebugUIMessages.AbstractTableRendering_11, null);
                    DebugException e = new DebugException((IStatus)stat);
                    throw e;
                }
                this.setSelectedAddress(address);
                this.updateSyncSelectedAddress();
                this.reloadTable(address, false);
                if (!this.isDynamicLoad()) {
                    this.updateSyncPageStartAddress();
                }
                this.fTopRowAddress = address;
                this.updateSyncTopAddress();
                this.setCursorAtAddress(address);
            }
            this.fTableCursor.setVisible(true);
        }
        finally {
            this.fEvtHandleLock.releaseLock(evtLockClient);
        }
    }

    private boolean isAddressOutOfRange(BigInteger address) {
        return this.fContentProvider.isAddressOutOfRange(address);
    }

    private boolean isAddressVisible(BigInteger address) {
        if (!this.fIsCreated) {
            return true;
        }
        BigInteger topVisible = this.getTopVisibleAddress();
        int addressableUnit = this.getAddressableUnitPerLine();
        BigInteger lastVisible = this.getTopVisibleAddress().add(BigInteger.valueOf(this.getNumberOfVisibleLines() * addressableUnit + addressableUnit));
        return topVisible.compareTo(address) <= 0 && lastVisible.compareTo(address) > 0;
    }

    protected void createActions() {
        this.fCopyToClipboardAction = new CopyTableRenderingToClipboardAction(this, (StructuredViewer)this.fTableViewer);
        this.fGoToAddressAction = new GoToAddressAction(this.getMemoryRenderingContainer(), this);
        this.fResetMemoryBlockAction = new ResetToBaseAddressAction(this);
        this.fPrintViewTabAction = new PrintTableRenderingAction(this, (StructuredViewer)this.fTableViewer);
        this.fFormatRenderingAction = new FormatTableRenderingAction(this);
        this.fReformatAction = new ReformatAction(this);
        this.fToggleAddressColumnAction = new ToggleAddressColumnAction();
        IMemoryRenderingSite site = this.getMemoryRenderingContainer().getMemoryRenderingSite();
        if (site.getSite().getSelectionProvider() != null) {
            this.fPropertiesAction = new PropertyDialogAction((IShellProvider)site.getSite(), site.getSite().getSelectionProvider());
        }
        this.fNextAction = new NextPageAction();
        this.fPrevAction = new PrevPageAction();
    }

    private synchronized void handleScrollBarSelection() {
        Object evtLockClient = new Object();
        try {
            if (this.fIsDisposed) {
                return;
            }
            BigInteger address = this.getTopVisibleAddress();
            if (!this.fTopRowAddress.equals(address)) {
                this.fTopRowAddress = address;
                this.updateSyncTopAddress();
            }
            if (!this.fEvtHandleLock.acquireLock(evtLockClient)) {
                return;
            }
            if (this.getMemoryBlock() instanceof IMemoryBlockExtension) {
                if (this.isDynamicLoad()) {
                    if (!this.isAddressOutOfRange(address)) {
                        Table table = this.fTableViewer.getTable();
                        int numInBuffer = table.getItemCount();
                        int index = this.findAddressIndex(address);
                        if (index < this.getBufferThreshold(0)) {
                            if (this.isAtTopLimit()) {
                                AbstractTableRendering.setTopIndex(table, index);
                            } else if (this.getBufferThreshold(0) > 0) {
                                this.reloadTable(address, false);
                            }
                        } else if (this.getBufferThreshold(1) != 0 && numInBuffer - (index + this.getNumberOfVisibleLines()) <= this.getBufferThreshold(1) && !this.isAtBottomLimit() && this.getBufferThreshold(1) > 0) {
                            this.reloadTable(address, false);
                        }
                    } else {
                        this.reloadTable(address, false);
                    }
                }
                if (this.isAddressVisible(this.fSelectedAddress)) {
                    this.fTableCursor.setVisible(true);
                } else {
                    this.fTableCursor.setVisible(false);
                }
            }
        }
        finally {
            this.fEvtHandleLock.releaseLock(evtLockClient);
        }
    }

    private boolean isAtTopLimit() {
        BigInteger startAddress = this.fContentInput.getStartAddress();
        startAddress = MemoryViewUtil.alignToBoundary(startAddress, this.getAddressableUnitPerLine());
        BigInteger startBufferAddress = this.fContentProvider.getBufferTopAddress();
        return startAddress.compareTo(startBufferAddress = MemoryViewUtil.alignToBoundary(startBufferAddress, this.getAddressableUnitPerLine())) == 0;
    }

    private boolean isAtBottomLimit() {
        BigInteger endAddress = this.fContentInput.getEndAddress();
        endAddress = MemoryViewUtil.alignToBoundary(endAddress, this.getAddressableUnitPerLine());
        BigInteger endBufferAddress = this.fContentProvider.getBufferEndAddress();
        return endAddress.compareTo(endBufferAddress = MemoryViewUtil.alignToBoundary(endBufferAddress, this.getAddressableUnitPerLine())) == 0;
    }

    private boolean needMoreLines() {
        if (this.getMemoryBlock() instanceof IMemoryBlockExtension) {
            Table table = this.fTableViewer.getTable();
            TableItem firstItem = table.getItem(0);
            TableItem lastItem = table.getItem(table.getItemCount() - 1);
            if (firstItem == null || lastItem == null) {
                return true;
            }
            TableRenderingLine first = (TableRenderingLine)((Object)firstItem.getData());
            TableRenderingLine last = (TableRenderingLine)((Object)lastItem.getData());
            if (first == null || last == null) {
                return true;
            }
            BigInteger startAddress = new BigInteger(first.getAddress(), 16);
            BigInteger lastAddress = new BigInteger(last.getAddress(), 16);
            int addressableUnit = this.getAddressableUnitPerLine();
            lastAddress = lastAddress.add(BigInteger.valueOf(addressableUnit));
            BigInteger topVisibleAddress = this.getTopVisibleAddress();
            long numVisibleLines = this.getNumberOfVisibleLines();
            long numOfBytes = numVisibleLines * (long)addressableUnit;
            BigInteger lastVisibleAddrss = topVisibleAddress.add(BigInteger.valueOf(numOfBytes));
            BigInteger numTopLine = topVisibleAddress.subtract(startAddress).divide(BigInteger.valueOf(addressableUnit));
            if (numTopLine.compareTo(BigInteger.valueOf(this.getBufferThreshold(0))) <= 0 && startAddress.compareTo(BigInteger.ZERO) != 0 && !this.isAtTopLimit() && this.getBufferThreshold(0) > 0) {
                return true;
            }
            BigInteger numBottomLine = lastAddress.subtract(lastVisibleAddrss).divide(BigInteger.valueOf(addressableUnit));
            return numBottomLine.compareTo(BigInteger.valueOf(this.getBufferThreshold(1))) <= 0 && !this.isAtBottomLimit() && this.getBufferThreshold(1) > 0;
        }
        return false;
    }

    private void handleTableMouseEvent(MouseEvent e) {
        TableItem[] tableItems = this.fTableViewer.getTable().getItems();
        TableItem selectedRow = null;
        int colNum = -1;
        int numCol = this.fTableViewer.getColumnProperties().length;
        TableItem[] tableItemArray = tableItems;
        int n = tableItems.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            int i = 0;
            while (i < numCol) {
                Rectangle bound = item.getBounds(i);
                if (bound.contains(e.x, e.y)) {
                    colNum = i;
                    selectedRow = item;
                    break;
                }
                ++i;
            }
            ++n2;
        }
        if (colNum < 1) {
            return;
        }
        if (selectedRow != null) {
            int row = this.fTableViewer.getTable().indexOf(selectedRow);
            this.fTableCursor.setVisible(true);
            this.fTableCursor.setSelection(row, colNum);
            this.handleCursorMoved();
            this.fTableCursor.setFocus();
        }
    }

    private void columnSizeChanged(int newColumnSize) {
        if (!this.isVisible()) {
            return;
        }
        Display.getDefault().asyncExec(() -> {
            boolean bl = this.format(this.getBytesPerLine(), newColumnSize);
        });
    }

    private void rowSizeChanged(int newRowSize) {
        if (!this.isVisible()) {
            return;
        }
        int bytesPerLine = newRowSize;
        int col = this.getBytesPerColumn();
        if (bytesPerLine < this.getBytesPerColumn()) {
            col = bytesPerLine;
        }
        int columnSize = col;
        int rowSize = bytesPerLine;
        Display.getDefault().asyncExec(() -> {
            boolean bl = this.format(rowSize, columnSize);
        });
    }

    private void handleCursorMouseEvent(MouseEvent e) {
        int col;
        if (e.button == 1 && (col = this.fTableCursor.getColumn()) > 0 && col <= this.getNumCol()) {
            this.activateCellEditor(null);
        }
    }

    private void activateCellEditor(String initialValue) {
        int col = this.fTableCursor.getColumn();
        int row = this.findAddressIndex(this.fSelectedAddress);
        if (row < 0) {
            return;
        }
        if (col == 0 || col > this.getNumCol()) {
            return;
        }
        ICellModifier cellModifier = null;
        if (this.fTableViewer == null) {
            return;
        }
        cellModifier = this.fTableViewer.getCellModifier();
        TableItem tableItem = this.fTableViewer.getTable().getItem(row);
        Object element = tableItem.getData();
        Object property = this.fTableViewer.getColumnProperties()[col];
        Object value = cellModifier.getValue(element, (String)property);
        ((TableRenderingCellModifier)cellModifier).setEditActionInvoked(true);
        boolean canEdit = cellModifier.canModify(element, (String)property);
        ((TableRenderingCellModifier)cellModifier).setEditActionInvoked(false);
        if (!canEdit) {
            return;
        }
        TextCellEditor selectedEditor = (TextCellEditor)this.fTableViewer.getCellEditors()[col];
        if (this.fTableViewer != null && selectedEditor != null) {
            Text text = (Text)selectedEditor.getControl();
            String cellValue = null;
            cellValue = initialValue != null ? initialValue : (String)value;
            text.setText(cellValue);
            this.fCursorEditor.horizontalAlignment = 16384;
            this.fCursorEditor.grabHorizontal = true;
            this.fCursorEditor.setEditor((Control)text, tableItem, col);
            selectedEditor.setFocus();
            if (initialValue != null) {
                text.clearSelection();
            }
            text.setFont(JFaceResources.getFont((String)"org.eclipse.debug.ui.MemoryViewTableFont"));
            this.addListeners(text);
            this.fTableCursor.moveBelow((Control)text);
        }
    }

    private void addListeners(Text text) {
        this.fEditorFocusListener = new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                AbstractTableRendering.this.handleTableEditorFocusLost(e);
            }
        };
        text.addFocusListener((FocusListener)this.fEditorFocusListener);
        this.fEditorKeyListener = new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                AbstractTableRendering.this.handleKeyEventInEditor(e);
            }
        };
        text.addKeyListener((KeyListener)this.fEditorKeyListener);
    }

    private void removeListeners(Text text) {
        text.removeFocusListener((FocusListener)this.fEditorFocusListener);
        text.removeKeyListener((KeyListener)this.fEditorKeyListener);
    }

    private void handleTableEditorFocusLost(FocusEvent event) {
        FocusEvent e = event;
        Display.getDefault().syncExec(() -> {
            try {
                int row = this.findAddressIndex(this.fSelectedAddress);
                int col = this.fTableCursor.getColumn();
                Text text = (Text)e.getSource();
                this.removeListeners(text);
                String newValue = text.getText();
                this.modifyValue(row, col, newValue);
                this.setCursorAtAddress(this.fSelectedAddress);
                this.fTableCursor.moveAbove((Control)text);
                this.fTableCursor.setVisible(false);
                this.fTableCursor.setVisible(true);
            }
            catch (NumberFormatException numberFormatException) {
                MemoryViewUtil.openError(DebugUIMessages.MemoryViewCellModifier_failure_title, DebugUIMessages.MemoryViewCellModifier_data_is_invalid, null);
            }
        });
    }

    private void handleKeyEventInEditor(KeyEvent event) {
        KeyEvent e = event;
        Display.getDefault().asyncExec(() -> {
            Text text = (Text)e.getSource();
            int row = this.findAddressIndex(this.fSelectedAddress);
            int col = this.fTableCursor.getColumn();
            try {
                switch (keyEvent.keyCode) {
                    case 0x1000001: {
                        if (row - 1 < 0) {
                            return;
                        }
                        this.modifyValue(row, col, text.getText());
                        this.fTableCursor.setSelection(--row, col);
                        this.handleCursorMoved();
                        this.removeListeners(text);
                        this.activateCellEditor(null);
                        break;
                    }
                    case 0x1000002: {
                        if (row + 1 >= this.fTableViewer.getTable().getItemCount()) {
                            return;
                        }
                        this.modifyValue(row, col, text.getText());
                        this.fTableCursor.setSelection(++row, col);
                        this.handleCursorMoved();
                        this.removeListeners(text);
                        this.activateCellEditor(null);
                        break;
                    }
                    case 0: {
                        int numCharsPerByte = this.getNumCharsPerByte();
                        if (numCharsPerByte > 0 && text.getText().length() > this.getBytesPerColumn() * numCharsPerByte) {
                            String newValue1 = text.getText();
                            text.setText(newValue1.substring(0, this.getBytesPerColumn() * numCharsPerByte));
                            this.modifyValue(row, col, text.getText());
                            if (col >= this.getNumCol()) {
                                col = 1;
                                ++row;
                            } else {
                                ++row;
                            }
                            this.fTableCursor.setSelection(row, col);
                            this.handleCursorMoved();
                            this.removeListeners(text);
                            this.activateCellEditor(newValue1.substring(this.getBytesPerColumn() * numCharsPerByte));
                        }
                        break;
                    }
                    case 27: {
                        this.fTableCursor.setSelection(row, col);
                        this.handleCursorMoved();
                        this.removeListeners(text);
                        this.fTableCursor.setFocus();
                        break;
                    }
                    default: {
                        int numCharsPerByte = this.getNumCharsPerByte();
                        if (numCharsPerByte > 0 && text.getText().length() > this.getBytesPerColumn() * numCharsPerByte) {
                            String newValue2 = text.getText();
                            text.setText(newValue2.substring(0, this.getBytesPerColumn() * numCharsPerByte));
                            this.modifyValue(row, col, text.getText());
                            if (col >= this.getNumCol()) {
                                col = 1;
                                ++row;
                            } else {
                                ++col;
                            }
                            this.fTableCursor.setSelection(row, col);
                            this.handleCursorMoved();
                            this.removeListeners(text);
                            this.activateCellEditor(newValue2.substring(this.getBytesPerColumn() * numCharsPerByte));
                        }
                        break;
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {
                MemoryViewUtil.openError(DebugUIMessages.MemoryViewCellModifier_failure_title, DebugUIMessages.MemoryViewCellModifier_data_is_invalid, null);
                this.fTableCursor.setSelection(row, col);
                this.handleCursorMoved();
                this.removeListeners(text);
            }
        });
    }

    private void modifyValue(int row, int col, String newValue) throws NumberFormatException {
        if (newValue.length() == 0) {
            return;
        }
        TableItem tableItem = this.fTableViewer.getTable().getItem(row);
        Object property = this.fTableViewer.getColumnProperties()[col];
        this.fTableViewer.getCellModifier().modify((Object)tableItem, (String)property, (Object)newValue);
    }

    @Override
    public void becomesHidden() {
        if (!this.isVisible()) {
            super.becomesHidden();
            return;
        }
        super.becomesHidden();
        if (this.getMemoryBlock() instanceof IMemoryBlockExtension) {
            this.updateRenderingLabel(false);
        }
        this.fContentProvider.resetDeltas();
    }

    @Override
    public void becomesVisible() {
        if (this.isVisible()) {
            super.becomesVisible();
            return;
        }
        super.becomesVisible();
        boolean value = DebugUIPlugin.getDefault().getPreferenceStore().getBoolean("org.eclpise.debug.ui.memory.dynamicLoad");
        if (value != this.isDynamicLoad()) {
            this.handleDyanicLoadChanged();
        } else {
            this.refresh();
        }
        this.synchronize();
        this.updateRenderingLabel(true);
    }

    @Deprecated
    public void reset() {
        try {
            this.resetToBaseAddress();
        }
        catch (DebugException e) {
            MemoryViewUtil.openError(DebugUIMessages.AbstractTableRendering_12, DebugUIMessages.AbstractTableRendering_13, (Exception)((Object)e));
        }
    }

    private void resetToBaseAddress() throws DebugException {
        BigInteger baseAddress = this.getMemoryBlock() instanceof IMemoryBlockExtension ? ((IMemoryBlockExtension)this.getMemoryBlock()).getBigBaseAddress() : BigInteger.valueOf(this.getMemoryBlock().getStartAddress());
        this.goToAddress(baseAddress);
        this.topVisibleAddressChanged(baseAddress, true);
    }

    @Override
    public BigInteger getSelectedAddress() {
        return this.fSelectedAddress;
    }

    @Override
    public String getSelectedAsString() {
        if (this.isAddressOutOfRange(this.fSelectedAddress)) {
            return "";
        }
        int col = this.fTableCursor.getColumn();
        TableItem rowItem = this.fTableCursor.getRow();
        int row = this.fTableViewer.getTable().indexOf(rowItem);
        if (col == 0) {
            return rowItem.getText(0);
        }
        if (col > this.getBytesPerLine() / this.getBytesPerColumn()) {
            return "";
        }
        TableItem tableItem = this.getTableViewer().getTable().getItem(row);
        return tableItem.getText(col);
    }

    @Override
    public MemoryByte[] getSelectedAsBytes() {
        if (this.isAddressOutOfRange(this.fSelectedAddress)) {
            return new MemoryByte[0];
        }
        int col = this.fTableCursor.getColumn();
        TableItem rowItem = this.fTableCursor.getRow();
        if (col == 0 || col > this.getBytesPerLine() / this.getBytesPerColumn()) {
            return new MemoryByte[0];
        }
        Object data = rowItem.getData();
        if (data == null || !(data instanceof TableRenderingLine)) {
            return new MemoryByte[0];
        }
        TableRenderingLine line = (TableRenderingLine)((Object)data);
        int offset = (col - 1) * (this.getAddressableUnitPerColumn() * this.getAddressableSize());
        int end = offset + this.getAddressableUnitPerColumn() * this.getAddressableSize();
        MemoryByte[] bytes = line.getBytes(offset, end);
        MemoryByte[] retBytes = new MemoryByte[bytes.length];
        System.arraycopy(bytes, 0, retBytes, 0, bytes.length);
        return retBytes;
    }

    @Override
    public int getNumCharsPerByte() {
        return -1;
    }

    private int getMinTableItemHeight(Table table) {
        if (MemoryViewUtil.isLinuxGTK()) {
            TableItem[] items = table.getItems();
            int minHeight = table.getItemHeight();
            TableItem[] tableItemArray = items;
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                TableItem item = tableItemArray[n2];
                minHeight = Math.min(item.getBounds((int)0).height, minHeight);
                ++n2;
            }
            return minHeight;
        }
        return table.getItemHeight();
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == IColorProvider.class) {
            return (T)this.getColorProviderAdapter();
        }
        if (adapter == ILabelProvider.class) {
            return (T)this.getLabelProviderAdapter();
        }
        if (adapter == IFontProvider.class) {
            return (T)this.getFontProviderAdapter();
        }
        if (adapter == IMemoryBlockTablePresentation.class) {
            return (T)this.getTablePresentationAdapter();
        }
        if (adapter == IWorkbenchAdapter.class) {
            if (this.fWorkbenchAdapter == null) {
                this.fWorkbenchAdapter = new IWorkbenchAdapter(){

                    public Object[] getChildren(Object o) {
                        return new Object[0];
                    }

                    public ImageDescriptor getImageDescriptor(Object object) {
                        return null;
                    }

                    public String getLabel(Object o) {
                        return AbstractTableRendering.this.getLabel();
                    }

                    public Object getParent(Object o) {
                        return null;
                    }
                };
            }
            return (T)this.fWorkbenchAdapter;
        }
        if (adapter == IMemoryBlockConnection.class) {
            if (this.fConnection == null) {
                this.fConnection = () -> {
                    try {
                        this.fContentProvider.takeContentSnapshot();
                        if (this.getMemoryBlock() instanceof IMemoryBlockExtension) {
                            BigInteger address = ((IMemoryBlockExtension)this.getMemoryBlock()).getBigBaseAddress();
                            if (address.compareTo(this.fContentProvider.getContentBaseAddress()) != 0) {
                                this.setSelectedAddress(address);
                                this.updateSyncSelectedAddress();
                                this.fTopRowAddress = address;
                                this.fContentInput.updateContentBaseAddress();
                                this.fContentInput.setLoadAddress(address);
                            }
                            this.fContentProvider.loadContentForExtendedMemoryBlock();
                        } else {
                            this.fContentProvider.loadContentForSimpleMemoryBlock();
                        }
                        Display display = PlatformUI.getWorkbench().getDisplay();
                        display.asyncExec(() -> {
                            int topIdx;
                            this.updateLabels();
                            if (this.getMemoryBlock() instanceof IMemoryBlockExtension && (topIdx = this.findAddressIndex(this.fTopRowAddress)) != -1) {
                                AbstractTableRendering.setTopIndex(this.fTableViewer.getTable(), topIdx);
                            }
                            if (this.isAddressVisible(this.fSelectedAddress)) {
                                this.setCursorAtAddress(this.fSelectedAddress);
                                this.fTableCursor.setVisible(true);
                                this.fTableCursor.redraw();
                            } else {
                                this.fTableCursor.setVisible(false);
                            }
                            if (!this.isDynamicLoad()) {
                                this.updateSyncPageStartAddress();
                            }
                            this.updateSyncTopAddress();
                        });
                    }
                    catch (DebugException e) {
                        this.displayError(e);
                    }
                };
            }
            return (T)this.fConnection;
        }
        return (T)super.getAdapter(adapter);
    }

    private boolean hasCustomizedDecorations() {
        return this.getFontProviderAdapter() != null || this.getColorProviderAdapter() != null || this.getLabelProviderAdapter() != null;
    }

    private boolean isBaseAddressChanged() {
        try {
            BigInteger baseAddress;
            IMemoryBlock mb = this.getMemoryBlock();
            return mb instanceof IMemoryBlockExtension && (baseAddress = ((IMemoryBlockExtension)mb).getBigBaseAddress()) != null && !baseAddress.equals(this.fContentInput.getContentBaseAddress());
        }
        catch (DebugException debugException) {
            return false;
        }
    }

    protected IColorProvider getColorProviderAdapter() {
        return (IColorProvider)this.getMemoryBlock().getAdapter(IColorProvider.class);
    }

    protected ILabelProvider getLabelProviderAdapter() {
        return (ILabelProvider)this.getMemoryBlock().getAdapter(ILabelProvider.class);
    }

    protected IFontProvider getFontProviderAdapter() {
        return (IFontProvider)this.getMemoryBlock().getAdapter(IFontProvider.class);
    }

    protected IMemoryBlockTablePresentation getTablePresentationAdapter() {
        return (IMemoryBlockTablePresentation)this.getMemoryBlock().getAdapter(IMemoryBlockTablePresentation.class);
    }

    private boolean isDynamicLoad() {
        return this.fContentProvider.isDynamicLoad();
    }

    private int getPageSizeInUnits() {
        return this.fPageSize * this.getAddressableUnitPerLine();
    }

    private void setSelectedAddress(BigInteger address) {
        this.fSelectedAddress = address;
    }

    private void createToolTip() {
        this.fToolTipShell = new Shell(DebugUIPlugin.getShell(), 16400);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.marginWidth = 2;
        gridLayout.marginHeight = 0;
        this.fToolTipShell.setLayout((Layout)gridLayout);
        this.fToolTipShell.setBackground(this.fTableViewer.getTable().getDisplay().getSystemColor(29));
        final Control toolTipControl = this.createToolTipControl((Composite)this.fToolTipShell);
        if (toolTipControl == null) {
            this.fToolTipShell.dispose();
            return;
        }
        MouseTrackAdapter listener = new MouseTrackAdapter(){
            private TableItem fTooltipItem = null;
            private int fCol = -1;

            public void mouseExit(MouseEvent e) {
                if (!AbstractTableRendering.this.fToolTipShell.isDisposed()) {
                    AbstractTableRendering.this.fToolTipShell.setVisible(false);
                }
                this.fTooltipItem = null;
            }

            public void mouseHover(MouseEvent e) {
                Point hoverPoint = new Point(e.x, e.y);
                Control control = null;
                if (e.widget instanceof Control) {
                    control = (Control)e.widget;
                }
                if (control == null) {
                    return;
                }
                hoverPoint = control.toDisplay(hoverPoint);
                TableItem item = AbstractTableRendering.this.getItem(hoverPoint);
                int column = AbstractTableRendering.this.getColumn(hoverPoint);
                if (this.fTooltipItem != item || this.fCol != column) {
                    this.fTooltipItem = item;
                    this.fCol = column;
                    if (item != null) {
                        AbstractTableRendering.this.toolTipAboutToShow(toolTipControl, this.fTooltipItem, column);
                        Rectangle shellBounds = AbstractTableRendering.this.fToolTipShell.getBounds();
                        shellBounds.x = hoverPoint.x;
                        shellBounds.y = hoverPoint.y + item.getBounds((int)0).height;
                        AbstractTableRendering.this.fToolTipShell.setBounds(shellBounds);
                        AbstractTableRendering.this.fToolTipShell.pack();
                        AbstractTableRendering.this.fToolTipShell.setVisible(true);
                    } else {
                        AbstractTableRendering.this.fToolTipShell.setVisible(false);
                    }
                }
            }
        };
        this.fTableViewer.getTable().addMouseTrackListener((MouseTrackListener)listener);
        this.fTableCursor.addMouseTrackListener((MouseTrackListener)listener);
    }

    private TableItem getItem(Point point) {
        TableItem[] items;
        TableItem[] tableItemArray = items = this.fTableViewer.getTable().getItems();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            Point start = new Point(item.getBounds((int)0).x, item.getBounds((int)0).y);
            start = this.fTableViewer.getTable().toDisplay(start);
            Point end = new Point(start.x + item.getBounds((int)0).width, start.y + item.getBounds((int)0).height);
            if (start.y < point.y && point.y < end.y) {
                return item;
            }
            ++n2;
        }
        return null;
    }

    private int getColumn(Point point) {
        int colCnt = this.fTableViewer.getTable().getColumnCount();
        if (this.fTableViewer.getTable().getItemCount() > 0) {
            TableItem item = this.fTableViewer.getTable().getItem(0);
            int i = 0;
            while (i < colCnt) {
                Point start = new Point(item.getBounds((int)i).x, item.getBounds((int)i).y);
                start = this.fTableViewer.getTable().toDisplay(start);
                Point end = new Point(start.x + item.getBounds((int)i).width, start.y + item.getBounds((int)i).height);
                if (start.x < point.x && end.x > point.x) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    protected Control createToolTipControl(Composite composite) {
        Label fToolTipLabel = new Label(composite, 0);
        fToolTipLabel.setForeground(this.fTableViewer.getTable().getDisplay().getSystemColor(28));
        fToolTipLabel.setBackground(this.fTableViewer.getTable().getDisplay().getSystemColor(29));
        fToolTipLabel.setLayoutData((Object)new GridData(772));
        return fToolTipLabel;
    }

    @Override
    public void resetRendering() throws DebugException {
        this.resetToBaseAddress();
    }

    protected void toolTipAboutToShow(Control toolTipControl, TableItem item, int col) {
        Object data;
        BigInteger address;
        if (toolTipControl instanceof Label && (address = this.getAddressFromTableItem(item, col)) != null && (data = item.getData()) instanceof TableRenderingLine) {
            TableRenderingLine line = (TableRenderingLine)((Object)data);
            if (col > 0) {
                int end;
                int start = (col - 1) * this.getBytesPerColumn();
                MemoryByte[] bytes = line.getBytes(start, end = start + this.getBytesPerColumn());
                String str = this.getToolTipText(address, bytes);
                if (str != null) {
                    ((Label)toolTipControl).setText(str);
                }
            } else {
                String str = this.getToolTipText(address, new MemoryByte[0]);
                if (str != null) {
                    ((Label)toolTipControl).setText(str);
                }
            }
        }
    }

    protected String getToolTipText(BigInteger address, MemoryByte[] bytes) {
        StringBuilder buf = new StringBuilder("0x");
        buf.append(address.toString(16).toUpperCase());
        return buf.toString();
    }

    private String getRowPrefId(String modelId) {
        String rowPrefId = "org.eclipse.debug.ui.memory.rowSize:" + modelId;
        return rowPrefId;
    }

    private String getColumnPrefId(String modelId) {
        String colPrefId = "org.eclipse.debug.ui.memory.columnSize:" + modelId;
        return colPrefId;
    }

    private int getDefaultRowSizeByModel(String modelId) {
        int row = DebugUITools.getPreferenceStore().getInt(this.getRowPrefId(modelId));
        if (row == 0) {
            DebugUITools.getPreferenceStore().setValue(this.getRowPrefId(modelId), 16);
        }
        row = DebugUITools.getPreferenceStore().getInt(this.getRowPrefId(modelId));
        return row;
    }

    private int getDefaultColumnSizeByModel(String modelId) {
        int col = DebugUITools.getPreferenceStore().getInt(this.getColumnPrefId(modelId));
        if (col == 0) {
            DebugUITools.getPreferenceStore().setValue(this.getColumnPrefId(modelId), 4);
        }
        col = DebugUITools.getPreferenceStore().getInt(this.getColumnPrefId(modelId));
        return col;
    }

    private int getBufferThreshold(int startOrEnd) {
        if (startOrEnd == 0) {
            if (1 > this.fPreBuffer) {
                return this.fPreBuffer;
            }
            return 1;
        }
        if (1 > this.fPostBuffer) {
            return this.fPostBuffer;
        }
        return 1;
    }

    @Override
    public abstract String getString(String var1, BigInteger var2, MemoryByte[] var3);

    @Override
    public abstract byte[] getBytes(String var1, BigInteger var2, MemoryByte[] var3, String var4);

    private class EventHandleLock {
        Object fOwner;

        private EventHandleLock() {
        }

        public boolean acquireLock(Object client) {
            if (this.fOwner == null) {
                this.fOwner = client;
                return true;
            }
            return false;
        }

        public boolean releaseLock(Object client) {
            if (this.fOwner == client) {
                this.fOwner = null;
                return true;
            }
            return false;
        }
    }

    private class NextPageAction
    extends Action {
        private NextPageAction() {
            this.setText(DebugUIMessages.AbstractTableRendering_4);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.debug.ui.NextPageAction_context");
        }

        public void run() {
            BigInteger address = AbstractTableRendering.this.fContentInput.getLoadAddress();
            address = address.add(BigInteger.valueOf(AbstractTableRendering.this.getPageSizeInUnits()));
            AbstractTableRendering.this.handlePageStartAddressChanged(address);
        }
    }

    private class PrevPageAction
    extends Action {
        private PrevPageAction() {
            this.setText(DebugUIMessages.AbstractTableRendering_6);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.debug.ui.PrevPageAction_context");
        }

        public void run() {
            BigInteger address = AbstractTableRendering.this.fContentInput.getLoadAddress();
            address = address.subtract(BigInteger.valueOf(AbstractTableRendering.this.getPageSizeInUnits()));
            AbstractTableRendering.this.handlePageStartAddressChanged(address);
        }
    }

    private class ToggleAddressColumnAction
    extends Action {
        public ToggleAddressColumnAction() {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.debug.ui.ShowAddressColumnAction_context");
            this.updateActionLabel();
        }

        public void run() {
            AbstractTableRendering.this.fIsShowAddressColumn = !AbstractTableRendering.this.fIsShowAddressColumn;
            AbstractTableRendering.this.resizeColumnsToPreferredSize();
            this.updateActionLabel();
        }

        private void updateActionLabel() {
            if (AbstractTableRendering.this.fIsShowAddressColumn) {
                this.setText(DebugUIMessages.ShowAddressColumnAction_0);
            } else {
                this.setText(DebugUIMessages.ShowAddressColumnAction_1);
            }
        }
    }
}

