/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.css.swt.properties.custom;

import java.lang.reflect.Constructor;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.Platform;
import org.eclipse.e4.ui.css.core.engine.CSSEngine;
import org.eclipse.e4.ui.css.swt.helpers.URI;
import org.eclipse.e4.ui.css.swt.properties.AbstractCSSPropertySWTHandler;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabFolderRenderer;
import org.eclipse.swt.widgets.Control;
import org.osgi.framework.Bundle;
import org.w3c.dom.css.CSSPrimitiveValue;
import org.w3c.dom.css.CSSValue;

public class CSSPropertyTabRendererSWTHandler
extends AbstractCSSPropertySWTHandler {
    @Override
    protected void applyCSSProperty(Control control, String property, CSSValue value, String pseudo, CSSEngine engine) throws Exception {
        if (!(control instanceof CTabFolder)) {
            return;
        }
        if (value.getCssValueType() == 1) {
            if (((CSSPrimitiveValue)value).getPrimitiveType() == 20) {
                String rendURL = ((CSSPrimitiveValue)value).getStringValue();
                URI uri = URI.createURI(rendURL);
                Bundle bundle = Platform.getBundle((String)uri.authority());
                if (bundle == null) {
                    ILog.of(this.getClass()).error("Failed to get bundle for: " + rendURL);
                } else if (uri.segmentCount() <= 1) {
                    String clazz = uri.segment(0);
                    try {
                        Object rend;
                        Class targetClass = bundle.loadClass(clazz);
                        CTabFolderRenderer renderer = ((CTabFolder)control).getRenderer();
                        if (renderer != null && renderer.getClass() == targetClass) {
                            return;
                        }
                        Constructor constructor = targetClass.getConstructor(CTabFolder.class);
                        if (constructor != null && (rend = constructor.newInstance(control)) != null && rend instanceof CTabFolderRenderer) {
                            ((CTabFolder)control).setRenderer((CTabFolderRenderer)rend);
                        }
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        String message = "Unable to load class '" + clazz + "' from bundle '" + bundle.getBundleId() + "'";
                        ILog.of(this.getClass()).error(message);
                    }
                }
            } else {
                ((CTabFolder)control).setRenderer(null);
            }
        }
    }

    @Override
    protected String retrieveCSSProperty(Control control, String property, String pseudo, CSSEngine engine) throws Exception {
        return null;
    }
}

