/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.decorators;

import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.egit.core.internal.CompareCoreUtils;
import org.eclipse.egit.core.internal.util.ResourceUtil;
import org.eclipse.egit.core.project.RepositoryMapping;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.decorators.GitQuickDiffProvider;
import org.eclipse.egit.ui.internal.trace.GitTraceLocation;
import org.eclipse.jface.text.Document;
import org.eclipse.jgit.diff.DiffConfig;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.diff.RenameDetector;
import org.eclipse.jgit.dircache.DirCacheIterator;
import org.eclipse.jgit.events.ListenerHandle;
import org.eclipse.jgit.events.RefsChangedEvent;
import org.eclipse.jgit.events.RefsChangedListener;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.CanonicalTreeParser;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.util.LfsFactory;
import org.eclipse.osgi.util.NLS;

class GitDocument
extends Document
implements RefsChangedListener {
    private final IResource resource;
    private ObjectId lastCommit;
    private ObjectId lastTree;
    private ObjectId lastBlob;
    private ListenerHandle myRefsChangedHandle;
    private Job reloadJob;
    private boolean disposed;
    static Map<GitDocument, Repository> doc2repo = new WeakHashMap<GitDocument, Repository>();

    static GitDocument create(IResource resource) throws IOException {
        if (GitTraceLocation.QUICKDIFF.isActive()) {
            GitTraceLocation.getTrace().trace(GitTraceLocation.QUICKDIFF.getLocation(), "(GitDocument) create: " + resource);
        }
        GitDocument ret = null;
        if (ResourceUtil.isSharedWithGit((IResource)resource.getProject())) {
            ret = new GitDocument(resource);
            ret.populate();
            Repository repository = ret.getRepository();
            if (repository != null) {
                ret.myRefsChangedHandle = repository.getListenerList().addRefsChangedListener((RefsChangedListener)ret);
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GitDocument(IResource resource) {
        this.resource = resource;
        Map<GitDocument, Repository> map = doc2repo;
        synchronized (map) {
            doc2repo.put(this, this.getRepository());
        }
    }

    private void setResolved(AnyObjectId commit, AnyObjectId tree, AnyObjectId blob, String value) {
        this.lastCommit = commit != null ? commit.copy() : null;
        this.lastTree = tree != null ? tree.copy() : null;
        this.lastBlob = blob != null ? blob.copy() : null;
        this.set(value);
        if (blob != null) {
            if (GitTraceLocation.QUICKDIFF.isActive()) {
                GitTraceLocation.getTrace().trace(GitTraceLocation.QUICKDIFF.getLocation(), "(GitDocument) resolved " + this.resource + " to " + this.lastBlob + " in " + this.lastCommit + "/" + this.lastTree);
            } else if (GitTraceLocation.QUICKDIFF.isActive()) {
                GitTraceLocation.getTrace().trace(GitTraceLocation.QUICKDIFF.getLocation(), "(GitDocument) unresolved " + this.resource);
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void populate() throws IOException {
        block48: {
            block49: {
                block45: {
                    if (GitTraceLocation.QUICKDIFF.isActive()) {
                        GitTraceLocation.getTrace().traceEntry(GitTraceLocation.QUICKDIFF.getLocation(), (Object)this.resource);
                    }
                    if (this.disposed) {
                        return;
                    }
                    mapping = RepositoryMapping.getMapping((IResource)this.resource);
                    if (mapping == null) {
                        this.setResolved(null, null, null, "");
                        return;
                    }
                    gitPath = mapping.getRepoRelativePath(this.resource);
                    if (gitPath == null) {
                        this.setResolved(null, null, null, "");
                        return;
                    }
                    repository = mapping.getRepository();
                    baseline = GitQuickDiffProvider.baseline.get(repository);
                    if (baseline == null) {
                        baseline = "HEAD";
                    }
                    if ((commitId = repository.resolve(baseline)) != null) {
                        if (commitId.equals((AnyObjectId)this.lastCommit)) {
                            if (GitTraceLocation.QUICKDIFF.isActive() == false) return;
                            GitTraceLocation.getTrace().trace(GitTraceLocation.QUICKDIFF.getLocation(), "(GitDocument) already resolved");
                            return;
                        }
                    } else {
                        if (repository.exactRef("HEAD") == null) {
                            msg = NLS.bind((String)UIText.GitDocument_errorResolveQuickdiff, (Object[])new Object[]{baseline, this.resource, repository});
                            Activator.logError(msg, new Throwable());
                        }
                        this.setResolved(null, null, null, "");
                        return;
                    }
                    oldPath = gitPath;
                    try {
                        var8_9 = null;
                        var9_12 = null;
                        try {
                            rw = new RevWalk(repository);
                            try {
                                block44: {
                                    reader = repository.newObjectReader();
                                    try {
                                        baselineCommit = rw.parseCommit((AnyObjectId)commitId);
                                        diffConfig = (DiffConfig)repository.getConfig().get(DiffConfig.KEY);
                                        if (diffConfig.getRenameDetectionType() == DiffConfig.RenameDetectionType.FALSE) break block44;
                                        walk = new TreeWalk(repository);
                                        baseLineIterator = new CanonicalTreeParser();
                                        baseLineIterator.reset(reader, (AnyObjectId)baselineCommit.getTree());
                                        walk.addTree((AbstractTreeIterator)baseLineIterator);
                                        walk.addTree((AbstractTreeIterator)new DirCacheIterator(repository.readDirCache()));
                                        diffs = DiffEntry.scan((TreeWalk)walk, (boolean)true);
                                        renameDetector = new RenameDetector(repository);
                                        renameDetector.addAll((Collection)diffs);
                                        renames = renameDetector.compute();
                                        for (DiffEntry e : renames) {
                                            if (!e.getNewPath().equals(gitPath)) continue;
                                            oldPath = e.getOldPath();
                                            break;
                                        }
                                    }
                                    finally {
                                        if (reader != null) {
                                            reader.close();
                                        }
                                    }
                                }
                                if (rw == null) break block45;
                            }
                            catch (Throwable var9_13) {
                                if (var8_9 == null) {
                                    var8_9 = var9_13;
                                } else if (var8_9 != var9_13) {
                                    var8_9.addSuppressed(var9_13);
                                }
                                if (rw == null) throw var8_9;
                                rw.close();
                                throw var8_9;
                            }
                            rw.close();
                        }
                        catch (Throwable var9_14) {
                            if (var8_9 == null) {
                                var8_9 = var9_14;
                                throw var8_9;
                            }
                            if (var8_9 == var9_14) throw var8_9;
                            var8_9.addSuppressed(var9_14);
                            throw var8_9;
                        }
                    }
                    catch (IOException err) {
                        msg = NLS.bind((String)UIText.GitDocument_errorLoadCommit, (Object[])new Object[]{commitId, baseline, this.resource, repository});
                        Activator.logError(msg, err);
                        this.setResolved(null, null, null, "");
                        return;
                    }
                }
                treeId = baselineCommit.getTree();
                if (treeId.equals((AnyObjectId)this.lastTree)) {
                    if (GitTraceLocation.QUICKDIFF.isActive() == false) return;
                    GitTraceLocation.getTrace().trace(GitTraceLocation.QUICKDIFF.getLocation(), "(GitDocument) already resolved");
                    return;
                }
                var9_12 = null;
                var10_17 = null;
                try {
                    block46: {
                        tw = TreeWalk.forPath((Repository)repository, (String)oldPath, (RevTree)treeId);
                        if (tw == null) {
                            if (GitTraceLocation.QUICKDIFF.isActive()) {
                                GitTraceLocation.getTrace().trace(GitTraceLocation.QUICKDIFF.getLocation(), "(GitDocument) resource " + this.resource + " not found in " + treeId + " in " + repository + ", baseline=" + baseline);
                            }
                            this.setResolved(null, null, null, "");
                            if (tw == null) break block46;
                        }
                        ** GOTO lbl-1000
                        tw.close();
                    }
                    if (GitTraceLocation.QUICKDIFF.isActive() == false) return;
                }
                catch (Throwable var10_18) {
                    if (var9_12 == null) {
                        var9_12 = var10_18;
                        throw var9_12;
                    }
                    if (var9_12 == var10_18) throw var9_12;
                    var9_12.addSuppressed(var10_18);
                    throw var9_12;
                }
                GitTraceLocation.getTrace().traceExit(GitTraceLocation.QUICKDIFF.getLocation());
                return;
lbl-1000:
                // 1 sources

                {
                    id = tw.getObjectId(0);
                    if (!id.equals((AnyObjectId)ObjectId.zeroId())) break block48;
                    this.setResolved(null, null, null, "");
                    msg = NLS.bind((String)UIText.GitDocument_errorLoadTree, (Object[])new Object[]{treeId.getName(), baseline, this.resource, repository});
                    Activator.logError(msg, new Throwable());
                    this.setResolved(null, null, null, "");
                    if (tw == null) break block49;
                }
                tw.close();
            }
            if (GitTraceLocation.QUICKDIFF.isActive() == false) return;
            GitTraceLocation.getTrace().traceExit(GitTraceLocation.QUICKDIFF.getLocation());
            return;
        }
        ** try [egrp 11[TRYBLOCK] [6 : 889->1088)] { 
lbl137:
        // 1 sources

        if (!id.equals((AnyObjectId)this.lastBlob)) {
            if (GitTraceLocation.QUICKDIFF.isActive()) {
                GitTraceLocation.getTrace().trace(GitTraceLocation.QUICKDIFF.getLocation(), "(GitDocument) compareTo: " + baseline);
            }
            loader = LfsFactory.getInstance().applySmudgeFilter(repository, repository.open((AnyObjectId)id, 3), tw.getAttributes().get("diff"));
            bytes = loader.getBytes();
            charset = CompareCoreUtils.getResourceEncoding((IResource)this.resource);
            s = new String(bytes, charset);
            this.setResolved((AnyObjectId)commitId, (AnyObjectId)treeId, (AnyObjectId)id, s);
            if (GitTraceLocation.QUICKDIFF.isActive() == false) return;
            GitTraceLocation.getTrace().trace(GitTraceLocation.QUICKDIFF.getLocation(), "(GitDocument) has reference doc, size=" + s.length() + " bytes");
            return;
        }
        if (GitTraceLocation.QUICKDIFF.isActive() == false) return;
        GitTraceLocation.getTrace().trace(GitTraceLocation.QUICKDIFF.getLocation(), "(GitDocument) already resolved");
        return;
lbl151:
        // 1 sources

        finally {
            if (tw != null) {
                tw.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dispose() {
        if (GitTraceLocation.QUICKDIFF.isActive()) {
            GitTraceLocation.getTrace().trace(GitTraceLocation.QUICKDIFF.getLocation(), "(GitDocument) dispose: " + this.resource);
        }
        Map<GitDocument, Repository> map = doc2repo;
        synchronized (map) {
            doc2repo.remove((Object)this);
        }
        if (this.myRefsChangedHandle != null) {
            this.myRefsChangedHandle.remove();
            this.myRefsChangedHandle = null;
        }
        this.cancelReloadJob();
        this.disposed = true;
    }

    public void onRefsChanged(RefsChangedEvent event) {
        this.cancelReloadJob();
        this.reloadJob = new Job(UIText.GitDocument_ReloadJobName){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    GitDocument.this.populate();
                    return Status.OK_STATUS;
                }
                catch (IOException e) {
                    return Activator.createErrorStatus(UIText.GitDocument_ReloadJobError, e);
                }
            }
        };
        this.reloadJob.schedule();
    }

    private void cancelReloadJob() {
        if (this.reloadJob != null && this.reloadJob.getState() != 0) {
            this.reloadJob.cancel();
        }
    }

    private Repository getRepository() {
        RepositoryMapping mapping = RepositoryMapping.getMapping((IResource)this.resource);
        return mapping != null ? mapping.getRepository() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void refreshRelevant(Repository repository) throws IOException {
        Map.Entry[] docs;
        Map<GitDocument, Repository> map = doc2repo;
        synchronized (map) {
            docs = doc2repo.entrySet().toArray(new Map.Entry[0]);
        }
        Map.Entry[] entryArray = docs;
        int n = docs.length;
        int n2 = 0;
        while (n2 < n) {
            Map.Entry doc = entryArray[n2];
            if (doc.getValue() == repository) {
                ((GitDocument)((Object)doc.getKey())).populate();
            }
            ++n2;
        }
    }
}

