/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.net4j;

import java.net.URI;
import java.util.Map;
import org.eclipse.emf.cdo.net4j.CDONet4jSessionConfiguration;
import org.eclipse.emf.cdo.net4j.CDONet4jUtil;
import org.eclipse.emf.cdo.session.CDOSession;
import org.eclipse.emf.internal.cdo.session.CDOSessionFactory;
import org.eclipse.emf.spi.cdo.InternalCDOSession;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.container.IManagedContainerFactory;
import org.eclipse.net4j.util.container.IPluginContainer;
import org.eclipse.net4j.util.security.IPasswordCredentialsProvider;

public class Net4jSessionFactory
extends CDOSessionFactory
implements IManagedContainerFactory {
    public static final String TYPE = "cdo";
    private IManagedContainer managedContainer = IPluginContainer.INSTANCE;

    public Net4jSessionFactory() {
        super(TYPE);
    }

    protected InternalCDOSession createSession(URI uri, Map<String, String> parameters) {
        String userID = parameters.get("userID");
        String repositoryName = parameters.get("repositoryName");
        if (repositoryName == null) {
            throw new IllegalArgumentException("Repository name is missing: " + uri);
        }
        CDONet4jSessionConfiguration configuration = CDONet4jUtil.createNet4jSessionConfiguration();
        configuration.setRepositoryName(repositoryName);
        configuration.setUserID(userID);
        configuration.setCredentialsProvider(this.getCredentialsProvider());
        configuration.setActivateOnOpen(false);
        return (InternalCDOSession)configuration.openNet4jSession();
    }

    protected IPasswordCredentialsProvider getCredentialsProvider() {
        try {
            IManagedContainer container = this.getManagedContainer();
            String type = this.getCredentialsProviderType();
            return (IPasswordCredentialsProvider)container.getElement("org.eclipse.net4j.util.security.credentialsProviders", type, null);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public IManagedContainer getManagedContainer() {
        return this.managedContainer;
    }

    public void setManagedContainer(IManagedContainer managedContainer) {
        this.managedContainer = managedContainer;
    }

    protected String getCredentialsProviderType() {
        return "interactive";
    }

    public static CDOSession get(IManagedContainer container, String description) {
        return (CDOSession)container.getElement("org.eclipse.emf.cdo.sessions", TYPE, description);
    }
}

