/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.common.ui.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.gmf.runtime.common.core.util.Log;
import org.eclipse.gmf.runtime.common.core.util.Trace;
import org.eclipse.gmf.runtime.common.ui.internal.CommonUIDebugOptions;
import org.eclipse.gmf.runtime.common.ui.internal.CommonUIPlugin;
import org.eclipse.gmf.runtime.common.ui.util.CustomData;
import org.eclipse.gmf.runtime.common.ui.util.ICustomData;
import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.TransferData;

public final class CustomDataTransfer
extends ByteArrayTransfer {
    private static final String XTOOLS = "XTOOLS";
    private static final int XTOOLSID = CustomDataTransfer.registerType((String)"XTOOLS");
    private static CustomDataTransfer instance = new CustomDataTransfer();

    public static CustomDataTransfer getInstance() {
        return instance;
    }

    private CustomDataTransfer() {
    }

    public void javaToNative(Object object, TransferData transferData) {
        if (object == null || !(object instanceof ICustomData[])) {
            return;
        }
        if (this.isSupportedType(transferData)) {
            ICustomData[] myTypes = (ICustomData[])object;
            try {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                DataOutputStream writeOut = new DataOutputStream(out);
                writeOut.writeInt(myTypes.length);
                byte[] array = null;
                int i = 0;
                while (i < myTypes.length) {
                    writeOut.writeUTF(myTypes[i].getFormatType());
                    array = myTypes[i].getData();
                    writeOut.writeInt(array.length);
                    writeOut.write(array);
                    ++i;
                }
                byte[] buffer = out.toByteArray();
                writeOut.close();
                super.javaToNative((Object)buffer, transferData);
            }
            catch (IOException e) {
                Trace.catching((Plugin)CommonUIPlugin.getDefault(), (String)CommonUIDebugOptions.EXCEPTIONS_CATCHING, ((Object)((Object)this)).getClass(), (String)"javaToNative", (Throwable)e);
                Log.error((Plugin)CommonUIPlugin.getDefault(), (int)4, (String)"javaToNative", (Throwable)e);
            }
        }
    }

    public Object nativeToJava(TransferData transferData) {
        if (this.isSupportedType(transferData)) {
            byte[] buffer = (byte[])super.nativeToJava(transferData);
            if (buffer == null) {
                return null;
            }
            try {
                ByteArrayInputStream in = new ByteArrayInputStream(buffer);
                DataInputStream readIn = new DataInputStream(in);
                int count = readIn.readInt();
                ICustomData[] myData = new ICustomData[count];
                String type = null;
                byte[] array = null;
                int i = 0;
                while (i < count) {
                    type = readIn.readUTF();
                    array = new byte[readIn.readInt()];
                    readIn.read(array);
                    myData[i] = new CustomData(type, array);
                    ++i;
                }
                readIn.close();
                return myData;
            }
            catch (IOException ex) {
                Trace.catching((Plugin)CommonUIPlugin.getDefault(), (String)CommonUIDebugOptions.EXCEPTIONS_CATCHING, ((Object)((Object)this)).getClass(), (String)"nativeToJava", (Throwable)ex);
                Log.error((Plugin)CommonUIPlugin.getDefault(), (int)4, (String)"nativeToJava", (Throwable)ex);
                return null;
            }
        }
        return null;
    }

    protected int[] getTypeIds() {
        return new int[]{XTOOLSID};
    }

    protected String[] getTypeNames() {
        return new String[]{XTOOLS};
    }
}

