/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.emf.clipboard.core.internal;

import java.io.BufferedReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.emf.clipboard.core.CopyObjects;
import org.eclipse.gmf.runtime.emf.clipboard.core.ObjectInfo;
import org.eclipse.gmf.runtime.emf.clipboard.core.internal.ResourceInfo;
import org.eclipse.gmf.runtime.emf.clipboard.core.internal.SavingEMFResource;

public class ResourceInfoProcessor {
    private static final String EMPTY_STRING = "";
    private static final String BEGIN_COMMENT = "<!-- ";
    private static final String END_COMMENT = " -->";
    private static final String ENDL = "\n";
    private static final String SEPARATOR = "|";
    private static final String PLUS = "+";
    private static final String COMMA = ",";
    private static final String PROPERTY_DELIM = "|+";
    private static final String VERSION = "VERSION";
    private static final String VERSION_VALUE = "1.0";
    private static final String TYPE = "TYPE";
    private static final String TYPE_VALUE = "EMF";
    private static final String OFFSET = "OFFSET";
    private static final String ENCODING = "ENCODING";
    private static final String OBJ_ID = "OBJ_ID";
    private static final String OBJ_COPY_TYPE = "OBJ_COPY_TYPE";
    private static final String CONTAINER_ID = "CONTAINER_ID";
    private static final String CONTAINER_CLASS = "CONTAINER_CLASS";
    private static final String HINTS = "HINTS";
    public static final String NONE = "NONE";
    private static final String COPY_PARENT_ID = "COPY_PARENT_ID";
    private static final String COPY_ALWAYS_IDS = "COPY_ALWAYS_IDS";

    private ResourceInfoProcessor() {
    }

    private static Properties getProperties(String commnetedString) {
        String str = ResourceInfoProcessor.removeCommnetTags(commnetedString);
        StringTokenizer tokenizer = new StringTokenizer(str, PROPERTY_DELIM);
        Properties properties = new Properties();
        String key = null;
        String value = null;
        while (tokenizer.hasMoreTokens()) {
            key = tokenizer.nextToken();
            value = tokenizer.nextToken();
            properties.setProperty(key.trim(), value.trim());
        }
        return properties;
    }

    private static List getCommaSeparatedStringsList(String string) {
        ArrayList<String> list = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(string, COMMA);
        while (tokenizer.hasMoreTokens()) {
            list.add(tokenizer.nextToken().trim());
        }
        return list;
    }

    private static String removeCommnetTags(String commnetedString) {
        return ResourceInfoProcessor.trimStrings(commnetedString, BEGIN_COMMENT, END_COMMENT);
    }

    private static String trimStrings(String string, String beginStr, String endStr) {
        int begin = string.indexOf(beginStr);
        int end = string.indexOf(endStr);
        String result = string.substring(begin + beginStr.length(), end);
        return result.trim();
    }

    private static void processOffset(StringBuffer stringBuffer, int offset) {
        stringBuffer.append(BEGIN_COMMENT);
        stringBuffer.append(OFFSET).append(SEPARATOR).append(offset);
        stringBuffer.append(END_COMMENT);
        stringBuffer.append(ENDL);
    }

    private static void processOffset(ResourceInfo resourceInfo, String str) {
        StringBuffer buffer = new StringBuffer(str);
        int baseLenStrOffset = str.lastIndexOf(BEGIN_COMMENT);
        String baseLenStr = buffer.substring(baseLenStrOffset);
        buffer.delete(baseLenStrOffset, buffer.length());
        int infoStrOffset = Integer.parseInt(ResourceInfoProcessor.getProperties(baseLenStr).getProperty(OFFSET));
        resourceInfo.info = buffer.substring(infoStrOffset);
        buffer.delete(infoStrOffset, buffer.length());
        resourceInfo.data = buffer.toString();
    }

    private static void processEObject(ResourceInfo resourceInfo, String line) {
        ObjectInfo objectInfo = new ObjectInfo();
        Properties properties = ResourceInfoProcessor.getProperties(line);
        objectInfo.objCopyType = properties.getProperty(OBJ_COPY_TYPE);
        objectInfo.objId = properties.getProperty(OBJ_ID);
        objectInfo.containerId = properties.getProperty(CONTAINER_ID);
        objectInfo.containerClass = properties.getProperty(CONTAINER_CLASS);
        objectInfo.hints = properties.getProperty(HINTS);
        objectInfo.copyParentId = properties.getProperty(COPY_PARENT_ID);
        String copyAlwaysIdStr = properties.getProperty(COPY_ALWAYS_IDS);
        if (!copyAlwaysIdStr.equals(NONE)) {
            List ids = ResourceInfoProcessor.getCommaSeparatedStringsList(copyAlwaysIdStr);
            objectInfo.copyAlwaysIds.addAll(ids);
        }
        resourceInfo.objects.put(objectInfo.objId, objectInfo);
    }

    private static void processEObject(StringBuffer stringBuffer, EObject eObject, SavingEMFResource emfResource, Map hintMap, CopyObjects copyObjects) {
        stringBuffer.append(BEGIN_COMMENT);
        String copyType = null;
        String containerId = null;
        String containerClass = null;
        EObject eObjectWithValidContainer = eObject;
        if (copyObjects.originalObjects.contains(eObject)) {
            copyType = "OCT_ORIGINAL";
        } else if (copyObjects.combinedCopyAlwaysSet.contains(eObject)) {
            copyType = "OCT_ALWAYS";
        } else {
            copyType = "OCT_PARENT";
            eObjectWithValidContainer = emfResource.getOriginalEObject(eObject);
        }
        stringBuffer.append(OBJ_COPY_TYPE).append(SEPARATOR).append(copyType).append(PLUS);
        stringBuffer.append(OBJ_ID).append(SEPARATOR).append(emfResource.getID(eObject)).append(PLUS);
        if (eObjectWithValidContainer != null && eObjectWithValidContainer.eContainer() != null) {
            containerId = emfResource.getID(eObjectWithValidContainer.eContainer());
            containerClass = eObjectWithValidContainer.eContainer().eClass().getInstanceClassName();
            stringBuffer.append(CONTAINER_ID).append(SEPARATOR).append(containerId).append(PLUS);
            stringBuffer.append(CONTAINER_CLASS).append(SEPARATOR).append(containerClass).append(PLUS);
        }
        String hints = (String)hintMap.get(eObject);
        stringBuffer.append(HINTS).append(SEPARATOR).append(hints == null ? NONE : hints).append(PLUS);
        EObject copyParent = (EObject)copyObjects.objectsToCopyParentMap.get(eObject);
        stringBuffer.append(COPY_PARENT_ID).append(SEPARATOR).append(copyParent == null ? NONE : emfResource.getID(copyParent)).append(PLUS);
        String copyAlwaysIdsStr = null;
        Set copyAlwaysSet = (Set)copyObjects.copyAlwaysMap.get(eObject);
        if (copyAlwaysSet != null && !copyAlwaysSet.isEmpty()) {
            copyAlwaysSet.retainAll(copyObjects.combinedCopyAlwaysSet);
            if (!copyAlwaysSet.isEmpty()) {
                copyAlwaysIdsStr = EMPTY_STRING;
                Iterator copyAlwaysSetIt = copyAlwaysSet.iterator();
                while (copyAlwaysSetIt.hasNext()) {
                    EObject copyAlwaysObject = (EObject)copyAlwaysSetIt.next();
                    copyAlwaysIdsStr = String.valueOf(copyAlwaysIdsStr) + emfResource.getID(copyAlwaysObject);
                    if (!copyAlwaysSetIt.hasNext()) continue;
                    copyAlwaysIdsStr = String.valueOf(copyAlwaysIdsStr) + COMMA;
                }
            }
        }
        stringBuffer.append(COPY_ALWAYS_IDS).append(SEPARATOR).append(copyAlwaysIdsStr == null ? NONE : copyAlwaysIdsStr);
        stringBuffer.append(END_COMMENT);
        stringBuffer.append(ENDL);
    }

    private static void processResource(ResourceInfo resourceInfo, String line) {
        Properties properties = ResourceInfoProcessor.getProperties(line);
        resourceInfo.encoding = properties.getProperty(ENCODING);
    }

    private static void processResource(StringBuffer stringBuffer, String encoding) {
        stringBuffer.append(BEGIN_COMMENT);
        stringBuffer.append(ENCODING).append(SEPARATOR).append(encoding);
        stringBuffer.append(END_COMMENT);
        stringBuffer.append(ENDL);
    }

    private static void processVersion(ResourceInfo resourceInfo, String line) {
        Properties properties = ResourceInfoProcessor.getProperties(line);
        resourceInfo.type = properties.getProperty(TYPE);
        resourceInfo.version = properties.getProperty(VERSION);
    }

    private static void processVersion(StringBuffer stringBuffer) {
        stringBuffer.append(BEGIN_COMMENT);
        stringBuffer.append(TYPE).append(SEPARATOR).append(TYPE_VALUE).append(PLUS);
        stringBuffer.append(VERSION).append(SEPARATOR).append(VERSION_VALUE);
        stringBuffer.append(END_COMMENT);
        stringBuffer.append(ENDL);
    }

    static ResourceInfo getResourceInfo(String str) throws Exception {
        ResourceInfo resourceInfo = new ResourceInfo();
        ResourceInfoProcessor.processOffset(resourceInfo, str);
        BufferedReader reader = new BufferedReader(new StringReader(resourceInfo.info));
        ResourceInfoProcessor.processVersion(resourceInfo, reader.readLine());
        ResourceInfoProcessor.processResource(resourceInfo, reader.readLine());
        String line = reader.readLine();
        while (line != null) {
            ResourceInfoProcessor.processEObject(resourceInfo, line);
            line = reader.readLine();
        }
        resourceInfo.completeEObjectInitialization();
        return resourceInfo;
    }

    public static String getResourceInfo(int offset, String encoding, SavingEMFResource emfResource, Map hintMap, CopyObjects copyObjects) {
        StringBuffer stringBuffer = new StringBuffer();
        ResourceInfoProcessor.processVersion(stringBuffer);
        ResourceInfoProcessor.processResource(stringBuffer, encoding);
        LinkedHashSet objectInfoSet = new LinkedHashSet(copyObjects.totalCopyObjects);
        objectInfoSet.addAll(copyObjects.originalObjects);
        Iterator it = objectInfoSet.iterator();
        while (it.hasNext()) {
            ResourceInfoProcessor.processEObject(stringBuffer, (EObject)it.next(), emfResource, hintMap, copyObjects);
        }
        ResourceInfoProcessor.processOffset(stringBuffer, offset);
        return stringBuffer.toString();
    }
}

