/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.gef.ui.internal.figures;

import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gmf.runtime.draw2d.ui.figures.IPolygonAnchorableFigure;
import org.eclipse.gmf.runtime.draw2d.ui.geometry.PrecisionPointList;
import org.eclipse.gmf.runtime.gef.ui.figures.DefaultSizeNodeFigure;

public class ConvexPentagonNodeFigure
extends DefaultSizeNodeFigure
implements IPolygonAnchorableFigure {
    private static final double DEFAULT_CONVEX_RATIO = 0.25;

    public ConvexPentagonNodeFigure(Dimension defSize) {
        super(defSize);
    }

    public ConvexPentagonNodeFigure(int width, int height) {
        super(width, height);
    }

    @Override
    protected void paintFigure(Graphics graphics) {
        PointList pointList = this.getPolygonPoints();
        graphics.fillPolygon(pointList);
        graphics.drawPolygon(pointList);
    }

    @Override
    public PointList getPolygonPoints() {
        PrecisionPointList ptList = new PrecisionPointList();
        Rectangle b = this.getBounds();
        ptList.addPoint((Point)new PrecisionPoint(b.x, b.y));
        ptList.addPoint((Point)new PrecisionPoint((double)b.x + (double)b.width * 0.75, (double)b.y));
        ptList.addPoint((Point)new PrecisionPoint(b.x + b.width, b.y + b.height / 2));
        ptList.addPoint((Point)new PrecisionPoint((double)b.x + (double)b.width * 0.75, (double)(b.y + b.height)));
        ptList.addPoint((Point)new PrecisionPoint(b.x, b.y + b.height));
        ptList.addPoint((Point)new PrecisionPoint(b.x, b.y));
        return ptList;
    }
}

