/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.core.utility;

import com.ibm.icu.text.Collator;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import org.eclipse.jpt.common.utility.internal.collection.CollectionTools;
import org.eclipse.jpt.common.utility.internal.io.WriterTools;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.internal.iterable.TransformationIterable;
import org.eclipse.jpt.common.utility.internal.predicate.PredicateAdapter;
import org.eclipse.jpt.common.utility.internal.transformer.TransformerAdapter;
import org.eclipse.jpt.common.utility.io.IndentingPrintWriter;
import org.eclipse.jpt.common.utility.predicate.Predicate;
import org.eclipse.jpt.common.utility.transformer.Transformer;

public class BodySourceWriter
extends IndentingPrintWriter {
    protected final String packageName;
    protected final String className;
    protected final HashMap<String, ImportPackage> imports = new HashMap();
    protected static final Transformer<Map.Entry<String, ImportPackage>, String> IMPORT_ENTRIES_TRANSFORMER = new ImportEntriesTransformer();
    protected static final Comparator<Map.Entry<String, ImportPackage>> IMPORT_ENTRIES_COMPARATOR = new ImportEntriesComparator();

    public BodySourceWriter(String packageName, String className, String lineSeparator) {
        super((Writer)new StringWriter(2000), DEFAULT_INDENT, lineSeparator);
        this.packageName = packageName;
        this.className = className;
    }

    public String getSource() {
        return this.out.toString();
    }

    public int getLength() {
        return ((StringWriter)this.out).getBuffer().length();
    }

    protected void printVisibility(String visibilityModifier) {
        if (visibilityModifier.length() != 0) {
            this.print(visibilityModifier);
            this.print(' ');
        }
    }

    public void printAnnotation(String annotationName) {
        this.print('@');
        this.printTypeDeclaration(annotationName);
    }

    public void printTypeDeclaration(String typeDeclaration) {
        this.print(this.buildImportedTypeDeclaration(typeDeclaration));
    }

    protected void printField(String fieldName, String typeDeclaration, String visibility) {
        this.printVisibility(visibility);
        this.printTypeDeclaration(typeDeclaration);
        this.print(' ');
        this.print(fieldName);
        this.print(';');
        this.println();
        this.println();
    }

    protected void printParameterizedField(String fieldName, String typeDeclaration, String parameterTypeDeclaration, String visibility) {
        this.printVisibility(visibility);
        this.printTypeDeclaration(typeDeclaration);
        this.print('<');
        this.printTypeDeclaration(parameterTypeDeclaration);
        this.print('>');
        this.print(' ');
        this.print(fieldName);
        this.print(';');
        this.println();
        this.println();
    }

    public void printStringLiteral(String string) {
        try {
            WriterTools.convertToJavaStringLiteral((Writer)((Object)this), (String)string);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    protected String buildImportedTypeDeclaration(String typeDeclaration) {
        String shortTypeDeclaration;
        if (this.typeDeclarationIsMemberClass(typeDeclaration)) {
            return this.buildMemberClassTypeDeclaration(typeDeclaration);
        }
        int last = typeDeclaration.lastIndexOf(46);
        String currentPackageName = last == -1 ? "" : typeDeclaration.substring(0, last);
        String shortElementTypeName = shortTypeDeclaration = typeDeclaration.substring(last + 1);
        while (shortElementTypeName.endsWith("[]")) {
            shortElementTypeName = shortElementTypeName.substring(0, shortElementTypeName.length() - 2);
        }
        ImportPackage prev = this.imports.get(shortElementTypeName);
        if (prev == null) {
            this.imports.put(shortElementTypeName, new ImportPackage(currentPackageName));
            return shortTypeDeclaration;
        }
        if (prev.packageName.equals(currentPackageName)) {
            return shortTypeDeclaration;
        }
        if (currentPackageName.equals(this.packageName) && prev.packageName.equals("java.lang")) {
            prev.collision = true;
        }
        return typeDeclaration;
    }

    protected boolean typeDeclarationIsMemberClass(String typeDeclaration) {
        return typeDeclaration.length() > this.className.length() && typeDeclaration.startsWith(this.className) && typeDeclaration.charAt(this.className.length()) == '.';
    }

    protected String buildMemberClassTypeDeclaration(String typeDeclaration) {
        int index = this.packageName.length();
        if (index != 0) {
            ++index;
        }
        return typeDeclaration.substring(index);
    }

    public Iterable<String> getImports() {
        return this.getSortedRequiredImports();
    }

    protected Iterable<String> getSortedRequiredImports() {
        return new TransformationIterable(this.getSortedRequiredImportEntries(), this.buildImportEntriesTransformer());
    }

    protected Transformer<Map.Entry<String, ImportPackage>, String> buildImportEntriesTransformer() {
        return IMPORT_ENTRIES_TRANSFORMER;
    }

    protected Iterable<Map.Entry<String, ImportPackage>> getSortedRequiredImportEntries() {
        TreeSet<Map.Entry<String, ImportPackage>> sortedEntries = new TreeSet<Map.Entry<String, ImportPackage>>(this.buildImportEntriesComparator());
        CollectionTools.addAll(sortedEntries, this.getRequiredImportEntries());
        return sortedEntries;
    }

    protected Comparator<Map.Entry<String, ImportPackage>> buildImportEntriesComparator() {
        return IMPORT_ENTRIES_COMPARATOR;
    }

    protected Iterable<Map.Entry<String, ImportPackage>> getRequiredImportEntries() {
        return IterableTools.filter(this.imports.entrySet(), this.buildImportEntryIsRequired());
    }

    protected Predicate<Map.Entry<String, ImportPackage>> buildImportEntryIsRequired() {
        return new ImportEntryIsRequired();
    }

    protected static class ImportEntriesComparator
    implements Comparator<Map.Entry<String, ImportPackage>>,
    Serializable {
        private static final long serialVersionUID = 1L;

        protected ImportEntriesComparator() {
        }

        @Override
        public int compare(Map.Entry<String, ImportPackage> e1, Map.Entry<String, ImportPackage> e2) {
            Collator collator = Collator.getInstance();
            int pkg = collator.compare(e1.getValue().packageName, e2.getValue().packageName);
            return pkg == 0 ? collator.compare(e1.getKey(), e2.getKey()) : pkg;
        }
    }

    protected static class ImportEntriesTransformer
    extends TransformerAdapter<Map.Entry<String, ImportPackage>, String> {
        protected ImportEntriesTransformer() {
        }

        public String transform(Map.Entry<String, ImportPackage> importEntry) {
            String pkg = importEntry.getValue().packageName;
            String type = importEntry.getKey();
            StringBuilder sb = new StringBuilder(pkg.length() + 1 + type.length());
            sb.append(pkg);
            sb.append('.');
            sb.append(type);
            return sb.toString();
        }
    }

    protected class ImportEntryIsRequired
    extends PredicateAdapter<Map.Entry<String, ImportPackage>> {
        protected ImportEntryIsRequired() {
        }

        public boolean evaluate(Map.Entry<String, ImportPackage> importEntry) {
            return this.packageMustBeImported(importEntry.getValue());
        }

        protected boolean packageMustBeImported(ImportPackage importPackage) {
            String pkg = importPackage.packageName;
            if (pkg.equals("")) {
                return false;
            }
            if (pkg.equals("java.lang")) {
                return importPackage.collision;
            }
            return !pkg.equals(BodySourceWriter.this.packageName);
        }
    }

    protected static class ImportPackage {
        protected final String packageName;
        protected boolean collision = false;

        protected ImportPackage(String packageName) {
            this.packageName = packageName;
        }
    }
}

