/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.jaxws.dom.runtime.util;

import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.IWebMethod;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.IWebParam;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.SOAPBindingParameterStyle;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.SOAPBindingStyle;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.WebParamKind;
import org.eclipse.jst.ws.jaxws.dom.runtime.persistence.annotation.AnnotationAdapterFactory;
import org.eclipse.jst.ws.jaxws.dom.runtime.persistence.annotation.IAnnotationAdapter;
import org.eclipse.jst.ws.jaxws.utils.annotations.IAnnotation;

public class Jee5DomUtils {
    private static Jee5DomUtils instance;

    private Jee5DomUtils() {
    }

    public boolean isPartNameUsed(IWebParam webParam) {
        IWebMethod webMethod = (IWebMethod)webParam.eContainer();
        return webMethod.getSoapBindingStyle() == SOAPBindingStyle.RPC || webMethod.getSoapBindingParameterStyle() == SOAPBindingParameterStyle.BARE;
    }

    public boolean isNameUsed(IWebParam webParam) {
        IWebMethod webMethod = (IWebMethod)webParam.eContainer();
        if (webMethod.getSoapBindingStyle() == SOAPBindingStyle.DOCUMENT || webParam.isHeader()) {
            return true;
        }
        IAnnotation<? extends IJavaElement> annotation = this.findAnnotation(webParam, "javax.jws.WebParam");
        if (annotation == null) {
            return false;
        }
        return annotation.getPropertyValue("partName") == null;
    }

    public IAnnotation<? extends IJavaElement> findAnnotation(EObject eObject, String annFQName) {
        IAnnotationAdapter adapter = (IAnnotationAdapter)AnnotationAdapterFactory.INSTANCE.adapt((Notifier)eObject, IAnnotationAdapter.class);
        if (adapter != null) {
            return adapter.getAnnotation(annFQName);
        }
        return null;
    }

    public boolean isNameRequired(IWebParam webParam) {
        IWebMethod webMethod = (IWebMethod)webParam.eContainer();
        return webMethod.getSoapBindingStyle() == SOAPBindingStyle.DOCUMENT && webMethod.getSoapBindingParameterStyle() == SOAPBindingParameterStyle.BARE && (webParam.getKind() == WebParamKind.INOUT || webParam.getKind() == WebParamKind.OUT);
    }

    public static Jee5DomUtils getInstance() {
        if (instance == null) {
            instance = new Jee5DomUtils();
        }
        return instance;
    }
}

