/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.callgraph.treeviewer;

import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.linuxtools.internal.callgraph.StapData;
import org.eclipse.linuxtools.internal.callgraph.StapGraph;

public class StapTreeDoubleClickListener
implements IDoubleClickListener {
    private StapGraph graph;
    private TreeViewer viewer;

    public StapTreeDoubleClickListener(TreeViewer t, StapGraph g) {
        this.graph = g;
        this.viewer = t;
    }

    /*
     * WARNING - void declaration
     */
    public void doubleClick(DoubleClickEvent event) {
        void selection;
        ISelection iSelection = event.getSelection();
        if (!(iSelection instanceof IStructuredSelection)) {
            return;
        }
        IStructuredSelection iStructuredSelection = (IStructuredSelection)iSelection;
        IStructuredSelection cfr_ignored_0 = (IStructuredSelection)iSelection;
        if (selection.size() != 1) {
            return;
        }
        for (StapData data : selection) {
            this.viewer.collapseToLevel((Object)data, 1);
            this.viewer.expandToLevel((Object)data, 1);
            this.graph.setCollapseMode(true);
            this.graph.draw(data.id);
            this.graph.getNode(data.id).unhighlight();
        }
        this.graph.setFocus();
    }
}

