/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.wtp.internal;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.m2e.wtp.MavenWtpPlugin;
import org.eclipse.m2e.wtp.internal.Messages;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WTPResourcesImages {
    private static final Logger LOG = LoggerFactory.getLogger(WTPResourcesImages.class);
    public static final ImageDescriptor WEB_RESOURCES = WTPResourcesImages.create("web-resources.gif");
    public static final ImageDescriptor APP_RESOURCES = WTPResourcesImages.create("ear-resources.gif");

    private static ImageDescriptor create(String key) {
        try {
            ImageRegistry imageRegistry = WTPResourcesImages.getImageRegistry();
            if (imageRegistry != null) {
                ImageDescriptor imageDescriptor = imageRegistry.getDescriptor(key);
                if (imageDescriptor == null) {
                    imageDescriptor = WTPResourcesImages.createDescriptor(key);
                    imageRegistry.put(key, imageDescriptor);
                }
                return imageDescriptor;
            }
        }
        catch (Exception ex) {
            LOG.error(NLS.bind((String)Messages.WTPResourcesImages_Error_Creating_ImageDescriptor, (Object)key), (Throwable)ex);
        }
        return null;
    }

    private static ImageRegistry getImageRegistry() {
        MavenWtpPlugin plugin = MavenWtpPlugin.getDefault();
        return plugin == null ? null : plugin.getImageRegistry();
    }

    private static ImageDescriptor createDescriptor(String image) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.m2e.wtp", (String)("icons/" + image));
    }
}

