/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.infra.browser.custom.editor.dialogs;

import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.jface.preference.ColorSelector;
import org.eclipse.modisco.infra.browser.custom.editor.Activator;
import org.eclipse.modisco.infra.browser.custom.editor.dialogs.EditFeatureValueDialog;
import org.eclipse.modisco.infra.browser.custom.util.UicustomUtil;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

public class ColorFeatureDialog
extends EditFeatureValueDialog {
    private ColorSelector colorSelector;

    public ColorFeatureDialog(Shell parentShell, boolean withCondition, boolean withDefault, List<String> availableQuerySets, List<Class<?>> expectedReturnTypes, EClass customizedMetaclass) {
        super(parentShell, withCondition, withDefault, availableQuerySets, expectedReturnTypes, customizedMetaclass);
    }

    @Override
    protected void createValueEditor(Composite parent) {
        this.colorSelector = new ColorSelector(parent);
        if (this.getInitialStaticValue() != null) {
            RGB color = UicustomUtil.decodeColor((String)this.getInitialStaticValue());
            if (color != null) {
                this.colorSelector.setColorValue(color);
            } else {
                Activator.logError("Wrong color format : " + this.getInitialStaticValue());
            }
        } else {
            this.colorSelector.setColorValue(new RGB(0, 0, 0));
        }
    }

    @Override
    protected void okPressed() {
        RGB col = this.colorSelector.getColorValue();
        this.setStaticValue("(" + col.red + "," + col.green + "," + col.blue + ")");
        super.okPressed();
    }
}

