/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.infra.browser.extensions;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.modisco.infra.common.core.internal.extensions.AbstractRegistry;

public class LoadingDepthRegistry
extends AbstractRegistry {
    public static final int INFINITE = -1;
    public static final int UNDEFINED = -2;
    private static final String EXTENSION_POINT_NAMESPACE = "org.eclipse.modisco.infra.browser";
    private static final String EXTENSION_POINT_NAME = "loadingDepth";
    private static final String LOADING_DEPTH_ELEMENT = "loadingDepth";
    private static final String METAMODEL_ATTRIBUTE = "metamodel";
    private static final String DEPTH_ATTRIBUTE = "depth";
    private static LoadingDepthRegistry instance = null;
    private final Map<String, Integer> loadingDepths = new HashMap<String, Integer>();

    public static LoadingDepthRegistry getInstance() {
        if (instance == null) {
            instance = new LoadingDepthRegistry();
        }
        return instance;
    }

    public LoadingDepthRegistry() {
        this.initialize();
    }

    public int getLoadingDepth(String nsURI) {
        Integer depth = this.loadingDepths.get(nsURI);
        if (depth == null || depth < -1) {
            return -2;
        }
        return depth;
    }

    protected String getExtensionPointName() {
        return "loadingDepth";
    }

    protected String getExtensionPointNamespace() {
        return EXTENSION_POINT_NAMESPACE;
    }

    protected void handleRootElement(IConfigurationElement configurationElement) {
        String name = configurationElement.getName();
        if (name.equalsIgnoreCase("loadingDepth")) {
            this.readLoadingDepthElement(configurationElement);
        } else {
            this.logUnknownElement(configurationElement);
        }
    }

    private void readLoadingDepthElement(IConfigurationElement configurationElement) {
        int intDepth;
        String metamodel = configurationElement.getAttribute(METAMODEL_ATTRIBUTE);
        if (metamodel == null) {
            this.logMissingAttribute(configurationElement, METAMODEL_ATTRIBUTE);
            return;
        }
        String depth = configurationElement.getAttribute(DEPTH_ATTRIBUTE);
        if (depth == null) {
            this.logMissingAttribute(configurationElement, DEPTH_ATTRIBUTE);
            return;
        }
        try {
            intDepth = Integer.parseInt(depth);
        }
        catch (NumberFormatException e) {
            this.logError(configurationElement, "depth is not a valid integer");
            return;
        }
        if (intDepth < -1) {
            this.logError(configurationElement, "invalid depth");
            return;
        }
        this.loadingDepths.put(metamodel, intDepth);
    }
}

