/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.github.ui.pr;

import java.io.IOException;
import java.text.MessageFormat;
import org.eclipse.core.commands.common.CommandException;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.egit.github.core.PullRequest;
import org.eclipse.egit.ui.UIUtils;
import org.eclipse.egit.ui.internal.UIIcons;
import org.eclipse.egit.ui.internal.commit.CommitEditor;
import org.eclipse.egit.ui.internal.commit.RepositoryCommit;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.mylyn.internal.github.core.GitHub;
import org.eclipse.mylyn.internal.github.core.pr.PullRequestComposite;
import org.eclipse.mylyn.internal.github.core.pr.PullRequestUtils;
import org.eclipse.mylyn.internal.github.ui.GitHubUi;
import org.eclipse.mylyn.internal.github.ui.TaskDataHandler;
import org.eclipse.mylyn.internal.github.ui.pr.Messages;
import org.eclipse.mylyn.internal.github.ui.pr.PullRequestAdapter;
import org.eclipse.mylyn.internal.github.ui.pr.PullRequestCommitAdapter;
import org.eclipse.mylyn.internal.github.ui.pr.PullRequestConnectorUi;
import org.eclipse.mylyn.internal.tasks.ui.editors.AbstractTaskEditorSection;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.ui.TasksUiUtil;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.menus.CommandContributionItem;
import org.eclipse.ui.menus.CommandContributionItemParameter;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.services.IServiceLocator;

public class CommitAttributePart
extends AbstractTaskEditorSection {
    private CommandContributionItem fetchCommits;
    private PullRequestComposite request;

    public CommitAttributePart(PullRequestComposite request) {
        this.setPartName(Messages.CommitAttributePart_PartName);
        this.request = request;
    }

    protected Control createContent(FormToolkit toolkit, Composite parent) {
        Composite displayArea = toolkit.createComposite(parent);
        GridLayoutFactory.fillDefaults().spacing(0, 0).applyTo(displayArea);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)displayArea);
        if (this.request != null) {
            Composite refArea = toolkit.createComposite(displayArea);
            GridLayoutFactory.fillDefaults().spacing(0, 0).numColumns(4).applyTo(refArea);
            GridDataFactory.swtDefaults().grab(true, false).applyTo((Control)refArea);
            Image branchIcon = UIIcons.BRANCH.createImage();
            UIUtils.hookDisposal((Widget)refArea, (Resource)branchIcon);
            CLabel sourceLabel = new CLabel(refArea, 0);
            toolkit.adapt((Control)sourceLabel, false, false);
            sourceLabel.setText(Messages.CommitAttributePart_LabelSource);
            sourceLabel.setImage(branchIcon);
            sourceLabel.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
            toolkit.createText(refArea, this.request.getRequest().getHead().getLabel(), 8);
            CLabel destLabel = new CLabel(refArea, 0);
            toolkit.adapt((Control)destLabel, false, false);
            destLabel.setText(Messages.CommitAttributePart_LabelDestination);
            destLabel.setImage(branchIcon);
            destLabel.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
            GridDataFactory.swtDefaults().indent(15, 0).applyTo((Control)destLabel);
            toolkit.createText(refArea, this.request.getRequest().getBase().getLabel(), 8);
        }
        Composite treeArea = toolkit.createComposite(displayArea);
        toolkit.paintBordersFor(treeArea);
        GridLayoutFactory.fillDefaults().spacing(0, 0).extendedMargins(2, 2, 2, 7).applyTo(treeArea);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)treeArea);
        TreeViewer commitViewer = new TreeViewer(toolkit.createTree(treeArea, 0x300 | toolkit.getBorderStyle()));
        commitViewer.setContentProvider((IContentProvider)new WorkbenchContentProvider());
        commitViewer.setLabelProvider((IBaseLabelProvider)new DelegatingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)new WorkbenchLabelProvider()));
        GridDataFactory.fillDefaults().grab(true, true).applyTo(commitViewer.getControl());
        commitViewer.getControl().setData("FormWidgetFactory.drawBorder", (Object)"treeBorder");
        commitViewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                PullRequest pr = CommitAttributePart.this.request.getRequest();
                Repository repo = PullRequestUtils.getRepository((PullRequest)pr);
                if (repo != null) {
                    CommitAttributePart.this.openCommits(repo, ((IStructuredSelection)event.getSelection()).toArray());
                } else {
                    PullRequestConnectorUi.showNoRepositoryDialog(pr);
                }
            }
        });
        int size = 0;
        if (this.request != null) {
            PullRequestAdapter root = new PullRequestAdapter(this.request);
            size = root.getChildren((Object)root).length;
            commitViewer.setInput((Object)root);
            Point treeSize = commitViewer.getControl().computeSize(-1, -1);
            ((GridData)commitViewer.getControl().getLayoutData()).heightHint = Math.min(treeSize.y, 200);
        }
        this.getSection().setText(MessageFormat.format(Messages.CommitAttributePart_SectionCommits, size));
        return displayArea;
    }

    private void openCommits(Repository repository, Object[] elements) {
        if (elements.length == 0) {
            return;
        }
        if (repository == null) {
            return;
        }
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (RevWalk walk = new RevWalk(repository);){
                Object[] objectArray = elements;
                int n = elements.length;
                int n2 = 0;
                while (n2 < n) {
                    block16: {
                        Object element = objectArray[n2];
                        String id = ((PullRequestCommitAdapter)((Object)element)).getCommit().getSha();
                        try {
                            CommitEditor.openQuiet((RepositoryCommit)new RepositoryCommit(repository, walk.parseCommit((AnyObjectId)ObjectId.fromString((String)id))));
                        }
                        catch (MissingObjectException ignored) {
                            boolean fetch = MessageDialog.openQuestion((Shell)this.getControl().getShell(), (String)Messages.CommitAttributePart_TitleFetch, (String)Messages.CommitAttributePart_MessageFetch);
                            if (!fetch) break block16;
                            this.fetchCommits(() -> PlatformUI.getWorkbench().getDisplay().asyncExec(() -> this.openCommits(repository, elements)));
                        }
                    }
                    ++n2;
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            GitHubUi.logError(e);
        }
    }

    private CommandContributionItem createCommandContributionItem(String commandId) {
        CommandContributionItemParameter parameter = new CommandContributionItemParameter((IServiceLocator)this.getTaskEditorPage().getEditorSite(), commandId, commandId, 8);
        return new CommandContributionItem(parameter);
    }

    protected void fillToolBar(ToolBarManager toolBarManager) {
        if (TasksUiUtil.isOutgoingNewTask((ITask)this.getTaskEditorPage().getTask(), (String)"github")) {
            return;
        }
        if (this.request == null) {
            return;
        }
        this.fetchCommits = this.createCommandContributionItem("org.eclipse.mylyn.github.ui.command.fetchPullRequest");
        toolBarManager.add((IContributionItem)this.fetchCommits);
    }

    protected String getInfoOverlayText() {
        return this.request != null ? this.request.getRequest().getHead().getLabel() : null;
    }

    protected boolean shouldExpandOnCreate() {
        return true;
    }

    private void fetchCommits(Runnable postHandler) {
        IHandlerService handlerService = (IHandlerService)this.getTaskEditorPage().getEditorSite().getService(IHandlerService.class);
        try {
            IEvaluationContext context = TaskDataHandler.createContext((IStructuredSelection)new StructuredSelection((Object)this.getTaskData()), handlerService);
            if (postHandler != null) {
                context.addVariable("postHandlerCallback", (Object)postHandler);
            }
            handlerService.executeCommandInContext(this.fetchCommits.getCommand(), new Event(), context);
        }
        catch (CommandException e) {
            GitHub.logError((Throwable)e);
        }
    }
}

