/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.emf.validation.validity.locator;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.emf.validation.validity.LeafConstrainingNode;
import org.eclipse.ocl.examples.emf.validation.validity.Result;
import org.eclipse.ocl.examples.emf.validation.validity.Severity;
import org.eclipse.ocl.examples.emf.validation.validity.ValidityFactory;
import org.eclipse.ocl.examples.emf.validation.validity.locator.AbstractConstraintLocator;
import org.eclipse.ocl.examples.emf.validation.validity.locator.ConstraintLocator;
import org.eclipse.ocl.examples.emf.validation.validity.manager.ValidityManager;
import org.eclipse.ocl.examples.emf.validation.validity.manager.ValidityModel;
import org.eclipse.ocl.examples.emf.validation.validity.plugin.ValidityPlugin;

public class EClassConstraintLocator
extends AbstractConstraintLocator {
    public static @NonNull EClassConstraintLocator INSTANCE = new EClassConstraintLocator();

    @Override
    public @Nullable Map<@NonNull EObject, @NonNull List<@NonNull LeafConstrainingNode>> getConstraints(@NonNull ValidityModel validityModel, @NonNull EPackage ePackage, @NonNull Set<@NonNull Resource> resources, @NonNull Monitor monitor) {
        HashMap map = null;
        for (EClassifier eClassifier : ePackage.getEClassifiers()) {
            if (monitor.isCanceled()) {
                return null;
            }
            if (!(eClassifier instanceof EClass)) continue;
            EClass eClass = (EClass)eClassifier;
            ArrayList<LeafConstrainingNode> constraints = null;
            for (EOperation eOperation : eClass.getEOperations()) {
                if (!EcoreUtil.isInvariant((EOperation)eOperation)) continue;
                LeafConstrainingNode constraint = ValidityFactory.eINSTANCE.createLeafConstrainingNode();
                constraint.setConstraintLocator(this);
                constraint.setConstrainingObject(eOperation);
                constraint.setLabel(validityModel.getConstrainingLabel((EObject)eOperation));
                if (constraints == null) {
                    constraints = new ArrayList<LeafConstrainingNode>();
                }
                constraints.add(constraint);
            }
            if (constraints == null) continue;
            if (map == null) {
                map = new HashMap();
            }
            map.put(eClass, constraints);
        }
        return map;
    }

    @Override
    public Object getImage() {
        return ValidityPlugin.INSTANCE.getImage("EOperation.gif");
    }

    @Override
    public @NonNull ConstraintLocator getInstance() {
        return INSTANCE;
    }

    @Override
    public @NonNull String getName() {
        return "EClass invariants";
    }

    @Override
    public void validate(@NonNull Result result, @NonNull ValidityManager validityManager, @Nullable Monitor monitor) {
        super.validate(result, validityManager, monitor);
        EOperation eOperation = (EOperation)result.getLeafConstrainingNode().getConstrainingObject();
        EObject eObject = result.getValidatableNode().getConstrainedObject();
        if (eObject != null) {
            BasicDiagnostic diagnostic = validityManager.createDefaultDiagnostic(eObject);
            BasicEList arguments = new BasicEList();
            arguments.add((Object)diagnostic);
            arguments.add(validityManager.createDefaultContext());
            try {
                eObject.eInvoke(eOperation, (EList)arguments);
                result.setDiagnostic(diagnostic);
                result.setSeverity(this.getSeverity((Diagnostic)diagnostic));
            }
            catch (InvocationTargetException e) {
                result.setException(e);
                result.setSeverity(Severity.FATAL);
            }
        }
    }
}

