/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.bnd;

import aQute.bnd.properties.IRegion;
import aQute.bnd.properties.LineType;
import aQute.bnd.properties.PropertiesLineReader;
import aQute.service.reporter.Report;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.pde.internal.core.bnd.BndDocument;
import org.eclipse.pde.internal.core.builders.ErrorReporter;

public class BndErrorReporter
extends ErrorReporter {
    private BndDocument bndDocument;
    private Report report;

    public BndErrorReporter(IProject project, Report report) {
        super(project.getFile("pde.bnd"));
        this.report = report;
        IDocument document = this.createDocument(this.fFile);
        if (document != null) {
            this.bndDocument = new BndDocument(document);
        }
    }

    @Override
    protected void validate(IProgressMonitor monitor) {
        if (this.report != null) {
            for (String warn : this.report.getWarnings()) {
                this.reportProblem(warn, 1, this.report.getLocation(warn));
            }
            for (String err : this.report.getErrors()) {
                this.reportProblem(err, 0, this.report.getLocation(err));
            }
        }
    }

    private void reportProblem(String err, int severity, Report.Location location) {
        int line = -1;
        if (location != null) {
            if (location.line > 0) {
                line = location.line;
            } else if (location.header != null && this.bndDocument != null) {
                try {
                    PropertiesLineReader reader = new PropertiesLineReader((aQute.bnd.properties.IDocument)this.bndDocument);
                    LineType type = reader.next();
                    while (type != LineType.eof) {
                        String key;
                        if (type == LineType.entry && location.header.equals(key = reader.key())) {
                            IRegion region = reader.region();
                            line = this.bndDocument.getLineOfOffset(region.getOffset()) + 1;
                            break;
                        }
                        type = reader.next();
                    }
                }
                catch (Exception exception) {}
            }
        }
        this.report(err, line, severity, "fatal");
    }
}

