/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.sessions.remote;

import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.config.ReferenceMode;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.databaseaccess.Platform;
import org.eclipse.persistence.internal.helper.ConcurrencyManager;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.helper.InvalidObject;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.CommitManager;
import org.eclipse.persistence.internal.sessions.MergeManager;
import org.eclipse.persistence.internal.sessions.ObjectChangeSet;
import org.eclipse.persistence.internal.sessions.RepeatableWriteUnitOfWork;
import org.eclipse.persistence.internal.sessions.UnitOfWorkChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.internal.sessions.remote.RemoteSessionController;
import org.eclipse.persistence.internal.sessions.remote.Transporter;
import org.eclipse.persistence.platform.database.DatabasePlatform;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.sessions.remote.DistributedSession;
import org.eclipse.persistence.sessions.server.ServerSession;

public class RemoteUnitOfWork
extends RepeatableWriteUnitOfWork {
    protected List newObjectsCache;
    protected List unregisteredNewObjectsCache;
    protected boolean isOnClient;
    protected transient RemoteSessionController parentSessionController;
    protected boolean isFlush;

    public RemoteUnitOfWork() {
    }

    public RemoteUnitOfWork(RemoteUnitOfWork parent) {
        this(parent, null);
    }

    public RemoteUnitOfWork(DistributedSession parent) {
        this(parent, null);
    }

    public RemoteUnitOfWork(RemoteUnitOfWork parent, ReferenceMode referenceMode) {
        super(parent, referenceMode);
        this.isOnClient = true;
        this.discoverUnregisteredNewObjectsWithoutPersist = true;
    }

    public RemoteUnitOfWork(DistributedSession parent, ReferenceMode referenceMode) {
        super(parent, referenceMode);
        this.isOnClient = true;
        this.discoverUnregisteredNewObjectsWithoutPersist = true;
    }

    public boolean isFlush() {
        return this.isFlush;
    }

    public void setIsFlush(boolean isFlush) {
        this.isFlush = isFlush;
    }

    @Override
    public void beginEarlyTransaction() throws DatabaseException {
        this.getParent().getTransactionMutex().acquire();
        this.startOperationProfile("Timer:Remote", null, Integer.MAX_VALUE);
        ((DistributedSession)this.getParent()).getRemoteConnection().beginEarlyTransaction();
        this.endOperationProfile("Timer:Remote", null, Integer.MAX_VALUE);
        this.setWasTransactionBegunPrematurely(true);
    }

    @Override
    public UnitOfWorkImpl acquireUnitOfWork() {
        return this.acquireUnitOfWork(null);
    }

    @Override
    public UnitOfWorkImpl acquireUnitOfWork(ReferenceMode referenceMode) {
        this.log(2, "transaction", "acquire_unit_of_work");
        this.setNumberOfActiveUnitsOfWork(this.getNumberOfActiveUnitsOfWork() + 1);
        RemoteUnitOfWork ruow = new RemoteUnitOfWork(this, referenceMode);
        ruow.discoverAllUnregisteredNewObjectsInParent();
        return ruow;
    }

    protected List collectNewObjects() {
        if (this.newObjectsCloneToOriginal == null || this.newObjectsCloneToOriginal.isEmpty()) {
            return null;
        }
        ArrayList newObjects = new ArrayList(this.newObjectsCloneToOriginal.size());
        for (Object newObject : this.newObjectsCloneToOriginal.keySet()) {
            newObjects.add(newObject);
        }
        return newObjects;
    }

    protected List collectUnregisteredNewObjects() {
        this.discoverAllUnregisteredNewObjects();
        return new ArrayList(this.getUnregisteredNewObjects().values());
    }

    protected void commitIntoRemoteUnitOfWork() {
        UnitOfWorkImpl parent = (UnitOfWorkImpl)this.getParent();
        parent.setWasTransactionBegunPrematurely(this.wasTransactionBegunPrematurely());
        MergeManager manager = new MergeManager(this);
        manager.mergeWorkingCopyIntoRemote();
        Iterator cloneIterator = new IdentityHashMap(this.getCloneMapping()).keySet().iterator();
        IdentityHashMap clones = new IdentityHashMap(this.cloneMapping.size());
        while (cloneIterator.hasNext()) {
            Object remoteClone = cloneIterator.next();
            manager.mergeChanges(remoteClone, null, this);
            Object clone = manager.getTargetVersionOfSourceObject(remoteClone, parent.getDescriptor(remoteClone), parent);
            clones.put(remoteClone, clone);
        }
        parent.setUnitOfWorkChangeSet(this.unitOfWorkChangeSet);
        this.fixRemoteChangeSet(this.unitOfWorkChangeSet, clones, parent);
        ((RemoteUnitOfWork)parent).setCumulativeUOWChangeSet(this.cumulativeUOWChangeSet);
        this.fixRemoteChangeSet(this.cumulativeUOWChangeSet, clones, parent);
        if (this.objectsDeletedDuringCommit != null) {
            IdentityHashMap newDeletedObjects = new IdentityHashMap();
            for (Object deletedObject : this.objectsDeletedDuringCommit.keySet()) {
                Object primaryKey = this.getId(deletedObject);
                Object clone = clones.get(deletedObject);
                if (clone == null && (clone = parent.getIdentityMapAccessor().getFromIdentityMap(primaryKey, deletedObject.getClass())) == null) {
                    clone = deletedObject;
                }
                newDeletedObjects.put(clone, primaryKey);
                parent.getIdentityMapAccessor().removeFromIdentityMap(primaryKey, clone.getClass());
            }
            parent.setObjectsDeletedDuringCommit(newDeletedObjects);
        }
    }

    @Override
    public void writeChanges() {
        RemoteUnitOfWork remoteUnitOfWork;
        boolean hasChanges;
        if (!this.isOnClient()) {
            super.writeChanges();
            return;
        }
        if (this.isWithinFlush()) {
            this.log(6, "transaction", "nested_entity_manager_flush_not_executed_pre_query_changes_may_be_pending", this.getClass().getSimpleName());
            return;
        }
        this.log(2, "transaction", "begin_unit_of_work_flush");
        boolean bl = hasChanges = this.unitOfWorkChangeSet != null || this.hasCloneMapping() || this.hasDeletedObjects() || this.hasModifyAllQueries() || this.hasDeferredModifyAllQueries();
        if (hasChanges) {
            if (this.unitOfWorkChangeSet == null) {
                this.unitOfWorkChangeSet = new UnitOfWorkChangeSet(this);
            }
            this.calculateChanges(this.getCloneMapping(), this.unitOfWorkChangeSet, true, true);
            hasChanges = this.hasModifications();
        }
        if (!hasChanges) {
            this.log(2, "transaction", "end_unit_of_work_flush");
            return;
        }
        if (!this.wasTransactionBegunPrematurely()) {
            this.beginEarlyTransaction();
        }
        this.setNewObjectsCache(this.collectNewObjects());
        this.setUnregisteredNewObjectsCache(this.collectUnregisteredNewObjects());
        try {
            this.setIsFlush(true);
            this.startOperationProfile("Timer:Remote", null, Integer.MAX_VALUE);
            remoteUnitOfWork = ((DistributedSession)this.getParent()).getRemoteConnection().commitRootUnitOfWork(this);
            this.endOperationProfile("Timer:Remote", null, Integer.MAX_VALUE);
        }
        finally {
            this.setIsFlush(false);
        }
        remoteUnitOfWork.setParent(this);
        remoteUnitOfWork.setProject(this.getProject());
        remoteUnitOfWork.prepareForMergeIntoRemoteUnitOfWork();
        remoteUnitOfWork.commitIntoRemoteUnitOfWork();
        this.log(2, "transaction", "end_unit_of_work_flush");
        this.resumeUnitOfWork();
        this.log(2, "transaction", "resume_unit_of_work");
    }

    @Override
    public void commitRootUnitOfWork() {
        RemoteUnitOfWork remoteUnitOfWork;
        boolean hasChanges;
        if (!this.isOnClient()) {
            if (this.isSynchronized()) {
                if (this.getParent().wasJTSTransactionInternallyStarted()) {
                    this.commitInternallyStartedExternalTransaction();
                }
                return;
            }
            if (this.eventManager != null) {
                this.eventManager.preCommitUnitOfWork();
            }
            super.commitRootUnitOfWork();
            if (this.eventManager != null) {
                this.eventManager.postCommitUnitOfWork();
            }
            return;
        }
        boolean bl = hasChanges = this.unitOfWorkChangeSet != null || this.hasCloneMapping() || this.hasDeletedObjects() || this.hasModifyAllQueries() || this.hasDeferredModifyAllQueries();
        if (hasChanges) {
            if (this.unitOfWorkChangeSet == null) {
                this.unitOfWorkChangeSet = new UnitOfWorkChangeSet(this);
            }
            this.calculateChanges(this.getCloneMapping(), this.unitOfWorkChangeSet, true, true);
            hasChanges = this.hasModifications();
        }
        if (!hasChanges && this.cumulativeUOWChangeSet == null && this.classesToBeInvalidated == null) {
            if (this.wasTransactionBegunPrematurely()) {
                this.setWasTransactionBegunPrematurely(false);
                this.setWasNonObjectLevelModifyQueryExecuted(false);
                try {
                    this.commitTransaction();
                }
                catch (RuntimeException commitFailed) {
                    try {
                        this.rollbackTransaction();
                    }
                    catch (RuntimeException runtimeException) {
                        // empty catch block
                    }
                    throw commitFailed;
                }
                catch (Error error) {
                    try {
                        this.rollbackTransaction();
                    }
                    catch (RuntimeException runtimeException) {
                        // empty catch block
                    }
                    throw error;
                }
            }
            return;
        }
        this.setNewObjectsCache(this.collectNewObjects());
        this.setUnregisteredNewObjectsCache(this.collectUnregisteredNewObjects());
        try {
            this.startOperationProfile("Timer:Remote", null, Integer.MAX_VALUE);
            remoteUnitOfWork = ((DistributedSession)this.getParent()).getRemoteConnection().commitRootUnitOfWork(this);
            this.endOperationProfile("Timer:Remote", null, Integer.MAX_VALUE);
        }
        catch (RuntimeException exception) {
            if (this.wasTransactionBegunPrematurely()) {
                this.getParent().getTransactionMutex().release();
            }
            this.setWasTransactionBegunPrematurely(false);
            throw exception;
        }
        if (this.wasTransactionBegunPrematurely()) {
            this.setWasTransactionBegunPrematurely(false);
            this.setWasNonObjectLevelModifyQueryExecuted(false);
            this.getParent().getTransactionMutex().release();
        }
        remoteUnitOfWork.setParent(this);
        remoteUnitOfWork.setProject(this.getProject());
        remoteUnitOfWork.prepareForMergeIntoRemoteUnitOfWork();
        remoteUnitOfWork.commitIntoRemoteUnitOfWork();
        this.commitRootUnitOfWorkOnClient();
    }

    @Override
    public UnitOfWorkChangeSet calculateChanges(Map registeredObjects, UnitOfWorkChangeSet changeSet, boolean assignSequences, boolean shouldCloneMap) {
        if (!this.isOnClient) {
            return changeSet;
        }
        return super.calculateChanges(registeredObjects, changeSet, assignSequences, shouldCloneMap);
    }

    @Override
    public void resumeUnitOfWork() {
        if (!this.isOnClient) {
            return;
        }
        super.resumeUnitOfWork();
    }

    protected void commitRootUnitOfWorkOnClient() {
        this.collectAndPrepareObjectsForNestedMerge();
        UnitOfWorkChangeSet uowChangeSet = (UnitOfWorkChangeSet)this.getUnitOfWorkChangeSet();
        if (uowChangeSet == null) {
            uowChangeSet = new UnitOfWorkChangeSet(this);
            this.setUnitOfWorkChangeSet(uowChangeSet);
            this.calculateChanges(this.getCloneMapping(), uowChangeSet, false, true);
            this.allClones = null;
        }
        for (Map<ObjectChangeSet, ObjectChangeSet> newList : uowChangeSet.getNewObjectChangeSets().values()) {
            Iterator<ObjectChangeSet> newChangeSets = new IdentityHashMap<ObjectChangeSet, ObjectChangeSet>(newList).keySet().iterator();
            while (newChangeSets.hasNext()) {
                uowChangeSet.putNewObjectInChangesList(newChangeSets.next(), this);
            }
        }
        if (this.objectsDeletedDuringCommit != null) {
            for (Map<ObjectChangeSet, ObjectChangeSet> deletedObject : this.objectsDeletedDuringCommit.keySet()) {
                uowChangeSet.addDeletedObject(deletedObject, this);
            }
        }
        this.mergeChangesIntoParent();
    }

    @Override
    public Object executeQuery(String queryName) throws DatabaseException {
        return this.executeQuery(queryName, new Vector(1));
    }

    @Override
    public Object executeQuery(String queryName, Class domainClass) throws DatabaseException {
        return this.executeQuery(queryName, domainClass, new Vector(1));
    }

    @Override
    public Object executeQuery(String queryName, Class domainClass, Vector argumentValues) throws DatabaseException {
        DistributedSession remoteSession = null;
        if (this.getParent().isRemoteSession()) {
            remoteSession = (DistributedSession)this.getParent();
        } else {
            RemoteUnitOfWork uow = (RemoteUnitOfWork)this.getParent();
            while (uow.getParent().isRemoteUnitOfWork()) {
                uow = (RemoteUnitOfWork)uow.getParent();
            }
            remoteSession = (DistributedSession)uow.getParent();
        }
        this.startOperationProfile("Timer:Remote", null, Integer.MAX_VALUE);
        Transporter transporter = remoteSession.getRemoteConnection().remoteExecuteNamedQuery(queryName, domainClass, argumentValues);
        this.endOperationProfile("Timer:Remote", null, Integer.MAX_VALUE);
        transporter.getQuery().setSession(this);
        return transporter.getQuery().extractRemoteResult(transporter);
    }

    @Override
    public Object executeQuery(String queryName, Vector argumentValues) throws DatabaseException {
        if (this.containsQuery(queryName)) {
            return super.executeQuery(queryName, argumentValues);
        }
        return this.executeQuery(queryName, null, argumentValues);
    }

    @Override
    public ClassDescriptor getDescriptor(Class domainClass) {
        return this.getParent().getDescriptor(domainClass);
    }

    @Override
    public ClassDescriptor getDescriptorForAlias(String alias) {
        return this.getParent().getDescriptorForAlias(alias);
    }

    public List getNewObjectsCache() {
        return this.newObjectsCache;
    }

    public RemoteSessionController getParentSessionController() {
        return this.parentSessionController;
    }

    @Override
    public DatabasePlatform getPlatform() {
        return this.getParent().getPlatform();
    }

    @Override
    public Platform getDatasourcePlatform() {
        return this.getParent().getDatasourcePlatform();
    }

    public List getUnregisteredNewObjectsCache() {
        return this.unregisteredNewObjectsCache;
    }

    @Override
    public Object internalExecuteQuery(DatabaseQuery query, AbstractRecord Record2) throws DatabaseException, QueryException {
        if (this.isOnClient()) {
            boolean objectLevelRead;
            boolean bl = objectLevelRead = query.isObjectLevelReadQuery() && !query.isReportQuery() && query.shouldMaintainCache();
            if (objectLevelRead) {
                ObjectLevelReadQuery readQuery = (ObjectLevelReadQuery)query;
                if (this.isAfterWriteChangesButBeforeCommit()) {
                    throw ValidationException.illegalOperationForUnitOfWorkLifecycle(this.getLifecycle(), "executeQuery(ObjectLevelReadQuery)");
                }
                Object result = readQuery.checkEarlyReturn(this, Record2);
                if (result != null) {
                    if (result == InvalidObject.instance) {
                        return null;
                    }
                    return result;
                }
                if (readQuery.isLockQuery(this) && !this.wasTransactionBegunPrematurely()) {
                    this.beginEarlyTransaction();
                }
            } else if (query.isObjectLevelModifyQuery()) {
                return query.executeInUnitOfWork(this, Record2);
            }
            if (!this.getCommitManager().isActive() && query.isModifyQuery() && !this.wasTransactionBegunPrematurely()) {
                this.beginEarlyTransaction();
            }
            Object result = this.getParent().executeQuery(query, Record2);
            if (objectLevelRead) {
                result = ((ObjectLevelReadQuery)query).registerResultInUnitOfWork(result, this, Record2, false);
            }
            if (query.isModifyAllQuery()) {
                this.storeModifyAllQuery(query);
            }
            return result;
        }
        return query.executeInUnitOfWork(this, Record2);
    }

    protected boolean isOnClient() {
        return this.isOnClient;
    }

    @Override
    public boolean isRemoteUnitOfWork() {
        return true;
    }

    protected void prepareForMergeIntoRemoteUnitOfWork() {
        if (this.newObjectsCache == null) {
            return;
        }
        int size = this.newObjectsCache.size();
        if (size == 0) {
            return;
        }
        IdentityHashMap<Object, Object> originalToClone = new IdentityHashMap<Object, Object>(size);
        IdentityHashMap<Object, Object> cloneToOriginal = new IdentityHashMap<Object, Object>(size);
        List remoteNewObjects = ((RemoteUnitOfWork)this.parent).getNewObjectsCache();
        int index = 0;
        while (index < size) {
            Object cloneFromParent = remoteNewObjects.get(index);
            Object cloneFromSelf = this.newObjectsCache.get(index);
            if (cloneFromSelf != null) {
                originalToClone.put(cloneFromParent, cloneFromSelf);
                cloneToOriginal.put(cloneFromSelf, cloneFromParent);
            }
            ++index;
        }
        List remoteUnregisteredObjects = ((RemoteUnitOfWork)this.parent).getUnregisteredNewObjectsCache();
        size = remoteUnregisteredObjects.size();
        int index2 = 0;
        while (index2 < size) {
            Object cloneFromParent = ((RemoteUnitOfWork)this.getParent()).getUnregisteredNewObjects().get(remoteUnregisteredObjects.get(index2));
            Object cloneFromSelf = this.getUnregisteredNewObjects().get(this.unregisteredNewObjectsCache.get(index2));
            originalToClone.put(cloneFromParent, cloneFromSelf);
            cloneToOriginal.put(cloneFromSelf, cloneFromParent);
            ++index2;
        }
        this.newObjectsOriginalToClone = originalToClone;
        this.newObjectsCloneToOriginal = cloneToOriginal;
    }

    public void reinitializeForSession(AbstractSession session, RemoteSessionController parentSessionController) {
        if (session.isServerSession()) {
            session = ((ServerSession)session).acquireClientSession();
        }
        this.setIsOnClient(false);
        this.setParentSessionController(parentSessionController);
        this.setParent(session);
        this.setProject(session.getProject());
        this.setProfiler(session.getProfiler());
        if (session.hasEventManager()) {
            this.setEventManager(session.getEventManager().clone(this));
        }
        this.setSessionLog(session.getSessionLog());
        this.setLog(session.getLog());
        this.setCommitManager(new CommitManager(this));
        this.setTransactionMutex(new ConcurrencyManager());
        this.getCommitManager().setCommitOrder(session.getCommitManager().getCommitOrder());
        if (session.hasExternalTransactionController()) {
            session.getExternalTransactionController().registerSynchronizationListener(this, session);
        }
        if (this.unitOfWorkChangeSet != null) {
            this.fixRemoteChangeSet(this.unitOfWorkChangeSet, null, this);
        }
        if (this.cumulativeUOWChangeSet != null) {
            this.fixRemoteChangeSet(this.cumulativeUOWChangeSet, null, this);
        }
    }

    protected void fixRemoteChangeSet(UnitOfWorkChangeSet uowChangeSet, Map cloneMap, AbstractSession session) {
        ClassDescriptor descriptor;
        if (uowChangeSet == null) {
            return;
        }
        uowChangeSet.setSession(session);
        for (Map.Entry<Class, Map<ObjectChangeSet, ObjectChangeSet>> entry : uowChangeSet.getObjectChanges().entrySet()) {
            descriptor = this.getDescriptor(entry.getKey());
            for (ObjectChangeSet objectChangeSet : entry.getValue().values()) {
                objectChangeSet.setDescriptor(descriptor);
                objectChangeSet.setClassType(entry.getKey());
            }
        }
        for (Map.Entry<Class, Map<ObjectChangeSet, ObjectChangeSet>> entry : uowChangeSet.getNewObjectChangeSets().entrySet()) {
            descriptor = this.getDescriptor(entry.getKey());
            for (ObjectChangeSet objectChangeSet : entry.getValue().values()) {
                objectChangeSet.setDescriptor(descriptor);
                objectChangeSet.setClassType(entry.getKey());
            }
        }
        if (cloneMap == null) {
            for (Map.Entry<Object, Object> entry : uowChangeSet.getCloneToObjectChangeSet().entrySet()) {
                Object clone = entry.getKey();
                ObjectChangeSet objectChangeSet = (ObjectChangeSet)entry.getValue();
                objectChangeSet.postSerialize(clone, uowChangeSet, session);
            }
        } else {
            int n = uowChangeSet.getCloneToObjectChangeSet().size();
            IdentityHashMap<Object, ObjectChangeSet> newCloneToObjectChangeSet = new IdentityHashMap<Object, ObjectChangeSet>(n);
            IdentityHashMap<ObjectChangeSet, Object> newObjectChangeSetToUOWClone = new IdentityHashMap<ObjectChangeSet, Object>(n);
            for (Map.Entry entry : uowChangeSet.getCloneToObjectChangeSet().entrySet()) {
                Object clone = cloneMap.get(entry.getKey());
                if (clone == null) {
                    clone = entry.getKey();
                }
                ObjectChangeSet changeSet = (ObjectChangeSet)entry.getValue();
                changeSet.postSerialize(clone, uowChangeSet, session);
                newCloneToObjectChangeSet.put(clone, changeSet);
                newObjectChangeSetToUOWClone.put(changeSet, clone);
            }
            uowChangeSet.setCloneToObjectChangeSet(newCloneToObjectChangeSet);
            uowChangeSet.setObjectChangeSetToUOWClone(newObjectChangeSetToUOWClone);
        }
    }

    protected void setIsOnClient(boolean isOnClient) {
        this.isOnClient = isOnClient;
    }

    protected void setNewObjectsCache(List newObjectsCache) {
        this.newObjectsCache = newObjectsCache;
    }

    public void setParentSessionController(RemoteSessionController parentSessionController) {
        this.parentSessionController = parentSessionController;
    }

    protected void setUnregisteredNewObjectsCache(List unregisteredNewObjectsCache) {
        this.unregisteredNewObjectsCache = unregisteredNewObjectsCache;
    }

    @Override
    public String toString() {
        return String.valueOf(Helper.getShortClassName(this.getClass())) + "()";
    }

    @Override
    public boolean verifyDelete(Object domainObject) {
        return this.getParent().verifyDelete(domainObject);
    }
}

