/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.proxy.util.compression;

import java.nio.ByteBuffer;

public class BitUtils {
    public static final int NBITS_PER_BYTE = 8;
    private static int[] mask1 = new int[]{255, 127, 63, 31, 15, 7, 3, 1};
    private static int[] mask2;

    static {
        int[] nArray = new int[8];
        nArray[1] = 1;
        nArray[2] = 3;
        nArray[3] = 7;
        nArray[4] = 15;
        nArray[5] = 31;
        nArray[6] = 63;
        nArray[7] = 127;
        mask2 = nArray;
    }

    public static final int getBit(ByteBuffer in, int pos) {
        return in.get(pos >> 3) & 1 << pos % 8;
    }

    public static final void packBits(byte[] dest, int destpos, byte[] src, int srcpos, int len) {
        int destbytepos = destpos >> 3;
        int offset = destpos - (destbytepos << 3);
        int m1 = mask1[offset];
        int m2 = mask2[offset];
        int endpos = len == 0 ? srcpos : srcpos + (len >> 3) + 1;
        while (srcpos < endpos) {
            byte srcbyte = src[srcpos++];
            int cbyte = dest[destbytepos];
            cbyte &= m2;
            dest[destbytepos++] = (byte)(cbyte |= (srcbyte & m1) << offset);
            dest[destbytepos] = (byte)(srcbyte >> 8 - offset);
        }
    }

    public static final void resetBit(ByteBuffer in, int pos) {
        in.put(pos >> 3, (byte)(in.get(pos >> 3) & ~(1 << pos % 8)));
    }

    public static final void setBit(ByteBuffer input, int pos) {
        input.put(pos >> 3, (byte)(input.get(pos >> 3) | 1 << pos % 8));
    }
}

