/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rm.lml.ui.views;

import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.ptp.internal.rm.lml.ui.messages.Messages;
import org.eclipse.ptp.rm.lml.core.LMLManager;
import org.eclipse.ptp.rm.lml.core.elements.InfoType;
import org.eclipse.ptp.rm.lml.core.elements.InfodataType;
import org.eclipse.ptp.rm.lml.core.events.ILguiAddedEvent;
import org.eclipse.ptp.rm.lml.core.events.ILguiRemovedEvent;
import org.eclipse.ptp.rm.lml.core.events.IMarkObjectEvent;
import org.eclipse.ptp.rm.lml.core.events.ISelectObjectEvent;
import org.eclipse.ptp.rm.lml.core.events.ITableFilterEvent;
import org.eclipse.ptp.rm.lml.core.events.ITableSortedEvent;
import org.eclipse.ptp.rm.lml.core.events.IUnmarkObjectEvent;
import org.eclipse.ptp.rm.lml.core.events.IUnselectedObjectEvent;
import org.eclipse.ptp.rm.lml.core.events.IViewUpdateEvent;
import org.eclipse.ptp.rm.lml.core.listeners.ILMLListener;
import org.eclipse.ptp.rm.lml.core.model.OIDToInformation;
import org.eclipse.ptp.rm.lml.internal.ui.UIUtils;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.part.ViewPart;

public class InfoView
extends ViewPart {
    private final LMLManager lmlManager = LMLManager.getInstance();
    private final ILMLListener lmlListener = new LMLListener();
    private Composite parent;
    private Widget content = null;
    private IMenuManager viewMenuManager;
    private ActionContributionItem showMessageOfTheDayActionItem;

    public void createPartControl(Composite parent) {
        this.lmlManager.addListener(this.lmlListener, ((Object)((Object)this)).getClass().getName());
        this.parent = parent;
        parent.setLayout((Layout)new FillLayout(512));
        parent.setBackground(parent.getDisplay().getSystemColor(1));
        this.viewMenuManager = this.getViewSite().getActionBars().getMenuManager();
        Action showMessageOfTheDayAction = new Action(Messages.InfoView_Show_message_of_the_day){

            public void run() {
                InfoView.this.removeLabelText();
                InfoView.this.setNewLabelText("motd", null);
            }
        };
        this.showMessageOfTheDayActionItem = new ActionContributionItem((IAction)showMessageOfTheDayAction);
        this.viewMenuManager.add((IContributionItem)this.showMessageOfTheDayActionItem);
        this.showMessageOfTheDayActionItem.getAction().setEnabled(false);
        parent.layout();
    }

    public void dispose() {
        this.lmlManager.removeListener(this.lmlListener);
    }

    public void removeLabelText() {
        if (this.content != null && !this.content.isDisposed()) {
            this.content.dispose();
        }
        this.content = null;
        this.showMessageOfTheDayActionItem.getAction().setEnabled(false);
        this.parent.layout();
    }

    public void setFocus() {
    }

    public void setNewLabelText(String type, String oid) {
        if (type.equals("motd")) {
            this.content = new Text(this.parent, 16906);
            ((Text)this.content).setBackground(this.parent.getDisplay().getSystemColor(1));
            String[] message = this.lmlManager.getSelectedLguiItem().getMessageOfTheDay();
            if (message[0].length() == 0) {
                return;
            }
            if (message[0].equals("error")) {
                ((Text)this.content).append(message[1]);
            } else if (message[0].equals("motd")) {
                ((Text)this.content).append(message[1]);
            }
        } else if (type.equals("job")) {
            InfoType infoType;
            this.content = new Table(this.parent, 67584);
            ((Table)this.content).setLinesVisible(true);
            ((Table)this.content).setHeaderVisible(true);
            String[] titles = new String[]{"Key", "Value"};
            String[] stringArray = titles;
            int n = titles.length;
            int n2 = 0;
            while (n2 < n) {
                String title = stringArray[n2];
                TableColumn column = new TableColumn((Table)this.content, 0);
                column.setText(title);
                column.setWidth(100);
                ++n2;
            }
            OIDToInformation info = this.lmlManager.getSelectedLguiItem().getOIDToInformation();
            if (info != null && (infoType = info.getInfoByOid(oid)) != null) {
                for (InfodataType infodata : infoType.getData()) {
                    TableItem item = new TableItem((Table)this.content, 0);
                    item.setText(0, infodata.getKey());
                    item.setText(1, infodata.getValue());
                }
            }
            TableColumn[] tableColumnArray = ((Table)this.content).getColumns();
            int n3 = tableColumnArray.length;
            n = 0;
            while (n < n3) {
                TableColumn column = tableColumnArray[n];
                column.pack();
                ++n;
            }
        } else if (type.equals("node")) {
            this.content = new Text(this.parent, 16970);
            ((Text)this.content).setBackground(this.parent.getDisplay().getSystemColor(1));
            ((Text)this.content).append(Messages.InfoView_Node);
        }
        this.showMessageOfTheDayActionItem.getAction().setEnabled(true);
        this.parent.layout();
    }

    public class LMLListener
    implements ILMLListener {
        public void handleEvent(ILguiAddedEvent event) {
            UIUtils.safeRunSyncInUIThread((ISafeRunnable)new SafeRunnable(){

                public void run() throws Exception {
                    if (InfoView.this.parent != null && InfoView.this.content == null) {
                        InfoView.this.setNewLabelText("motd", null);
                    }
                }
            });
        }

        public void handleEvent(ILguiRemovedEvent event) {
            UIUtils.safeRunSyncInUIThread((ISafeRunnable)new SafeRunnable(){

                public void run() throws Exception {
                    if (InfoView.this.parent != null && InfoView.this.content != null) {
                        InfoView.this.removeLabelText();
                    }
                }
            });
        }

        public void handleEvent(final IMarkObjectEvent event) {
            UIUtils.safeRunSyncInUIThread((ISafeRunnable)new SafeRunnable(){

                public void run() throws Exception {
                    if (InfoView.this.parent != null) {
                        InfoView.this.removeLabelText();
                        InfoView.this.setNewLabelText("job", event.getOid());
                    }
                }
            });
        }

        public void handleEvent(ISelectObjectEvent event) {
        }

        public void handleEvent(ITableFilterEvent event) {
        }

        public void handleEvent(ITableSortedEvent event) {
        }

        public void handleEvent(IUnmarkObjectEvent event) {
        }

        public void handleEvent(IUnselectedObjectEvent event) {
        }

        public void handleEvent(IViewUpdateEvent event) {
        }
    }
}

