/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageDataProvider;
import org.eclipse.swt.graphics.ImageFileNameProvider;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

public class DPIUtil {
    private static final int DPI_ZOOM_100 = 96;
    private static int deviceZoom = 100;
    private static int nativeDeviceZoom = 100;
    private static AutoScaleMethod autoScaleMethodSetting = AutoScaleMethod.AUTO;
    private static AutoScaleMethod autoScaleMethod = AutoScaleMethod.NEAREST;
    private static String autoScaleValue;
    private static boolean useCairoAutoScale;
    private static final String SWT_AUTOSCALE = "swt.autoScale";
    private static final String SWT_AUTOSCALE_METHOD = "swt.autoScale.method";

    static {
        useCairoAutoScale = false;
        autoScaleValue = System.getProperty(SWT_AUTOSCALE);
        String value = System.getProperty(SWT_AUTOSCALE_METHOD);
        if (value != null) {
            if (AutoScaleMethod.NEAREST.name().equalsIgnoreCase(value)) {
                autoScaleMethod = autoScaleMethodSetting = AutoScaleMethod.NEAREST;
            } else if (AutoScaleMethod.SMOOTH.name().equalsIgnoreCase(value)) {
                autoScaleMethod = autoScaleMethodSetting = AutoScaleMethod.SMOOTH;
            }
        }
    }

    public static ImageData autoScaleDown(Device device, ImageData imageData) {
        if (deviceZoom == 100 || imageData == null || device != null && !device.isAutoScalable()) {
            return imageData;
        }
        float scaleFactor = 1.0f / DPIUtil.getScalingFactor();
        return DPIUtil.autoScaleImageData(device, imageData, scaleFactor);
    }

    public static int[] autoScaleDown(int[] pointArray) {
        if (deviceZoom == 100 || pointArray == null) {
            return pointArray;
        }
        float scaleFactor = DPIUtil.getScalingFactor();
        int[] returnArray = new int[pointArray.length];
        int i = 0;
        while (i < pointArray.length) {
            returnArray[i] = Math.round((float)pointArray[i] / scaleFactor);
            ++i;
        }
        return returnArray;
    }

    public static int[] autoScaleDown(Drawable drawable, int[] pointArray) {
        if (drawable != null && !drawable.isAutoScalable()) {
            return pointArray;
        }
        return DPIUtil.autoScaleDown(pointArray);
    }

    public static float[] autoScaleDown(float[] size) {
        if (deviceZoom == 100 || size == null) {
            return size;
        }
        float scaleFactor = DPIUtil.getScalingFactor();
        float[] scaledSize = new float[size.length];
        int i = 0;
        while (i < scaledSize.length) {
            scaledSize[i] = size[i] / scaleFactor;
            ++i;
        }
        return scaledSize;
    }

    public static float[] autoScaleDown(Drawable drawable, float[] size) {
        if (drawable != null && !drawable.isAutoScalable()) {
            return size;
        }
        return DPIUtil.autoScaleDown(size);
    }

    public static int autoScaleDown(int size) {
        if (deviceZoom == 100 || size == -1) {
            return size;
        }
        float scaleFactor = DPIUtil.getScalingFactor();
        return Math.round((float)size / scaleFactor);
    }

    public static int autoScaleDown(Drawable drawable, int size) {
        if (drawable != null && !drawable.isAutoScalable()) {
            return size;
        }
        return DPIUtil.autoScaleDown(size);
    }

    public static float autoScaleDown(float size) {
        if (deviceZoom == 100 || size == -1.0f) {
            return size;
        }
        float scaleFactor = DPIUtil.getScalingFactor();
        return size / scaleFactor;
    }

    public static float autoScaleDown(Drawable drawable, float size) {
        if (drawable != null && !drawable.isAutoScalable()) {
            return size;
        }
        return DPIUtil.autoScaleDown(size);
    }

    public static Point autoScaleDown(Point point) {
        if (deviceZoom == 100 || point == null) {
            return point;
        }
        float scaleFactor = DPIUtil.getScalingFactor();
        Point scaledPoint = new Point(0, 0);
        scaledPoint.x = Math.round((float)point.x / scaleFactor);
        scaledPoint.y = Math.round((float)point.y / scaleFactor);
        return scaledPoint;
    }

    public static Point autoScaleDown(Drawable drawable, Point point) {
        if (drawable != null && !drawable.isAutoScalable()) {
            return point;
        }
        return DPIUtil.autoScaleDown(point);
    }

    public static Rectangle autoScaleDown(Rectangle rect) {
        if (deviceZoom == 100 || rect == null) {
            return rect;
        }
        Rectangle scaledRect = new Rectangle(0, 0, 0, 0);
        Point scaledTopLeft = DPIUtil.autoScaleDown(new Point(rect.x, rect.y));
        Point scaledBottomRight = DPIUtil.autoScaleDown(new Point(rect.x + rect.width, rect.y + rect.height));
        scaledRect.x = scaledTopLeft.x;
        scaledRect.y = scaledTopLeft.y;
        scaledRect.width = scaledBottomRight.x - scaledTopLeft.x;
        scaledRect.height = scaledBottomRight.y - scaledTopLeft.y;
        return scaledRect;
    }

    public static Rectangle autoScaleDown(Drawable drawable, Rectangle rect) {
        if (drawable != null && !drawable.isAutoScalable()) {
            return rect;
        }
        return DPIUtil.autoScaleDown(rect);
    }

    public static ImageData autoScaleImageData(Device device, ImageData imageData, int targetZoom, int currentZoom) {
        if (imageData == null || targetZoom == currentZoom || device != null && !device.isAutoScalable()) {
            return imageData;
        }
        float scaleFactor = (float)targetZoom / (float)currentZoom;
        return DPIUtil.autoScaleImageData(device, imageData, scaleFactor);
    }

    private static ImageData autoScaleImageData(Device device, ImageData imageData, float scaleFactor) {
        int width = imageData.width;
        int height = imageData.height;
        int scaledWidth = Math.round((float)width * scaleFactor);
        int scaledHeight = Math.round((float)height * scaleFactor);
        switch (autoScaleMethod) {
            case SMOOTH: {
                Image original = new Image(device, zoom -> imageData);
                ImageData resultData = new ImageData(scaledWidth, scaledHeight, 24, new PaletteData(255, 65280, 0xFF0000));
                resultData.alphaData = new byte[scaledWidth * scaledHeight];
                Image resultImage = new Image(device, zoom -> resultData);
                GC gc = new GC(resultImage);
                gc.setAntialias(1);
                gc.drawImage(original, 0, 0, DPIUtil.autoScaleDown(width), DPIUtil.autoScaleDown(height), 0, 0, Math.round(DPIUtil.autoScaleDown((float)width * scaleFactor)), Math.round(DPIUtil.autoScaleDown((float)height * scaleFactor)));
                gc.dispose();
                original.dispose();
                ImageData result = resultImage.getImageData(DPIUtil.getDeviceZoom());
                resultImage.dispose();
                return result;
            }
        }
        return imageData.scaledTo(scaledWidth, scaledHeight);
    }

    public static Rectangle autoScaleBounds(Rectangle rect, int targetZoom, int currentZoom) {
        if (deviceZoom == 100 || rect == null || targetZoom == currentZoom) {
            return rect;
        }
        float scaleFactor = (float)targetZoom / (float)currentZoom;
        Rectangle returnRect = new Rectangle(0, 0, 0, 0);
        returnRect.x = Math.round((float)rect.x * scaleFactor);
        returnRect.y = Math.round((float)rect.y * scaleFactor);
        returnRect.width = Math.round((float)rect.width * scaleFactor);
        returnRect.height = Math.round((float)rect.height * scaleFactor);
        return returnRect;
    }

    public static ImageData autoScaleUp(Device device, ImageData imageData) {
        if (deviceZoom == 100 || imageData == null || device != null && !device.isAutoScalable()) {
            return imageData;
        }
        float scaleFactor = (float)deviceZoom / 100.0f;
        return DPIUtil.autoScaleImageData(device, imageData, scaleFactor);
    }

    public static int[] autoScaleUp(int[] pointArray) {
        if (deviceZoom == 100 || pointArray == null) {
            return pointArray;
        }
        float scaleFactor = DPIUtil.getScalingFactor();
        int[] returnArray = new int[pointArray.length];
        int i = 0;
        while (i < pointArray.length) {
            returnArray[i] = Math.round((float)pointArray[i] * scaleFactor);
            ++i;
        }
        return returnArray;
    }

    public static int[] autoScaleUp(Drawable drawable, int[] pointArray) {
        if (drawable != null && !drawable.isAutoScalable()) {
            return pointArray;
        }
        return DPIUtil.autoScaleUp(pointArray);
    }

    public static int autoScaleUp(int size) {
        if (deviceZoom == 100 || size == -1) {
            return size;
        }
        float scaleFactor = DPIUtil.getScalingFactor();
        return Math.round((float)size * scaleFactor);
    }

    public static int autoScaleUpUsingNativeDPI(int size) {
        if (nativeDeviceZoom == 100 || size == -1) {
            return size;
        }
        float nativeScaleFactor = (float)nativeDeviceZoom / 100.0f;
        return Math.round((float)size * nativeScaleFactor);
    }

    public static int autoScaleUp(Drawable drawable, int size) {
        if (drawable != null && !drawable.isAutoScalable()) {
            return size;
        }
        return DPIUtil.autoScaleUp(size);
    }

    public static float autoScaleUp(float size) {
        if (deviceZoom == 100 || size == -1.0f) {
            return size;
        }
        float scaleFactor = DPIUtil.getScalingFactor();
        return size * scaleFactor;
    }

    public static float autoScaleUp(Drawable drawable, float size) {
        if (drawable != null && !drawable.isAutoScalable()) {
            return size;
        }
        return DPIUtil.autoScaleUp(size);
    }

    public static Point autoScaleUp(Point point) {
        if (deviceZoom == 100 || point == null) {
            return point;
        }
        float scaleFactor = DPIUtil.getScalingFactor();
        Point scaledPoint = new Point(0, 0);
        scaledPoint.x = Math.round((float)point.x * scaleFactor);
        scaledPoint.y = Math.round((float)point.y * scaleFactor);
        return scaledPoint;
    }

    public static Point autoScaleUp(Drawable drawable, Point point) {
        if (drawable != null && !drawable.isAutoScalable()) {
            return point;
        }
        return DPIUtil.autoScaleUp(point);
    }

    public static Rectangle autoScaleUp(Rectangle rect) {
        if (deviceZoom == 100 || rect == null) {
            return rect;
        }
        Rectangle scaledRect = new Rectangle(0, 0, 0, 0);
        Point scaledTopLeft = DPIUtil.autoScaleUp(new Point(rect.x, rect.y));
        Point scaledBottomRight = DPIUtil.autoScaleUp(new Point(rect.x + rect.width, rect.y + rect.height));
        scaledRect.x = scaledTopLeft.x;
        scaledRect.y = scaledTopLeft.y;
        scaledRect.width = scaledBottomRight.x - scaledTopLeft.x;
        scaledRect.height = scaledBottomRight.y - scaledTopLeft.y;
        return scaledRect;
    }

    public static Rectangle autoScaleUp(Drawable drawable, Rectangle rect) {
        if (drawable != null && !drawable.isAutoScalable()) {
            return rect;
        }
        return DPIUtil.autoScaleUp(rect);
    }

    private static float getScalingFactor() {
        if (useCairoAutoScale) {
            return 1.0f;
        }
        return (float)deviceZoom / 100.0f;
    }

    public static int mapDPIToZoom(int dpi) {
        double zoom = (double)dpi * 100.0 / 96.0;
        int roundedZoom = (int)Math.round(zoom);
        return roundedZoom;
    }

    public static ImageData validateAndGetImageDataAtZoom(ImageDataProvider provider, int zoom, boolean[] found) {
        ImageData data;
        if (provider == null) {
            SWT.error(4);
        }
        boolean bl = found[0] = (data = provider.getImageData(zoom)) != null;
        if (zoom != 100 && !found[0]) {
            data = provider.getImageData(100);
        }
        if (data == null) {
            SWT.error(5, null, ": ImageDataProvider [" + String.valueOf(provider) + "] returns null ImageData at 100% zoom.");
        }
        return data;
    }

    public static String validateAndGetImagePathAtZoom(ImageFileNameProvider provider, int zoom, boolean[] found) {
        String filename;
        if (provider == null) {
            SWT.error(4);
        }
        boolean bl = found[0] = (filename = provider.getImagePath(zoom)) != null;
        if (zoom != 100 && !found[0]) {
            filename = provider.getImagePath(100);
        }
        if (filename == null) {
            SWT.error(5, null, ": ImageFileNameProvider [" + String.valueOf(provider) + "] returns null filename at 100% zoom.");
        }
        return filename;
    }

    public static int getDeviceZoom() {
        return deviceZoom;
    }

    public static void setDeviceZoom(int nativeDeviceZoom) {
        int deviceZoom;
        DPIUtil.nativeDeviceZoom = nativeDeviceZoom;
        DPIUtil.deviceZoom = deviceZoom = DPIUtil.getZoomForAutoscaleProperty(nativeDeviceZoom);
        System.setProperty("org.eclipse.swt.internal.deviceZoom", Integer.toString(deviceZoom));
        if (deviceZoom != 100 && autoScaleMethodSetting == AutoScaleMethod.AUTO) {
            autoScaleMethod = deviceZoom / 100 * 100 == deviceZoom || !"gtk".equals(SWT.getPlatform()) ? AutoScaleMethod.NEAREST : AutoScaleMethod.SMOOTH;
        }
    }

    public static void setUseCairoAutoScale(boolean cairoAutoScale) {
        useCairoAutoScale = cairoAutoScale;
    }

    public static boolean useCairoAutoScale() {
        return useCairoAutoScale;
    }

    public static int getZoomForAutoscaleProperty(int nativeDeviceZoom) {
        int zoom = 0;
        if (autoScaleValue != null) {
            if ("false".equalsIgnoreCase(autoScaleValue)) {
                zoom = 100;
            } else if ("half".equalsIgnoreCase(autoScaleValue)) {
                zoom = (int)Math.rint((double)nativeDeviceZoom / 50.0) * 50;
            } else if ("quarter".equalsIgnoreCase(autoScaleValue)) {
                zoom = Math.round((float)nativeDeviceZoom / 25.0f) * 25;
            } else if ("exact".equalsIgnoreCase(autoScaleValue)) {
                zoom = nativeDeviceZoom;
            } else {
                try {
                    int zoomValue = Integer.parseInt(autoScaleValue);
                    zoom = Math.max(Math.min(zoomValue, 1600), 25);
                }
                catch (NumberFormatException numberFormatException) {}
            }
        }
        if (zoom == 0) {
            zoom = Math.max((nativeDeviceZoom + 25) / 100 * 100, 100);
        }
        return zoom;
    }

    public static final class AutoScaleImageDataProvider
    implements ImageDataProvider {
        Device device;
        ImageData imageData;
        int currentZoom;

        public AutoScaleImageDataProvider(Device device, ImageData data, int zoom) {
            this.device = device;
            this.imageData = data;
            this.currentZoom = zoom;
        }

        @Override
        public ImageData getImageData(int zoom) {
            return DPIUtil.autoScaleImageData(this.device, this.imageData, zoom, this.currentZoom);
        }
    }

    private static enum AutoScaleMethod {
        AUTO,
        NEAREST,
        SMOOTH;

    }
}

