/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.locator.delegates;

import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerNode;
import org.eclipse.tcf.te.tcf.locator.utils.SimulatorUtils;

public class PeerNodeValidationDelegate
implements IPeerNode.IDelegate {
    @Override
    public boolean isValid(final IPeerNode peerNode) {
        SimulatorUtils.Result result;
        final AtomicBoolean valid = new AtomicBoolean(true);
        Protocol.invokeAndWait((Runnable)new Runnable(){

            @Override
            public void run() {
                String transport = peerNode.getPeer().getTransportName();
                if (transport == null) {
                    valid.set(false);
                } else {
                    String ip = (String)peerNode.getPeer().getAttributes().get("Host");
                    String port = (String)peerNode.getPeer().getAttributes().get("Port");
                    String autoPortString = (String)peerNode.getPeer().getAttributes().get("autoPort");
                    boolean autoPort = Boolean.parseBoolean(autoPortString);
                    if (("TCP".equals(transport) || "SSL".equals(transport)) && (ip == null || !autoPort && port == null)) {
                        valid.set(false);
                    }
                }
            }
        });
        if (valid.get() && (result = SimulatorUtils.getSimulatorService(peerNode)) != null) {
            valid.set(result.service.isValidConfig((Object)peerNode, result.settings, true));
        }
        return valid.get();
    }

    @Override
    public boolean isVisible(IPeerNode peerNode) {
        SimulatorUtils.Result result;
        return !SimulatorUtils.isSimulatorEnabled(peerNode) || (result = SimulatorUtils.getSimulatorService(peerNode)) != null && result.service != null;
    }
}

