/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.locator.listener;

import org.eclipse.core.runtime.Assert;
import org.eclipse.tcf.protocol.IPeer;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.services.ILocator;
import org.eclipse.tcf.te.runtime.utils.net.IPAddressUtil;
import org.eclipse.tcf.te.tcf.locator.activator.CoreBundleActivator;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.ILocatorModel;
import org.eclipse.tcf.te.tcf.locator.interfaces.services.ILocatorModelLookupService;
import org.eclipse.tcf.te.tcf.locator.interfaces.services.ILocatorModelUpdateService;

public final class LocatorListener
implements ILocator.LocatorListener {
    final ILocatorModel model;

    public LocatorListener(ILocatorModel model) {
        Assert.isNotNull((Object)model);
        this.model = model;
    }

    private boolean isFiltered(IPeer peer) {
        boolean filtered;
        boolean bl = filtered = peer == null;
        if (!filtered) {
            String value = (String)peer.getAttributes().get("ValueAdd");
            boolean isValueAdd = value != null && ("1".equals(value.trim()) || Boolean.parseBoolean(value.trim()));
            filtered |= isValueAdd;
            filtered |= peer.getName() != null && (peer.getName().endsWith("Command Server") || peer.getName().endsWith("CLI Server"));
        }
        return filtered;
    }

    public void peerAdded(IPeer peer) {
        Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
        if (CoreBundleActivator.getTraceHandler().isSlotEnabled(0, "trace/locatorListener")) {
            CoreBundleActivator.getTraceHandler().trace("LocatorListener.peerAdded( " + (peer != null ? peer.getID() : null) + " )", "trace/locatorListener", (Object)this);
        }
        if (this.isFiltered(peer)) {
            return;
        }
        if (this.model != null && peer != null) {
            String clientID;
            IPeer lkupPeer = this.model.getService(ILocatorModelLookupService.class).lkupPeerById(peer.getID());
            if (lkupPeer == null && (clientID = (String)peer.getAttributes().get("ClientID")) != null) {
                lkupPeer = this.model.getService(ILocatorModelLookupService.class).lkupPeerById(clientID);
            }
            if (lkupPeer == null && (lkupPeer = this.model.validatePeer(peer)) != null) {
                this.model.getService(ILocatorModelUpdateService.class).add(lkupPeer);
            }
        }
    }

    public void peerChanged(IPeer peer) {
        Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
        if (CoreBundleActivator.getTraceHandler().isSlotEnabled(0, "trace/locatorListener")) {
            CoreBundleActivator.getTraceHandler().trace("LocatorListener.peerChanged( " + (peer != null ? peer.getID() : null) + " )", "trace/locatorListener", (Object)this);
        }
        if (this.isFiltered(peer)) {
            return;
        }
        if (this.model != null && peer != null) {
            String clientID;
            IPeer lkupPeer = this.model.getService(ILocatorModelLookupService.class).lkupPeerById(peer.getID());
            if (lkupPeer == null && (clientID = (String)peer.getAttributes().get("ClientID")) != null) {
                lkupPeer = this.model.getService(ILocatorModelLookupService.class).lkupPeerById(clientID);
            }
            if (lkupPeer != null) {
                this.model.getService(ILocatorModelUpdateService.class).update(lkupPeer, peer);
            }
        }
    }

    public void peerRemoved(String id) {
        Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
        if (CoreBundleActivator.getTraceHandler().isSlotEnabled(0, "trace/locatorListener")) {
            CoreBundleActivator.getTraceHandler().trace("LocatorListener.peerRemoved( " + id + " )", "trace/locatorListener", (Object)this);
        }
        if (this.model != null && id != null) {
            IPeer lkupPeer = this.model.getService(ILocatorModelLookupService.class).lkupPeerById(id);
            if (lkupPeer == null) {
                int beginIndex = id.indexOf(58);
                int endIndex = id.lastIndexOf(58);
                String ip = id.substring(beginIndex + 1, endIndex);
                String loopback = IPAddressUtil.getInstance().getIPv4LoopbackAddress();
                if ("".equals(ip)) {
                    ip = loopback;
                } else if (IPAddressUtil.getInstance().isLocalHost(ip)) {
                    ip = loopback;
                }
                StringBuilder newId = new StringBuilder();
                newId.append(id.substring(0, beginIndex));
                newId.append(':');
                newId.append(ip);
                newId.append(':');
                newId.append(id.substring(endIndex + 1));
                lkupPeer = this.model.getService(ILocatorModelLookupService.class).lkupPeerById(newId.toString());
            }
            if (lkupPeer != null) {
                this.model.getService(ILocatorModelUpdateService.class).remove(lkupPeer);
            }
        }
    }

    public void peerHeartBeat(String id) {
        Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
        if (CoreBundleActivator.getTraceHandler().isSlotEnabled(0, "trace/locatorListener")) {
            CoreBundleActivator.getTraceHandler().trace("LocatorListener.peerHeartBeat( " + id + " )", "trace/locatorListener", (Object)this);
        }
    }
}

