/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.locator.services;

import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.tcf.protocol.IPeer;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.te.runtime.model.interfaces.IModelNode;
import org.eclipse.tcf.te.tcf.core.util.persistence.PeerDataHelper;
import org.eclipse.tcf.te.tcf.locator.interfaces.ILocatorModelListener;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.ILocatorModel;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.ILocatorNode;
import org.eclipse.tcf.te.tcf.locator.interfaces.services.ILocatorModelLookupService;
import org.eclipse.tcf.te.tcf.locator.interfaces.services.ILocatorModelUpdateService;
import org.eclipse.tcf.te.tcf.locator.model.ModelManager;
import org.eclipse.tcf.te.tcf.locator.nodes.LocatorNode;
import org.eclipse.tcf.te.tcf.locator.services.AbstractLocatorModelService;

public class LocatorModelUpdateService
extends AbstractLocatorModelService
implements ILocatorModelUpdateService {
    public LocatorModelUpdateService(ILocatorModel parentModel) {
        super(parentModel);
    }

    @Override
    public ILocatorNode add(IPeer peer) {
        return this.add(peer, false);
    }

    @Override
    public ILocatorNode add(IPeer peer, boolean isStatic) {
        ILocatorModelListener[] listeners;
        int n;
        Assert.isNotNull((Object)peer);
        Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
        String encProxies = (String)peer.getAttributes().get("Proxies");
        ILocatorNode locatorNode = null;
        if (encProxies == null || encProxies.trim().length() == 0) {
            Map locatorNodes = (Map)this.getLocatorModel().getAdapter(Map.class);
            Assert.isNotNull((Object)locatorNodes);
            ILocatorModelLookupService lkup = ModelManager.getLocatorModel().getService(ILocatorModelLookupService.class);
            locatorNode = lkup.lkupLocatorNode(peer);
            if (locatorNode == null) {
                locatorNode = new LocatorNode(peer, isStatic);
                locatorNodes.put(peer.getID(), locatorNode);
            } else if (isStatic) {
                locatorNode.setProperty("staticInstance", peer);
            }
        } else {
            IPeer[] proxies = PeerDataHelper.decodePeerList((String)encProxies);
            ILocatorNode parent = null;
            IPeer[] iPeerArray = proxies;
            int n2 = proxies.length;
            n = 0;
            while (n < n2) {
                IPeer proxy = iPeerArray[n];
                ILocatorModelLookupService lkup = ModelManager.getLocatorModel().getService(ILocatorModelLookupService.class);
                ILocatorNode proxyNode = lkup.lkupLocatorNode(proxy);
                if (proxyNode == null) {
                    proxyNode = new LocatorNode(proxy, true);
                    if (parent == null) {
                        Map locatorNodes = (Map)this.getLocatorModel().getAdapter(Map.class);
                        Assert.isNotNull((Object)locatorNodes);
                        locatorNodes.put(proxy.getID(), proxyNode);
                    } else {
                        parent.add((IModelNode)proxyNode);
                    }
                    parent = proxyNode;
                } else {
                    parent = proxyNode;
                }
                ++n;
            }
            ILocatorModelLookupService lkup = ModelManager.getLocatorModel().getService(ILocatorModelLookupService.class);
            locatorNode = lkup.lkupLocatorNode(peer);
            if (locatorNode == null) {
                locatorNode = new LocatorNode(peer, true);
                parent.add((IModelNode)locatorNode);
            }
        }
        ILocatorModelListener[] iLocatorModelListenerArray = listeners = this.getLocatorModel().getListener();
        n = listeners.length;
        int n3 = 0;
        while (n3 < n) {
            ILocatorModelListener listener = iLocatorModelListenerArray[n3];
            listener.modelChanged(this.getLocatorModel(), locatorNode, true);
            ++n3;
        }
        return locatorNode;
    }

    @Override
    public ILocatorNode remove(IPeer peer) {
        ILocatorModelListener[] listeners;
        Assert.isNotNull((Object)peer);
        Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
        ILocatorModelLookupService lkup = ModelManager.getLocatorModel().getService(ILocatorModelLookupService.class);
        ILocatorNode locatorNode = lkup.lkupLocatorNode(peer);
        if (locatorNode != null) {
            ILocatorNode parent = (ILocatorNode)locatorNode.getParent(ILocatorNode.class);
            if (parent == null) {
                Map locatorNodes = (Map)this.getLocatorModel().getAdapter(Map.class);
                Assert.isNotNull((Object)locatorNodes);
                locatorNode = (ILocatorNode)locatorNodes.remove(peer.getID());
            } else {
                parent.remove((IModelNode)locatorNode, true);
            }
        }
        ILocatorModelListener[] iLocatorModelListenerArray = listeners = this.getLocatorModel().getListener();
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            ILocatorModelListener listener = iLocatorModelListenerArray[n2];
            listener.modelChanged(this.getLocatorModel(), locatorNode, false);
            ++n2;
        }
        return locatorNode;
    }

    @Override
    public ILocatorNode update(IPeer oldPeer, IPeer newPeer) {
        ILocatorModelListener[] listeners;
        Assert.isNotNull((Object)oldPeer);
        Assert.isNotNull((Object)newPeer);
        Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
        Map locatorNodes = (Map)this.getLocatorModel().getAdapter(Map.class);
        Assert.isNotNull((Object)locatorNodes);
        ILocatorNode oldLocatorNode = (ILocatorNode)locatorNodes.remove(oldPeer.getID());
        LocatorNode newLocatorNode = new LocatorNode(newPeer);
        locatorNodes.put(newPeer.getID(), newLocatorNode);
        ILocatorModelListener[] iLocatorModelListenerArray = listeners = this.getLocatorModel().getListener();
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            ILocatorModelListener listener = iLocatorModelListenerArray[n2];
            if (!oldPeer.getID().equals(newPeer.getID())) {
                listener.modelChanged(this.getLocatorModel(), oldLocatorNode, false);
                listener.modelChanged(this.getLocatorModel(), newLocatorNode, true);
            } else {
                listener.modelChanged(this.getLocatorModel(), newLocatorNode, false);
            }
            ++n2;
        }
        return newLocatorNode;
    }
}

