/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.locator.services.selection;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.runtime.Assert;
import org.eclipse.tcf.protocol.IPeer;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerNode;
import org.eclipse.tcf.te.tcf.locator.interfaces.services.IDefaultContextService;

public class RuntimeServiceContextFilter
implements IDefaultContextService.IContextFilter {
    protected final String[] serviceNames;
    protected final boolean useDisconnectedContexts;

    public RuntimeServiceContextFilter(String serviceName, boolean useDisconnectedContexts) {
        this.serviceNames = new String[]{serviceName};
        this.useDisconnectedContexts = useDisconnectedContexts;
    }

    public RuntimeServiceContextFilter(String[] serviceNames, boolean useDisconnectedContexts) {
        this.serviceNames = serviceNames;
        this.useDisconnectedContexts = useDisconnectedContexts;
    }

    @Override
    public boolean select(final IPeerNode peerNode) {
        Assert.isNotNull((Object)peerNode);
        final AtomicBoolean result = new AtomicBoolean(false);
        Protocol.invokeAndWait((Runnable)new Runnable(){

            @Override
            public void run() {
                String services = peerNode.getStringProperty("RemoteServices");
                if (services != null) {
                    List<String> list = Arrays.asList(services.split(",\\s*"));
                    boolean containsAll = true;
                    String[] stringArray = RuntimeServiceContextFilter.this.serviceNames;
                    int n = RuntimeServiceContextFilter.this.serviceNames.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String serviceName = stringArray[n2];
                        if (!(containsAll &= list.contains(serviceName))) break;
                        ++n2;
                    }
                    result.set(containsAll);
                    return;
                }
                if (RuntimeServiceContextFilter.this.useDisconnectedContexts) {
                    IPeer peer = peerNode.getPeer();
                    services = (String)peer.getAttributes().get("OfflineServices");
                    List<String> list = services != null ? Arrays.asList(services.split(",\\s*")) : Collections.EMPTY_LIST;
                    boolean containsAll = true;
                    String[] stringArray = RuntimeServiceContextFilter.this.serviceNames;
                    int n = RuntimeServiceContextFilter.this.serviceNames.length;
                    int n3 = 0;
                    while (n3 < n) {
                        String serviceName = stringArray[n3];
                        if (!(containsAll &= list.contains(serviceName))) break;
                        ++n3;
                    }
                    result.set(containsAll);
                }
            }
        });
        return result.get();
    }
}

