/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.locator.utils;

import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.tcf.protocol.IPeer;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.te.runtime.callback.Callback;
import org.eclipse.tcf.te.runtime.interfaces.callback.ICallback;
import org.eclipse.tcf.te.runtime.services.ServiceManager;
import org.eclipse.tcf.te.runtime.services.interfaces.IService;
import org.eclipse.tcf.te.runtime.services.interfaces.ISimulatorService;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerNode;

public final class SimulatorUtils {
    public static boolean isSimulatorEnabled(final IPeerNode peerNode) {
        Assert.isNotNull((Object)peerNode);
        final AtomicBoolean isEnabled = new AtomicBoolean(false);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                String subType = (String)peerNode.getPeer().getAttributes().get("SubType");
                if (subType != null) {
                    isEnabled.set(subType.equals("sim"));
                }
            }
        };
        if (Protocol.isDispatchThread()) {
            runnable.run();
        } else {
            Protocol.invokeAndWait((Runnable)runnable);
        }
        return isEnabled.get();
    }

    public static Result getSimulatorService(IPeerNode peerNode) {
        Assert.isNotNull((Object)peerNode);
        Result result = null;
        IPeer peer = peerNode.getPeer();
        if (peer != null && SimulatorUtils.isSimulatorEnabled(peerNode)) {
            IService[] services;
            String type = (String)peer.getAttributes().get("SimulatorType");
            IService[] iServiceArray = services = ServiceManager.getInstance().getServices((Object)peerNode, ISimulatorService.class, false);
            int n = services.length;
            int n2 = 0;
            while (n2 < n) {
                IService service = iServiceArray[n2];
                Assert.isTrue((boolean)(service instanceof ISimulatorService));
                String id = service.getId();
                if (id != null && id.equals(type)) {
                    result = new Result();
                    result.service = (ISimulatorService)service;
                    result.id = id;
                    result.settings = (String)peer.getAttributes().get("SimulatorProperties");
                    break;
                }
                ++n2;
            }
        }
        return result;
    }

    public static ISimulatorService getSimulatorService(Object context, String type) {
        IService[] services;
        Assert.isNotNull((Object)context);
        IService[] iServiceArray = services = ServiceManager.getInstance().getServices(context, ISimulatorService.class, false);
        int n = services.length;
        int n2 = 0;
        while (n2 < n) {
            IService service = iServiceArray[n2];
            Assert.isTrue((boolean)(service instanceof ISimulatorService));
            String id = service.getId();
            if (id != null && id.equals(type)) {
                return (ISimulatorService)service;
            }
            ++n2;
        }
        return null;
    }

    public static void start(final IPeerNode peerNode, final IProgressMonitor monitor, final ICallback callback) {
        Assert.isNotNull((Object)peerNode);
        Assert.isNotNull((Object)callback);
        final Result result = SimulatorUtils.getSimulatorService(peerNode);
        if (result != null && result.service != null) {
            result.service.isRunning((Object)peerNode, result.settings, (ICallback)new Callback(){

                protected void internalDone(Object caller, IStatus status) {
                    Object cbResult = this.getResult();
                    if (cbResult instanceof Boolean && !((Boolean)cbResult).booleanValue()) {
                        result.service.start((Object)peerNode, result.settings, (ICallback)new Callback(){

                            protected void internalDone(Object caller, IStatus status) {
                                SimulatorUtils.setUsedRunningSimulator(peerNode, false);
                                callback.setResult((Object)new Boolean(status.isOK()));
                                callback.done(caller, status);
                            }
                        }, monitor);
                    } else {
                        result.service.useRunning((Object)peerNode, result.settings, (ICallback)new Callback(){

                            protected void internalDone(Object caller, IStatus status) {
                                SimulatorUtils.setUsedRunningSimulator(peerNode, true);
                                callback.setResult((Object)new Boolean(status.isOK()));
                                callback.done(caller, status);
                            }
                        }, monitor);
                    }
                }
            }, monitor);
        } else {
            SimulatorUtils.setUsedRunningSimulator(peerNode, false);
            callback.setResult((Object)Boolean.FALSE);
            callback.done(null, Status.OK_STATUS);
        }
    }

    protected static void setUsedRunningSimulator(final IPeerNode peerNode, final boolean usedRunning) {
        Protocol.invokeAndWait((Runnable)new Runnable(){

            @Override
            public void run() {
                peerNode.setProperty(String.valueOf(SimulatorUtils.class.getSimpleName()) + ".usedRunning", usedRunning ? new Boolean(usedRunning) : null);
            }
        });
    }

    protected static boolean getUsedRunningSimulator(final IPeerNode peerNode) {
        final AtomicBoolean usedRunning = new AtomicBoolean(false);
        Protocol.invokeAndWait((Runnable)new Runnable(){

            @Override
            public void run() {
                usedRunning.set(peerNode.getBooleanProperty(String.valueOf(SimulatorUtils.class.getSimpleName()) + ".usedRunning"));
            }
        });
        return usedRunning.get();
    }

    public static void stop(final IPeerNode peerNode, final IProgressMonitor monitor, final ICallback callback) {
        Assert.isNotNull((Object)peerNode);
        Assert.isNotNull((Object)callback);
        final Result result = SimulatorUtils.getSimulatorService(peerNode);
        if (result != null && result.service != null && !SimulatorUtils.getUsedRunningSimulator(peerNode)) {
            SimulatorUtils.setUsedRunningSimulator(peerNode, false);
            result.service.isRunning((Object)peerNode, result.settings, (ICallback)new Callback(){

                protected void internalDone(Object caller, IStatus status) {
                    Object cbResult = this.getResult();
                    if (cbResult instanceof Boolean && ((Boolean)cbResult).booleanValue()) {
                        result.service.stop((Object)peerNode, result.settings, (ICallback)new Callback(callback){

                            protected void internalDone(Object caller, IStatus status) {
                                callback.done(caller, status);
                            }
                        }, monitor);
                    } else {
                        result.service.cleanup((Object)peerNode, result.settings);
                        callback.done(null, Status.OK_STATUS);
                    }
                }
            }, monitor);
        } else {
            SimulatorUtils.setUsedRunningSimulator(peerNode, false);
            callback.done(null, Status.OK_STATUS);
        }
    }

    public static class Result {
        public ISimulatorService service;
        public String id;
        public String settings;
    }
}

