/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.ui.swt.widgets;

import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.tcf.te.ui.swt.SWTControlUtil;
import org.eclipse.tcf.te.ui.swt.nls.Messages;

public class NoteCompositeHelper {
    public static final String NOTE_LABEL = Messages.NoteCompositeHelper_note_label;

    public static Composite createNoteComposite(Font font, Composite composite, String title, String message) {
        return NoteCompositeHelper.createNoteComposite(font, composite, title, message, -1);
    }

    public static Composite createNoteComposite(Font font, Composite composite, String title, String message, int minCharsPerLine) {
        NoteComposite messageComposite = new NoteComposite(composite, 0);
        GridLayout messageLayout = new GridLayout();
        messageLayout.numColumns = 2;
        messageLayout.marginWidth = 0;
        messageLayout.marginHeight = 0;
        messageComposite.setLayout((Layout)messageLayout);
        GridData layoutData = new GridData(256);
        if (composite.getLayout() instanceof GridLayout) {
            layoutData.horizontalSpan = ((GridLayout)composite.getLayout()).numColumns;
        }
        messageComposite.setLayoutData(layoutData);
        messageComposite.setFont(font);
        final Label noteLabel = new Label((Composite)messageComposite, 1);
        noteLabel.setText(title);
        noteLabel.setFont(JFaceResources.getFontRegistry().getBold("org.eclipse.jface.defaultfont"));
        noteLabel.setLayoutData((Object)new GridData(2));
        final IPropertyChangeListener fontListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if ("org.eclipse.jface.bannerfont".equals(event.getProperty())) {
                    noteLabel.setFont(JFaceResources.getFont((String)"org.eclipse.jface.bannerfont"));
                }
            }
        };
        JFaceResources.getFontRegistry().addListener(fontListener);
        noteLabel.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                JFaceResources.getFontRegistry().removeListener(fontListener);
            }
        });
        Label messageLabel = new Label((Composite)messageComposite, 64);
        messageLabel.setText(message);
        messageLabel.setFont(font);
        layoutData = new GridData(768);
        layoutData.widthHint = SWTControlUtil.convertWidthInCharsToPixels((Control)messageLabel, minCharsPerLine >= 20 ? minCharsPerLine : 65);
        messageLabel.setLayoutData((Object)layoutData);
        return messageComposite;
    }

    public static void setMessage(Composite messageComposite, String msg) {
        Control c;
        Control[] children;
        if (messageComposite instanceof NoteComposite && (children = messageComposite.getChildren()).length == 2 && (c = children[1]) instanceof Label) {
            ((Label)c).setText(msg);
            messageComposite.pack();
        }
    }

    private static class NoteComposite
    extends Composite {
        public NoteComposite(Composite parent, int style) {
            super(parent, style);
        }

        public void setEnabled(boolean enabled) {
            super.setEnabled(enabled);
            Control[] childs = this.getChildren();
            int iChild = 0;
            while (iChild < childs.length) {
                Control child = childs[iChild];
                child.setEnabled(enabled);
                ++iChild;
            }
        }
    }
}

