/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tips.ui.internal;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tips.core.internal.TipManager;
import org.eclipse.tips.ui.internal.DefaultTipManager;
import org.eclipse.tips.ui.internal.Messages;
import org.eclipse.tips.ui.internal.TipComposite;

public class TipDialog
extends Dialog {
    public static final int DEFAULT_STYLE = -1;
    private TipManager fTipManager;
    private TipComposite fTipComposite;
    private int fShellStyle;
    private IDialogSettings fDialogSettings;
    private ResourceManager resourceManager;

    public TipDialog(Shell parentShell, TipManager tipManager, int shellStyle, IDialogSettings dialogSettings) {
        super(parentShell);
        this.fTipManager = tipManager;
        this.fDialogSettings = dialogSettings;
        this.fShellStyle = shellStyle == -1 ? 1264 : shellStyle;
        this.resourceManager = new LocalResourceManager(JFaceResources.getResources(), (Control)parentShell);
    }

    protected IDialogSettings getDialogBoundsSettings() {
        return this.fDialogSettings;
    }

    protected Control createDialogArea(Composite parent) {
        this.fixLayout(parent);
        Composite area = (Composite)super.createDialogArea(parent);
        this.fixLayout(area);
        this.fTipComposite = new TipComposite(area, 0);
        this.fixLayout(this.fTipComposite);
        this.getShell().setText(Messages.TipDialog_0);
        this.fTipComposite.addDisposeListener(event -> {
            boolean bl = this.close();
        });
        return area;
    }

    protected void createButtonsForButtonBar(Composite pParent) {
    }

    protected Control createButtonBar(Composite pParent) {
        Control bar = super.createButtonBar(pParent);
        bar.setLayoutData((Object)GridDataFactory.swtDefaults().hint(1, 1).create());
        return bar;
    }

    protected int getShellStyle() {
        return this.fShellStyle;
    }

    private void fixLayout(Composite parent) {
        ((GridLayout)parent.getLayout()).marginHeight = 0;
        ((GridLayout)parent.getLayout()).marginBottom = 0;
        ((GridLayout)parent.getLayout()).marginLeft = 0;
        ((GridLayout)parent.getLayout()).marginRight = 0;
        ((GridLayout)parent.getLayout()).marginWidth = 0;
        ((GridLayout)parent.getLayout()).marginTop = 0;
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)parent);
    }

    public int open() {
        this.setBlockOnOpen(false);
        int result = super.open();
        if (result == 0) {
            this.fTipComposite.setTipManager(this.fTipManager);
        }
        return result;
    }

    protected void configureShell(Shell pNewShell) {
        super.configureShell(pNewShell);
        Image pluginImage = DefaultTipManager.getImage("icons/lightbulb.png", this.resourceManager);
        if (pluginImage != null) {
            pNewShell.setImage(pluginImage);
        }
    }
}

