/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.core.internal.parser;

import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import java.io.IOException;
import java.io.Reader;
import org.eclipse.tm4e.core.internal.parser.PListContentHandler;
import org.eclipse.tm4e.core.internal.parser.PListParser;
import org.eclipse.tm4e.core.internal.parser.PListPath;
import org.eclipse.tm4e.core.internal.parser.PropertySettable;
import org.xml.sax.SAXException;

public final class PListParserJSON<T>
implements PListParser<T> {
    private final PropertySettable.Factory<PListPath> objectFactory;

    public PListParserJSON(PropertySettable.Factory<PListPath> objectFactory) {
        this.objectFactory = objectFactory;
    }

    @Override
    public T parse(Reader contents) throws IOException, SAXException {
        PListContentHandler pList = new PListContentHandler(this.objectFactory);
        Throwable throwable = null;
        Object var4_5 = null;
        try (JsonReader reader = new JsonReader(contents);){
            boolean parsing = true;
            pList.startElement(null, "plist", null, null);
            while (parsing) {
                JsonToken nextToken = reader.peek();
                switch (nextToken) {
                    case BEGIN_ARRAY: {
                        pList.startElement(null, "array", null, null);
                        reader.beginArray();
                        break;
                    }
                    case END_ARRAY: {
                        pList.endElement(null, "array", null);
                        reader.endArray();
                        break;
                    }
                    case BEGIN_OBJECT: {
                        pList.startElement(null, "dict", null, null);
                        reader.beginObject();
                        break;
                    }
                    case END_OBJECT: {
                        pList.endElement(null, "dict", null);
                        reader.endObject();
                        break;
                    }
                    case NAME: {
                        pList.startElement(null, "key", null, null);
                        pList.characters(reader.nextName());
                        pList.endElement(null, "key", null);
                        break;
                    }
                    case NULL: {
                        reader.nextNull();
                        break;
                    }
                    case BOOLEAN: {
                        reader.nextBoolean();
                        break;
                    }
                    case NUMBER: {
                        reader.nextLong();
                        break;
                    }
                    case STRING: {
                        pList.startElement(null, "string", null, null);
                        pList.characters(reader.nextString());
                        pList.endElement(null, "string", null);
                        break;
                    }
                    case END_DOCUMENT: {
                        parsing = false;
                        break;
                    }
                }
            }
            pList.endElement(null, "plist", null);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return pList.getResult();
    }
}

