/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.graph.core.graph.historytree;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.graph.core.base.IGraphWorker;
import org.eclipse.tracecompass.analysis.graph.core.graph.ITmfEdge;
import org.eclipse.tracecompass.analysis.graph.core.graph.ITmfEdgeContextState;
import org.eclipse.tracecompass.analysis.graph.core.graph.ITmfGraph;
import org.eclipse.tracecompass.analysis.graph.core.graph.ITmfVertex;
import org.eclipse.tracecompass.analysis.graph.core.graph.WorkerSerializer;
import org.eclipse.tracecompass.internal.analysis.graph.core.Activator;
import org.eclipse.tracecompass.internal.analysis.graph.core.base.Messages;
import org.eclipse.tracecompass.internal.analysis.graph.core.graph.historytree.GraphHistoryTree;
import org.eclipse.tracecompass.internal.analysis.graph.core.graph.historytree.GraphTreeNode;
import org.eclipse.tracecompass.internal.analysis.graph.core.graph.historytree.TmfEdge;
import org.eclipse.tracecompass.internal.analysis.graph.core.graph.historytree.TmfEdgeInterval;
import org.eclipse.tracecompass.internal.analysis.graph.core.graph.historytree.TmfVertex;
import org.eclipse.tracecompass.statesystem.core.exceptions.TimeRangeException;
import org.eclipse.tracecompass.tmf.core.timestamp.ITmfTimestamp;

public abstract class HistoryTreeTmfGraph
implements ITmfGraph {
    public static final int MAX_CHILDREN = 50;
    public static final int BLOCK_SIZE = 65536;
    private static final int WORKER_SECTION_MAGIC_NUMBER = 46067558;
    private final GraphHistoryTree fSht;
    private volatile boolean fFinishedBuilding = false;
    private BiMap<IGraphWorker, Integer> fWorkerAttrib = HashBiMap.create();
    private Map<Integer, TmfVertex> fCurrentWorkerLatestTime = new HashMap<Integer, TmfVertex>();
    private int fCount = 0;
    private final long fStartTime;
    private final WorkerSerializer fWorkerSerializer;

    public HistoryTreeTmfGraph(Path newStateFile, int version, WorkerSerializer workerSerializer, long startTime) throws IOException {
        this.fWorkerSerializer = workerSerializer;
        this.fSht = this.createHistoryTree(newStateFile, version, startTime);
        this.fStartTime = startTime;
    }

    protected abstract GraphHistoryTree createHistoryTree(Path var1, int var2, long var3) throws IOException;

    public GraphHistoryTree getSHT() {
        return Objects.requireNonNull(this.fSht);
    }

    public void finishedBuilding(long endTime) {
        this.getSHT().closeTree(endTime);
        this.fFinishedBuilding = true;
    }

    protected void setFinishedBuilding(boolean finishedBuilding) {
        this.fFinishedBuilding = finishedBuilding;
    }

    public void removeFiles() {
        this.getSHT().deleteFile();
    }

    public long getFileSize() {
        return this.getSHT().getFileSize();
    }

    protected BiMap<IGraphWorker, Integer> getWorkerAttrib() {
        return this.fWorkerAttrib;
    }

    @Override
    public ITmfVertex createVertex(IGraphWorker worker, long timestamp) {
        Integer attribute = (Integer)this.fWorkerAttrib.computeIfAbsent((Object)worker, graphWorker -> this.fCount++);
        return new TmfVertex(timestamp, attribute);
    }

    private void checkCurrentWorkerTime(TmfVertex vertex) {
        ITmfVertex latest = this.fCurrentWorkerLatestTime.get(vertex.getWorkerId());
        if (latest != null && latest.getTimestamp() > vertex.getTimestamp()) {
            throw new IllegalArgumentException("Vertex is earlier than latest time for this worker");
        }
    }

    @Override
    public void add(ITmfVertex vertex) {
        if (!(vertex instanceof TmfVertex)) {
            throw new IllegalArgumentException("Wrong vertex class");
        }
        this.checkCurrentWorkerTime((TmfVertex)vertex);
        int attribute = ((TmfVertex)vertex).getWorkerId();
        TmfVertex latestVertex = this.fCurrentWorkerLatestTime.get(attribute);
        if (latestVertex != null && vertex.getTimestamp() == latestVertex.getTimestamp()) {
            return;
        }
        if (latestVertex == null && vertex.getTimestamp() != this.fStartTime) {
            this.getSHT().insert(TmfEdgeInterval.fillerEdge((TmfVertex)vertex, this.fStartTime));
        } else if (latestVertex != null) {
            this.getSHT().insert(TmfEdgeInterval.nullEdge(latestVertex, (TmfVertex)vertex));
        }
        this.fCurrentWorkerLatestTime.put(attribute, (TmfVertex)vertex);
    }

    @Override
    public @Nullable ITmfEdge append(ITmfVertex vertex, ITmfEdgeContextState contextState) {
        return this.append(vertex, contextState, "");
    }

    @Override
    public @Nullable ITmfEdge append(ITmfVertex vertex, ITmfEdgeContextState contextState, @Nullable String linkQualifier) {
        TmfEdgeInterval edge;
        if (!(vertex instanceof TmfVertex)) {
            throw new IllegalArgumentException("Wrong vertex class");
        }
        this.checkCurrentWorkerTime((TmfVertex)vertex);
        int attribute = ((TmfVertex)vertex).getWorkerId();
        TmfVertex latestVertex = this.fCurrentWorkerLatestTime.get(attribute);
        if (latestVertex != null && vertex.getTimestamp() == latestVertex.getTimestamp()) {
            return null;
        }
        this.fCurrentWorkerLatestTime.put(attribute, (TmfVertex)vertex);
        TmfEdgeInterval tmfEdgeInterval = latestVertex != null ? TmfEdgeInterval.horizontalEdge(latestVertex, (TmfVertex)vertex, contextState, linkQualifier) : (edge = this.fStartTime < vertex.getTimestamp() ? TmfEdgeInterval.fillerEdge((TmfVertex)vertex, this.fStartTime) : null);
        if (edge != null) {
            this.getSHT().insert(edge);
        }
        return edge != null ? edge.getEdge() : null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public @Nullable ITmfEdge getEdgeFrom(ITmfVertex node, ITmfGraph.EdgeDirection direction) {
        if (!(node instanceof TmfVertex)) {
            throw new IllegalArgumentException("Wrong vertex class");
        }
        TmfVertex vertex = (TmfVertex)node;
        TmfEdgeInterval edgeInterval = null;
        try {
            GraphHistoryTree backend = this.getSHT();
            switch (direction) {
                case INCOMING_HORIZONTAL_EDGE: {
                    if (vertex.getTimestamp() == backend.getTreeStart()) {
                        return null;
                    }
                    edgeInterval = backend.queryEdgeTo(vertex, true);
                    break;
                }
                case INCOMING_VERTICAL_EDGE: {
                    edgeInterval = backend.queryEdgeTo(vertex, false);
                    break;
                }
                case OUTGOING_HORIZONTAL_EDGE: {
                    edgeInterval = backend.queryEdgeFrom(vertex, true);
                    break;
                }
                case OUTGOING_VERTICAL_EDGE: {
                    edgeInterval = backend.queryEdgeFrom(vertex, false);
                    break;
                }
            }
        }
        catch (ClosedChannelException closedChannelException) {
            // empty catch block
        }
        if (edgeInterval == null) {
            return null;
        }
        TmfEdge tmfEdge = edgeInterval.getEdge();
        return tmfEdge;
    }

    @Override
    public @Nullable ITmfEdge edge(ITmfVertex from, ITmfVertex to, ITmfEdgeContextState contextState) {
        return this.edge(from, to, contextState, "");
    }

    @Override
    public @Nullable ITmfEdge edge(ITmfVertex from, ITmfVertex to, ITmfEdgeContextState contextState, String linkQualifier) {
        if (!(from instanceof TmfVertex) || !(to instanceof TmfVertex)) {
            throw new IllegalArgumentException("Wrong vertex class");
        }
        TmfVertex fromVertex = (TmfVertex)from;
        TmfVertex toVertex = (TmfVertex)to;
        if (from.equals(to)) {
            throw new IllegalArgumentException("A node cannot link to itself");
        }
        if (!this.isVertexInGraph(from)) {
            throw new IllegalArgumentException(Messages.TmfGraph_FromNotInGraph);
        }
        boolean toInGraph = this.isVertexInGraph(to);
        if (fromVertex.getWorkerId() == toVertex.getWorkerId()) {
            return this.append(to, contextState, linkQualifier);
        }
        if (!toInGraph) {
            this.add(to);
        }
        TmfEdgeInterval edge = TmfEdgeInterval.verticalEdge(fromVertex, toVertex, contextState, linkQualifier);
        this.getSHT().insert(edge);
        return edge.getEdge();
    }

    @Override
    public @Nullable ITmfEdge edgeVertical(ITmfVertex from, ITmfVertex to, ITmfEdgeContextState contextState, @Nullable String linkQualifier) {
        if (!(from instanceof TmfVertex) || !(to instanceof TmfVertex)) {
            throw new IllegalArgumentException("Wrong vertex class");
        }
        TmfVertex fromVertex = (TmfVertex)from;
        TmfVertex toVertex = (TmfVertex)to;
        if (from.equals(to)) {
            throw new IllegalArgumentException("A node cannot link to itself");
        }
        if (!this.isVertexInGraph(from) || !this.isVertexInGraph(to)) {
            throw new IllegalArgumentException("One of the nodes in the vertical link is not in the graph");
        }
        TmfEdgeInterval edge = TmfEdgeInterval.verticalEdge(fromVertex, toVertex, contextState, linkQualifier);
        this.getSHT().insert(edge);
        return edge.getEdge();
    }

    private boolean isVertexInGraph(ITmfVertex vertex) {
        if (!(vertex instanceof TmfVertex)) {
            throw new IllegalArgumentException("Wrong vertex class");
        }
        TmfVertex ts = this.fCurrentWorkerLatestTime.get(((TmfVertex)vertex).getWorkerId());
        if (ts == null || vertex.getTimestamp() > ts.getTimestamp()) {
            return false;
        }
        if (vertex.getTimestamp() == ts.getTimestamp()) {
            return true;
        }
        TmfEdgeInterval edge = null;
        try {
            edge = this.getSHT().queryVertex((TmfVertex)vertex);
        }
        catch (ClosedChannelException closedChannelException) {
            // empty catch block
        }
        return edge != null;
    }

    @Override
    public @Nullable ITmfVertex getTail(IGraphWorker worker) {
        Integer attribute = (Integer)this.fWorkerAttrib.get((Object)worker);
        if (attribute == null) {
            return null;
        }
        GraphHistoryTree backend = this.getSHT();
        try {
            TmfEdge edge;
            long currentEndTime = backend.getTreeEnd();
            TmfEdgeInterval interval = backend.queryEdgeFrom(new TmfVertex(currentEndTime, attribute), true);
            TmfEdge tmfEdge = edge = interval == null ? null : interval.getEdge();
            if (edge == null && interval != null && interval.getIntervalType() == TmfEdgeInterval.EdgeIntervalType.FILLER) {
                return new TmfVertex(interval.getStart(), interval.getFromWorkerId());
            }
            return edge == null ? (ITmfVertex)this.fCurrentWorkerLatestTime.get(attribute) : edge.getVertexTo();
        }
        catch (ClosedChannelException closedChannelException) {
            return null;
        }
    }

    @Override
    public @Nullable ITmfVertex getHead(IGraphWorker worker) {
        Integer attribute = (Integer)this.fWorkerAttrib.get((Object)worker);
        if (attribute == null) {
            return null;
        }
        return this.getHeadForAttribute(attribute);
    }

    @Override
    public @Nullable ITmfVertex getHead() {
        return this.getHeadForAttribute(0);
    }

    @Override
    public ITmfVertex getHead(ITmfVertex vertex) {
        ITmfVertex headVertex = vertex;
        ITmfEdge edgeFrom = this.getEdgeFrom(vertex, ITmfGraph.EdgeDirection.INCOMING_HORIZONTAL_EDGE);
        while (edgeFrom != null) {
            headVertex = edgeFrom.getVertexFrom();
            edgeFrom = this.getEdgeFrom(headVertex, ITmfGraph.EdgeDirection.INCOMING_HORIZONTAL_EDGE);
        }
        return headVertex;
    }

    private @Nullable ITmfVertex getHeadForAttribute(int attribute) {
        try {
            TmfEdgeInterval edge = this.getSHT().queryEdgeFrom(new TmfVertex(this.fStartTime, attribute), true);
            if (edge != null && edge.getIntervalType() == TmfEdgeInterval.EdgeIntervalType.FILLER) {
                return edge.getVertexTo();
            }
            return edge != null ? Objects.requireNonNull(edge.getEdge()).getVertexFrom() : null;
        }
        catch (ClosedChannelException closedChannelException) {
            return null;
        }
    }

    @Override
    public Iterator<ITmfVertex> getNodesOf(IGraphWorker worker) {
        final GraphHistoryTree backend = this.getSHT();
        final Integer attribute = (Integer)this.fWorkerAttrib.get((Object)worker);
        if (attribute == null) {
            return Objects.requireNonNull(Collections.emptyIterator());
        }
        final long currentEndTime = this.fFinishedBuilding ? backend.getTreeEnd() : backend.getTreeEnd() + 1L;
        return new Iterator<ITmfVertex>(){
            private boolean fGotFirst = false;
            private @Nullable TmfEdgeInterval fCurrentInterval = null;
            private long nextQueryTime;
            {
                this.nextQueryTime = graphHistoryTree.getTreeStart();
            }

            @Override
            public boolean hasNext() {
                if (this.fCurrentInterval != null) {
                    return true;
                }
                if (this.nextQueryTime > currentEndTime) {
                    return false;
                }
                try {
                    TmfEdgeInterval edge;
                    this.fCurrentInterval = edge = backend.queryEdgeFrom(new TmfVertex(this.nextQueryTime, attribute), true);
                    return edge != null && (!this.fGotFirst || edge.getIntervalType() != TmfEdgeInterval.EdgeIntervalType.FILLER);
                }
                catch (ClosedChannelException | TimeRangeException throwable) {
                    return false;
                }
            }

            @Override
            public ITmfVertex next() {
                this.hasNext();
                TmfEdgeInterval next = this.fCurrentInterval;
                if (next == null) {
                    throw new NoSuchElementException();
                }
                if (!this.fGotFirst) {
                    this.fGotFirst = true;
                    if (next.getIntervalType() != TmfEdgeInterval.EdgeIntervalType.FILLER) {
                        return next.getVertexFrom();
                    }
                }
                this.fCurrentInterval = null;
                this.nextQueryTime = Math.min(currentEndTime, next.getVertexTo().getTimestamp());
                return next.getVertexTo();
            }
        };
    }

    @Override
    public @Nullable IGraphWorker getParentOf(ITmfVertex node) {
        if (!(node instanceof TmfVertex)) {
            throw new IllegalArgumentException("Wrong vertex class");
        }
        return (IGraphWorker)this.fWorkerAttrib.inverse().get((Object)((TmfVertex)node).getWorkerId());
    }

    public Set<IGraphWorker> getWorkers() {
        return this.fWorkerAttrib.keySet();
    }

    @Override
    public @Nullable ITmfVertex getVertexAt(ITmfTimestamp startTime, IGraphWorker worker) {
        try {
            TmfVertex vertex = (TmfVertex)this.createVertex(worker, startTime.toNanos());
            TmfEdgeInterval edge = this.getSHT().queryVertex(vertex);
            return edge != null ? (edge.getVertexFrom().equals(vertex) ? edge.getVertexFrom() : edge.getVertexTo()) : null;
        }
        catch (ClosedChannelException closedChannelException) {
            return null;
        }
    }

    @Override
    public boolean isDoneBuilding() {
        return this.fFinishedBuilding;
    }

    @Override
    public void closeGraph(long endTime) {
        GraphHistoryTree backend = this.getSHT();
        for (Integer attribute : this.fWorkerAttrib.values()) {
            TmfVertex latest = this.fCurrentWorkerLatestTime.get(attribute);
            if (latest == null || latest.getTimestamp() == endTime) continue;
            backend.insert(TmfEdgeInterval.fillerEdge(latest, endTime));
        }
        backend.closeTree(endTime);
        this.writeWorkers(backend);
        this.fFinishedBuilding = true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void writeWorkers(GraphHistoryTree backend) {
        File file = backend.supplyATWriterFile();
        long pos = backend.supplyATWriterFilePos();
        try {
            Throwable throwable = null;
            Object var6_7 = null;
            try {
                FileOutputStream fos = new FileOutputStream(file, true);
                try {
                    try (FileChannel fc = fos.getChannel();){
                        fc.position(pos);
                        Throwable throwable2 = null;
                        Object var10_14 = null;
                        try (ObjectOutputStream oos = new ObjectOutputStream(fos);){
                            oos.writeInt(46067558);
                            oos.writeInt(this.fWorkerAttrib.size());
                            for (Map.Entry entry : this.fWorkerAttrib.entrySet()) {
                                oos.writeInt((Integer)entry.getValue());
                                oos.writeObject(this.fWorkerSerializer.serialize((IGraphWorker)entry.getKey()));
                            }
                        }
                        catch (Throwable throwable3) {
                            if (throwable2 == null) {
                                throwable2 = throwable3;
                                throw throwable2;
                            } else {
                                if (throwable2 == throwable3) throw throwable2;
                                throwable2.addSuppressed(throwable3);
                            }
                            throw throwable2;
                        }
                    }
                    if (fos == null) return;
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    if (fos == null) throw throwable;
                    fos.close();
                    throw throwable;
                }
                fos.close();
                return;
            }
            catch (Throwable throwable5) {
                if (throwable == null) {
                    throwable = throwable5;
                    throw throwable;
                } else {
                    if (throwable == throwable5) throw throwable;
                    throwable.addSuppressed(throwable5);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            Activator.getInstance().logError("Error writing the file " + file, (Throwable)e);
        }
    }

    protected void readWorkers(GraphHistoryTree sht) throws IOException {
        FileInputStream wris = sht.supplyATReader();
        ObjectInputStream ois = new ObjectInputStream(new BufferedInputStream(wris));
        int res = ois.readInt();
        if (res != 46067558) {
            throw new IOException("The graph worker file section is either invalid or corrupted.");
        }
        int workerCount = ois.readInt();
        int i = 0;
        while (i < workerCount) {
            try {
                int workerAttrib = ois.readInt();
                String serializedWorker = (String)ois.readObject();
                IGraphWorker worker = this.fWorkerSerializer.deserialize(serializedWorker);
                this.fWorkerAttrib.put((Object)worker, (Object)workerAttrib);
            }
            catch (ClassNotFoundException e) {
                throw new IOException("Unrecognizable attribute list");
            }
            ++i;
        }
    }

    @Override
    public void dispose() {
        if (this.fFinishedBuilding) {
            this.getSHT().closeFile();
        } else {
            this.getSHT().deleteFile();
        }
    }

    public int getAverageNodeUsage(int sampleSize) {
        long total = 0L;
        int nodeCount = this.getSHT().getNodeCount();
        int step = 1;
        if (sampleSize >= 1) {
            step = Math.max(1, nodeCount / sampleSize);
        }
        try {
            int seq = 0;
            while (seq < nodeCount) {
                GraphTreeNode node = this.getSHT().readNode(seq);
                total += node.getNodeUsagePercent();
                seq += step;
            }
        }
        catch (ClosedChannelException e) {
            System.out.println("In the catch of Closed channel exception");
        }
        long ret = total / (long)nodeCount;
        if (ret < 0L || ret > 100L) {
            throw new IllegalStateException("Average node usage is not a percentage: " + ret);
        }
        return (int)ret;
    }
}

