/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.texteditor;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.text.quickassist.IQuickAssistAssistant;
import org.eclipse.jface.text.quickassist.IQuickFixableAnnotation;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationAccess;
import org.eclipse.jface.text.source.IAnnotationAccessExtension;
import org.eclipse.jface.text.source.IAnnotationAccessExtension2;
import org.eclipse.jface.text.source.IAnnotationPresentation;
import org.eclipse.jface.text.source.ImageUtilities;
import org.eclipse.jface.text.source.projection.AnnotationBag;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.editors.text.EditorsPlugin;
import org.eclipse.ui.internal.texteditor.AnnotationType;
import org.eclipse.ui.internal.texteditor.AnnotationTypeHierarchy;
import org.eclipse.ui.texteditor.AnnotationPreference;
import org.eclipse.ui.texteditor.AnnotationPreferenceLookup;
import org.eclipse.ui.texteditor.IAnnotationImageProvider;
import org.eclipse.ui.texteditor.MarkerAnnotationPreferences;

public class DefaultMarkerAnnotationAccess
implements IAnnotationAccess,
IAnnotationAccessExtension,
IAnnotationAccessExtension2 {
    @Deprecated
    public static final String UNKNOWN = "org.eclipse.text.annotation.unknown";
    public static final String ERROR_SYSTEM_IMAGE = "error";
    public static final String WARNING_SYSTEM_IMAGE = "warning";
    public static final String INFO_SYSTEM_IMAGE = "info";
    public static final String TASK_SYSTEM_IMAGE = "task";
    public static final String BOOKMARK_SYSTEM_IMAGE = "bookmark";
    private static final Map<String, String> MAPPING = new HashMap<String, String>();
    @Deprecated
    protected MarkerAnnotationPreferences fMarkerAnnotationPreferences;
    private IQuickAssistAssistant fQuickAssistAssistant;

    static {
        MAPPING.put(ERROR_SYSTEM_IMAGE, "IMG_OBJS_ERROR_TSK");
        MAPPING.put(WARNING_SYSTEM_IMAGE, "IMG_OBJS_WARN_TSK");
        MAPPING.put(INFO_SYSTEM_IMAGE, "IMG_OBJS_INFO_TSK");
        MAPPING.put(TASK_SYSTEM_IMAGE, "IMG_OBJS_TASK_TSK");
        MAPPING.put(BOOKMARK_SYSTEM_IMAGE, "IMG_OBJS_BKMRK_TSK");
    }

    @Deprecated
    public DefaultMarkerAnnotationAccess(MarkerAnnotationPreferences markerAnnotationPreferences) {
        this.fMarkerAnnotationPreferences = markerAnnotationPreferences;
    }

    public DefaultMarkerAnnotationAccess() {
    }

    public void setQuickAssistAssistant(IQuickAssistAssistant assistant) {
        this.fQuickAssistAssistant = assistant;
    }

    private AnnotationPreference getAnnotationPreference(Annotation annotation) {
        AnnotationPreferenceLookup lookup = this.getAnnotationPreferenceLookup();
        if (lookup != null) {
            return lookup.getAnnotationPreference(annotation);
        }
        return null;
    }

    protected AnnotationPreferenceLookup getAnnotationPreferenceLookup() {
        return EditorsPlugin.getDefault().getAnnotationPreferenceLookup();
    }

    @Deprecated
    public Object getType(Annotation annotation) {
        return annotation.getType();
    }

    @Deprecated
    public boolean isMultiLine(Annotation annotation) {
        return true;
    }

    @Deprecated
    public boolean isTemporary(Annotation annotation) {
        return !annotation.isPersistent();
    }

    public String getTypeLabel(Annotation annotation) {
        AnnotationPreference preference = this.getAnnotationPreference(annotation);
        return preference != null ? preference.getPreferenceLabel() : null;
    }

    /*
     * WARNING - void declaration
     */
    public int getLayer(Annotation annotation) {
        Annotation annotation2 = annotation;
        if (annotation2 instanceof IAnnotationPresentation) {
            void presentation;
            IAnnotationPresentation iAnnotationPresentation = (IAnnotationPresentation)annotation2;
            IAnnotationPresentation cfr_ignored_0 = (IAnnotationPresentation)annotation2;
            return presentation.getLayer();
        }
        AnnotationPreference preference = this.getAnnotationPreference(annotation);
        if (preference != null) {
            return preference.getPresentationLayer();
        }
        try {
            Method method = annotation.getClass().getMethod("getLayer", new Class[0]);
            Integer result = (Integer)method.invoke((Object)annotation, new Object[0]);
            return result;
        }
        catch (SecurityException securityException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {}
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    public void paint(Annotation annotation, GC gc, Canvas canvas, Rectangle bounds) {
        Object type;
        String annotationType;
        Image image;
        Annotation annotation2 = annotation;
        if (annotation2 instanceof IAnnotationPresentation) {
            void presentation;
            IAnnotationPresentation iAnnotationPresentation = (IAnnotationPresentation)annotation2;
            IAnnotationPresentation cfr_ignored_0 = (IAnnotationPresentation)annotation2;
            presentation.paint(gc, canvas, bounds);
            return;
        }
        AnnotationPreference preference = this.getAnnotationPreference(annotation);
        if (preference != null && (image = this.getImage(annotation, preference, annotationType = (type = this.getType(annotation)) == null ? null : type.toString())) != null) {
            ImageUtilities.drawImage((Image)image, (GC)gc, (Canvas)canvas, (Rectangle)bounds, (int)0x1000000, (int)128);
            return;
        }
        try {
            Method method = annotation.getClass().getMethod("paint", GC.class, Canvas.class, Rectangle.class);
            method.invoke((Object)annotation, gc, canvas, bounds);
        }
        catch (SecurityException securityException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {}
    }

    public boolean isPaintable(Annotation annotation) {
        if (annotation instanceof IAnnotationPresentation) {
            return true;
        }
        AnnotationPreference preference = this.getAnnotationPreference(annotation);
        if (preference == null) {
            return false;
        }
        Object type = this.getType(annotation);
        String annotationType = type == null ? null : type.toString();
        Image image = this.getImage(annotation, preference, annotationType);
        return image != null;
    }

    public boolean isSubtype(Object annotationType, Object potentialSupertype) {
        AnnotationTypeHierarchy hierarchy = this.getAnnotationTypeHierarchy();
        return hierarchy.isSubtype(potentialSupertype.toString(), annotationType.toString());
    }

    public Object[] getSupertypes(Object annotationType) {
        AnnotationTypeHierarchy hierarchy = this.getAnnotationTypeHierarchy();
        AnnotationType type = hierarchy.getAnnotationType(annotationType.toString());
        return type.getSuperTypes();
    }

    protected AnnotationTypeHierarchy getAnnotationTypeHierarchy() {
        return EditorsPlugin.getDefault().getAnnotationTypeHierarchy();
    }

    public static String getSharedImageName(String symbolicImageName) {
        Assert.isLegal((symbolicImageName != null ? 1 : 0) != 0);
        String sharedImageName = MAPPING.get(symbolicImageName);
        Assert.isLegal((sharedImageName != null ? 1 : 0) != 0);
        return sharedImageName;
    }

    /*
     * WARNING - void declaration
     */
    private Image getImage(Annotation annotation, AnnotationPreference preference, String annotationType) {
        ImageDescriptor quickFixImageDesc;
        Image image;
        Annotation annotation2 = annotation;
        if (annotation2 instanceof AnnotationBag) {
            void bag;
            AnnotationBag annotationBag = (AnnotationBag)annotation2;
            AnnotationBag cfr_ignored_0 = (AnnotationBag)annotation2;
            if (!bag.isEmpty()) {
                annotation = (Annotation)bag.iterator().next();
            }
        }
        ImageRegistry registry = EditorsPlugin.getDefault().getImageRegistry();
        IAnnotationImageProvider annotationImageProvider = preference.getAnnotationImageProvider();
        if (annotationImageProvider != null) {
            image = annotationImageProvider.getManagedImage(annotation);
            if (image != null) {
                return image;
            }
            String id = annotationImageProvider.getImageDescriptorId(annotation);
            if (id != null) {
                image = registry.get(id);
                if (image == null) {
                    ImageDescriptor descriptor = annotationImageProvider.getImageDescriptor(id);
                    registry.put(id, descriptor);
                    image = registry.get(id);
                }
                return image;
            }
        }
        if (annotationType == null) {
            return null;
        }
        if (this.hasQuickFix(annotation) && (quickFixImageDesc = preference.getQuickFixImageDescriptor()) != null) {
            Image image2 = registry.get(quickFixImageDesc.toString());
            if (image2 == null) {
                registry.put(quickFixImageDesc.toString(), quickFixImageDesc);
                image2 = registry.get(quickFixImageDesc.toString());
            }
            if (image2 != null) {
                return image2;
            }
        }
        if ((image = registry.get(annotationType)) == null) {
            ImageDescriptor descriptor = preference.getImageDescriptor();
            if (descriptor != null) {
                registry.put(annotationType, descriptor);
                image = registry.get(annotationType);
            } else {
                String key;
                String symbolicImageName = preference.getSymbolicImageName();
                if (symbolicImageName != null && (key = DefaultMarkerAnnotationAccess.getSharedImageName(preference.getSymbolicImageName())) != null) {
                    ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
                    image = sharedImages.getImage(key);
                }
            }
        }
        return image;
    }

    /*
     * WARNING - void declaration
     */
    protected boolean hasQuickFix(Annotation annotation) {
        Annotation annotation2 = annotation;
        if (annotation2 instanceof IQuickFixableAnnotation) {
            void quickFixableAnnotation;
            IQuickFixableAnnotation iQuickFixableAnnotation = (IQuickFixableAnnotation)annotation2;
            IQuickFixableAnnotation cfr_ignored_0 = (IQuickFixableAnnotation)annotation2;
            if (!quickFixableAnnotation.isQuickFixableStateSet()) {
                quickFixableAnnotation.setQuickFixable(this.fQuickAssistAssistant != null && this.fQuickAssistAssistant.canFix(annotation));
            }
            return quickFixableAnnotation.isQuickFixable();
        }
        return false;
    }
}

