/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.core.controls;

import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class CImageLabel
extends Canvas {
    private static final int SPACE = 5;
    private Image m_image;
    private String m_text;
    private Image m_backImage;

    public CImageLabel(Composite parent, int style) {
        super(parent, style | 0x40000);
        this.addListener(12, new Listener(){

            public void handleEvent(Event event) {
                if (CImageLabel.this.m_backImage != null) {
                    CImageLabel.this.m_backImage.dispose();
                    CImageLabel.this.m_backImage = null;
                }
            }
        });
        this.addListener(9, new Listener(){

            public void handleEvent(Event event) {
                CImageLabel.this.doPaint(event.gc);
            }
        });
    }

    public Image getImage() {
        return this.m_image;
    }

    public void setImage(Image image) {
        this.m_image = image;
        this.redraw();
    }

    public String getText() {
        return this.m_text;
    }

    public void setText(String text) {
        this.m_text = text;
        this.redraw();
    }

    private void doPaint(GC paintGC) {
        int y;
        int x;
        Rectangle imageBounds;
        Rectangle clientArea = this.getClientArea();
        if (this.m_backImage == null || !this.m_backImage.getBounds().equals((Object)clientArea)) {
            if (this.m_backImage != null) {
                this.m_backImage.dispose();
            }
            this.m_backImage = new Image((Device)this.getDisplay(), clientArea.width, clientArea.height);
        }
        GC gc = new GC((Drawable)this.m_backImage);
        gc.setBackground(paintGC.getBackground());
        gc.setForeground(paintGC.getForeground());
        gc.fillRectangle(clientArea);
        Point textExtent = this.m_text == null ? new Point(0, 0) : gc.textExtent(this.m_text);
        Rectangle rectangle = imageBounds = this.m_image == null ? new Rectangle(0, 0, 0, 0) : this.m_image.getBounds();
        if (this.m_image != null) {
            x = clientArea.x;
            y = clientArea.y + (clientArea.height - imageBounds.height) / 2;
            gc.drawImage(this.m_image, x, y);
        }
        if (this.m_text != null) {
            x = clientArea.x + imageBounds.width + 5;
            y = clientArea.y + (clientArea.height - textExtent.y) / 2;
            gc.drawText(this.m_text, x, y);
        }
        paintGC.drawImage(this.m_backImage, 0, 0);
        gc.dispose();
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        GC gc = new GC((Drawable)this);
        Point textExtent = this.m_text == null ? new Point(0, 0) : gc.textExtent(this.m_text);
        gc.dispose();
        Rectangle imageBounds = this.m_image == null ? new Rectangle(0, 0, 0, 0) : this.m_image.getBounds();
        int width = imageBounds.width + 5 + textExtent.x;
        int height = Math.max(imageBounds.height, textExtent.y);
        return new Point(width, height);
    }
}

